/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.types.OFValueType;

public class OFBitMask256
implements OFValueType<OFBitMask256> {
    static final int LENGTH = 32;
    private final long raw1;
    private final long raw2;
    private final long raw3;
    private final long raw4;
    public static final OFBitMask256 ALL = new OFBitMask256(-1L, -1L, -1L, -1L);
    public static final OFBitMask256 NONE = new OFBitMask256(0L, 0L, 0L, 0L);
    public static final OFBitMask256 NO_MASK = ALL;
    public static final OFBitMask256 FULL_MASK = NONE;

    private OFBitMask256(long raw1, long raw2, long raw3, long raw4) {
        this.raw1 = raw1;
        this.raw2 = raw2;
        this.raw3 = raw3;
        this.raw4 = raw4;
    }

    public static OFBitMask256 of(long raw1, long raw2, long raw3, long raw4) {
        if (raw1 == -1L && raw2 == -1L && raw3 == -1L && raw4 == -1L) {
            return ALL;
        }
        if (raw1 == 0L && raw2 == 0L && raw3 == 0L && raw4 == 0L) {
            return NONE;
        }
        return new OFBitMask256(raw1, raw2, raw3, raw4);
    }

    @Override
    public int getLength() {
        return 32;
    }

    @Override
    public OFBitMask256 applyMask(OFBitMask256 mask) {
        return OFBitMask256.of(this.raw1 & mask.raw1, this.raw2 & mask.raw2, this.raw3 & mask.raw3, this.raw4 & mask.raw4);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.raw1 ^ this.raw1 >>> 32);
        result = 31 * result + (int)(this.raw2 ^ this.raw2 >>> 32);
        result = 31 * result + (int)(this.raw3 ^ this.raw3 >>> 32);
        result = 31 * result + (int)(this.raw4 ^ this.raw4 >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBitMask256 other = (OFBitMask256)obj;
        if (this.raw1 != other.raw1) {
            return false;
        }
        if (this.raw2 != other.raw2) {
            return false;
        }
        if (this.raw3 != other.raw3) {
            return false;
        }
        return this.raw4 == other.raw4;
    }

    protected static boolean isBitOn(long raw1, long raw2, long raw3, long raw4, int bit) {
        long word;
        if (bit < 0 || bit >= 256) {
            throw new IndexOutOfBoundsException();
        }
        if (bit < 64) {
            word = raw4;
        } else if (bit < 128) {
            word = raw3;
            bit -= 64;
        } else if (bit < 192) {
            word = raw2;
            bit -= 128;
        } else {
            word = raw1;
            bit -= 192;
        }
        return (word & 1L << bit) != 0L;
    }

    public void write32Bytes(ChannelBuffer cb) {
        cb.writeLong(this.raw1);
        cb.writeLong(this.raw2);
        cb.writeLong(this.raw3);
        cb.writeLong(this.raw4);
    }

    public static OFBitMask256 read32Bytes(ChannelBuffer cb) {
        long raw1 = cb.readLong();
        long raw2 = cb.readLong();
        long raw3 = cb.readLong();
        long raw4 = cb.readLong();
        return OFBitMask256.of(raw1, raw2, raw3, raw4);
    }

    public boolean isOn(int bit) {
        return OFBitMask256.isBitOn(this.raw1, this.raw2, this.raw3, this.raw4, bit);
    }

    public String toString() {
        return (String.format("%64s", Long.toBinaryString(this.raw4)) + String.format("%64s", Long.toBinaryString(this.raw3)) + String.format("%64s", Long.toBinaryString(this.raw2)) + String.format("%64s", Long.toBinaryString(this.raw1))).replaceAll(" ", "0");
    }

    @Override
    public int compareTo(OFBitMask256 o) {
        long c = this.raw1 - o.raw1;
        if (c != 0L) {
            return Long.signum(c);
        }
        c = this.raw2 - o.raw2;
        if (c != 0L) {
            return Long.signum(c);
        }
        c = this.raw3 - o.raw3;
        if (c != 0L) {
            return Long.signum(c);
        }
        return Long.signum(this.raw4 - o.raw4);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putLong(this.raw1);
        sink.putLong(this.raw2);
        sink.putLong(this.raw3);
        sink.putLong(this.raw4);
    }
}

