/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.base.Optional;
import com.google.common.hash.PrimitiveSink;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.Writeable;
import org.projectfloodlight.openflow.types.PrimitiveSinkable;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFErrorCauseData
implements Writeable,
PrimitiveSinkable {
    private static final Logger logger = LoggerFactory.getLogger(OFErrorCauseData.class);
    public static final OFErrorCauseData NONE = new OFErrorCauseData(new byte[0], OFVersion.OF_13);
    private final byte[] data;
    private final OFVersion version;

    private OFErrorCauseData(byte[] data, OFVersion version) {
        this.data = data;
        this.version = version;
    }

    public static OFErrorCauseData of(byte[] data, OFVersion version) {
        return new OFErrorCauseData(Arrays.copyOf(data, data.length), version);
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public Optional<OFMessage> getParsedMessage() {
        OFFactory factory = OFFactories.getFactory(this.version);
        try {
            OFMessage msg = factory.getReader().readFrom(ChannelBuffers.wrappedBuffer((byte[])this.data));
            if (msg != null) {
                return Optional.of((Object)msg);
            }
            return Optional.absent();
        }
        catch (OFParseError e) {
            logger.debug("Error parsing error cause data as OFMessage: {}", (Object)e.getMessage(), (Object)e);
            return Optional.absent();
        }
    }

    public static OFErrorCauseData read(ChannelBuffer bb, int length, OFVersion version) {
        byte[] bytes = ChannelUtils.readBytes(bb, length);
        return OFErrorCauseData.of(bytes, version);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putBytes(this.data);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        bb.writeBytes(this.data);
    }

    public String toString() {
        Optional<OFMessage> parsedMessage = this.getParsedMessage();
        if (parsedMessage.isPresent()) {
            return String.valueOf(parsedMessage.get());
        }
        StringBuilder b = new StringBuilder();
        b.append("[unparsed: ");
        for (int i = 0; i < this.data.length; ++i) {
            if (i > 0) {
                b.append(" ");
            }
            b.append(String.format("%02x", this.data[i]));
        }
        b.append("]");
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFErrorCauseData other = (OFErrorCauseData)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        return this.version == other.version;
    }
}

