// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import com.google.common.collect.ImmutableList;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFExpPortAdjacencyIdVer13 implements OFExpPortAdjacencyId {
    private static final Logger logger = LoggerFactory.getLogger(OFExpPortAdjacencyIdVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int MINIMUM_LENGTH = 4;

        private final static List<OFExpExtAdId> DEFAULT_AD_ID = ImmutableList.<OFExpExtAdId>of();

    // OF message fields
    private final List<OFExpExtAdId> adId;
//
    // Immutable default instance
    final static OFExpPortAdjacencyIdVer13 DEFAULT = new OFExpPortAdjacencyIdVer13(
        DEFAULT_AD_ID
    );

    // package private constructor - used by readers, builders, and factory
    OFExpPortAdjacencyIdVer13(List<OFExpExtAdId> adId) {
        if(adId == null) {
            throw new NullPointerException("OFExpPortAdjacencyIdVer13: property adId cannot be null");
        }
        this.adId = adId;
    }

    // Accessors for OF message fields
    @Override
    public int getType() {
        return 0x3;
    }

    @Override
    public List<OFExpExtAdId> getAdId() {
        return adId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFExpPortAdjacencyId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFExpPortAdjacencyId.Builder {
        final OFExpPortAdjacencyIdVer13 parentMessage;

        // OF message fields
        private boolean adIdSet;
        private List<OFExpExtAdId> adId;

        BuilderWithParent(OFExpPortAdjacencyIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getType() {
        return 0x3;
    }

    @Override
    public List<OFExpExtAdId> getAdId() {
        return adId;
    }

    @Override
    public OFExpPortAdjacencyId.Builder setAdId(List<OFExpExtAdId> adId) {
        this.adId = adId;
        this.adIdSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFExpPortAdjacencyId build() {
                List<OFExpExtAdId> adId = this.adIdSet ? this.adId : parentMessage.adId;
                if(adId == null)
                    throw new NullPointerException("Property adId must not be null");

                //
                return new OFExpPortAdjacencyIdVer13(
                    adId
                );
        }

    }

    static class Builder implements OFExpPortAdjacencyId.Builder {
        // OF message fields
        private boolean adIdSet;
        private List<OFExpExtAdId> adId;

    @Override
    public int getType() {
        return 0x3;
    }

    @Override
    public List<OFExpExtAdId> getAdId() {
        return adId;
    }

    @Override
    public OFExpPortAdjacencyId.Builder setAdId(List<OFExpExtAdId> adId) {
        this.adId = adId;
        this.adIdSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFExpPortAdjacencyId build() {
            List<OFExpExtAdId> adId = this.adIdSet ? this.adId : DEFAULT_AD_ID;
            if(adId == null)
                throw new NullPointerException("Property adId must not be null");


            return new OFExpPortAdjacencyIdVer13(
                    adId
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFExpPortAdjacencyId> {
        @Override
        public OFExpPortAdjacencyId readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 0x3
            short type = bb.readShort();
            if(type != (short) 0x3)
                throw new OFParseError("Wrong type: Expected=0x3(0x3), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            List<OFExpExtAdId> adId = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFExpExtAdIdVer13.READER);

            OFExpPortAdjacencyIdVer13 expPortAdjacencyIdVer13 = new OFExpPortAdjacencyIdVer13(
                    adId
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", expPortAdjacencyIdVer13);
            return expPortAdjacencyIdVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFExpPortAdjacencyIdVer13Funnel FUNNEL = new OFExpPortAdjacencyIdVer13Funnel();
    static class OFExpPortAdjacencyIdVer13Funnel implements Funnel<OFExpPortAdjacencyIdVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFExpPortAdjacencyIdVer13 message, PrimitiveSink sink) {
            // fixed value property type = 0x3
            sink.putShort((short) 0x3);
            // FIXME: skip funnel of length
            FunnelUtils.putList(message.adId, sink);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFExpPortAdjacencyIdVer13> {
        @Override
        public void write(ChannelBuffer bb, OFExpPortAdjacencyIdVer13 message) {
            int startIndex = bb.writerIndex();
            // fixed value property type = 0x3
            bb.writeShort((short) 0x3);
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            ChannelUtils.writeList(bb, message.adId);

            // update length field
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFExpPortAdjacencyIdVer13(");
        b.append("adId=").append(adId);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFExpPortAdjacencyIdVer13 other = (OFExpPortAdjacencyIdVer13) obj;

        if (adId == null) {
            if (other.adId != null)
                return false;
        } else if (!adId.equals(other.adId))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((adId == null) ? 0 : adId.hashCode());
        return result;
    }

}
