// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_virtual_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.jboss.netty.buffer.ChannelBuffer;

abstract class OFExperimenterStatsRequestVer13 {
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int MINIMUM_LENGTH = 24;


    public final static OFExperimenterStatsRequestVer13.Reader READER = new Reader();

    static class Reader implements OFMessageReader<OFExperimenterStatsRequest<?>> {
        @Override
        public OFExperimenterStatsRequest<?> readFrom(ChannelBuffer bb) throws OFParseError {
            if(bb.readableBytes() < MINIMUM_LENGTH)
                return null;
            int start = bb.readerIndex();
            // fixed value property version == 4
            byte version = bb.readByte();
            if(version != (byte) 0x4)
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got="+version);
            // fixed value property type == 18
            byte type = bb.readByte();
            if(type != (byte) 0x12)
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            U32.f(bb.readInt());
            // fixed value property statsType == 65535
            short statsType = bb.readShort();
            if(statsType != (short) 0xffff)
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got="+statsType);
            OFStatsRequestFlagsSerializerVer13.readFrom(bb);
            // pad: 4 bytes
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            bb.readerIndex(start);
            switch(experimenter) {
               case 0x5c16c7:
                   // discriminator value 0x5c16c7L=0x5c16c7L for class OFBsnStatsRequestVer13
                   return OFBsnStatsRequestVer13.READER.readFrom(bb);
               case 0x80f958:
                   // discriminator value 0x80f958L=0x80f958L for class OFCalientStatsRequestVer13
                   return OFCalientStatsRequestVer13.READER.readFrom(bb);
               case 0x748771:
                   // discriminator value 0x748771L=0x748771L for class OFCircuitPortsRequestVer13
                   return OFCircuitPortsRequestVer13.READER.readFrom(bb);
               case (int) 0xff000007:
                   // discriminator value 0xff000007L=0xff000007L for class OFExpOpticalExtRequestVer13
                   return OFExpOpticalExtRequestVer13.READER.readFrom(bb);
               case (int) 0xff000088:
                   // discriminator value 0xff000088L=0xff000088L for class OFOplinkStatsRequestVer13
                   return OFOplinkStatsRequestVer13.READER.readFrom(bb);
               default:
                   throw new OFParseError("Unknown value for discriminator experimenter of class OFExperimenterStatsRequestVer13: " + experimenter);
            }
        }
    }
}
