// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOplinkPortPowerVer13 implements OFOplinkPortPower {
    private static final Logger logger = LoggerFactory.getLogger(OFOplinkPortPowerVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 4;

        private final static int DEFAULT_PORT = 0x0;
        private final static int DEFAULT_POWER_VALUE = 0x0;

    // OF message fields
    private final int port;
    private final int powerValue;
//
    // Immutable default instance
    final static OFOplinkPortPowerVer13 DEFAULT = new OFOplinkPortPowerVer13(
        DEFAULT_PORT, DEFAULT_POWER_VALUE
    );

    // package private constructor - used by readers, builders, and factory
    OFOplinkPortPowerVer13(int port, int powerValue) {
        this.port = port;
        this.powerValue = powerValue;
    }

    // Accessors for OF message fields
    @Override
    public int getPort() {
        return port;
    }

    @Override
    public int getPowerValue() {
        return powerValue;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFOplinkPortPower.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOplinkPortPower.Builder {
        final OFOplinkPortPowerVer13 parentMessage;

        // OF message fields
        private boolean portSet;
        private int port;
        private boolean powerValueSet;
        private int powerValue;

        BuilderWithParent(OFOplinkPortPowerVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getPort() {
        return port;
    }

    @Override
    public OFOplinkPortPower.Builder setPort(int port) {
        this.port = port;
        this.portSet = true;
        return this;
    }
    @Override
    public int getPowerValue() {
        return powerValue;
    }

    @Override
    public OFOplinkPortPower.Builder setPowerValue(int powerValue) {
        this.powerValue = powerValue;
        this.powerValueSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFOplinkPortPower build() {
                int port = this.portSet ? this.port : parentMessage.port;
                int powerValue = this.powerValueSet ? this.powerValue : parentMessage.powerValue;

                //
                return new OFOplinkPortPowerVer13(
                    port,
                    powerValue
                );
        }

    }

    static class Builder implements OFOplinkPortPower.Builder {
        // OF message fields
        private boolean portSet;
        private int port;
        private boolean powerValueSet;
        private int powerValue;

    @Override
    public int getPort() {
        return port;
    }

    @Override
    public OFOplinkPortPower.Builder setPort(int port) {
        this.port = port;
        this.portSet = true;
        return this;
    }
    @Override
    public int getPowerValue() {
        return powerValue;
    }

    @Override
    public OFOplinkPortPower.Builder setPowerValue(int powerValue) {
        this.powerValue = powerValue;
        this.powerValueSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFOplinkPortPower build() {
            int port = this.portSet ? this.port : DEFAULT_PORT;
            int powerValue = this.powerValueSet ? this.powerValue : DEFAULT_POWER_VALUE;


            return new OFOplinkPortPowerVer13(
                    port,
                    powerValue
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOplinkPortPower> {
        @Override
        public OFOplinkPortPower readFrom(ChannelBuffer bb) throws OFParseError {
            int port = U16.f(bb.readShort());
            int powerValue = U16.f(bb.readShort());

            OFOplinkPortPowerVer13 oplinkPortPowerVer13 = new OFOplinkPortPowerVer13(
                    port,
                      powerValue
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oplinkPortPowerVer13);
            return oplinkPortPowerVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOplinkPortPowerVer13Funnel FUNNEL = new OFOplinkPortPowerVer13Funnel();
    static class OFOplinkPortPowerVer13Funnel implements Funnel<OFOplinkPortPowerVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOplinkPortPowerVer13 message, PrimitiveSink sink) {
            sink.putInt(message.port);
            sink.putInt(message.powerValue);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOplinkPortPowerVer13> {
        @Override
        public void write(ChannelBuffer bb, OFOplinkPortPowerVer13 message) {
            bb.writeShort(U16.t(message.port));
            bb.writeShort(U16.t(message.powerValue));


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOplinkPortPowerVer13(");
        b.append("port=").append(port);
        b.append(", ");
        b.append("powerValue=").append(powerValue);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOplinkPortPowerVer13 other = (OFOplinkPortPowerVer13) obj;

        if( port != other.port)
            return false;
        if( powerValue != other.powerValue)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + port;
        result = prime * result + powerValue;
        return result;
    }

}
