/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnL3SrcClassId;
import org.projectfloodlight.openflow.protocol.oxm.OFOxms;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmBsnL3SrcClassIdVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmsVer13;
import org.projectfloodlight.openflow.types.ClassId;

public class OFOxmBsnL3SrcClassIdVer13Test {
    OFOxms factory;
    static final byte[] OXM_BSN_L3_SRC_CLASS_ID_SERIALIZED = new byte[]{0, 3, 10, 4, 18, 52, 86, 120};

    @Before
    public void setup() {
        this.factory = OFOxmsVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFOxmBsnL3SrcClassId.Builder builder = this.factory.buildBsnL3SrcClassId();
        builder.setValue(ClassId.of((int)305419896));
        OFOxmBsnL3SrcClassId oxmBsnL3SrcClassId = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        oxmBsnL3SrcClassId.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)OXM_BSN_L3_SRC_CLASS_ID_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFOxmBsnL3SrcClassId.Builder builder = this.factory.buildBsnL3SrcClassId();
        builder.setValue(ClassId.of((int)305419896));
        OFOxmBsnL3SrcClassId oxmBsnL3SrcClassIdBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])OXM_BSN_L3_SRC_CLASS_ID_SERIALIZED);
        OFOxmBsnL3SrcClassId oxmBsnL3SrcClassIdRead = OFOxmBsnL3SrcClassIdVer13.READER.readFrom(input);
        Assert.assertEquals((long)OXM_BSN_L3_SRC_CLASS_ID_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)oxmBsnL3SrcClassIdBuilt, (Object)oxmBsnL3SrcClassIdRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])OXM_BSN_L3_SRC_CLASS_ID_SERIALIZED);
        OFOxmBsnL3SrcClassId oxmBsnL3SrcClassId = OFOxmBsnL3SrcClassIdVer13.READER.readFrom(input);
        Assert.assertEquals((long)OXM_BSN_L3_SRC_CLASS_ID_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        oxmBsnL3SrcClassId.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)OXM_BSN_L3_SRC_CLASS_ID_SERIALIZED));
    }
}

