// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver12;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import com.google.common.collect.ImmutableList;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFActionNiciraNatVer12 implements OFActionNiciraNat {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraNatVer12.class);
    // version: 1.2
    final static byte WIRE_VERSION = 3;
    final static int MINIMUM_LENGTH = 16;

        private final static int DEFAULT_FLAGS = 0x0;
        private final static int DEFAULT_RANGE_PRESENT = 0x0;
        private final static List<IPv4Address> DEFAULT_IPV4_RANGE = ImmutableList.<IPv4Address>of();
        private final static List<IPv6Address> DEFAULT_IPV6_RANGE = ImmutableList.<IPv6Address>of();
        private final static List<U16> DEFAULT_PORT_RANGE = ImmutableList.<U16>of();
        private final static List<U8> DEFAULT_PAD = ImmutableList.<U8>of();

    // OF message fields
    private final int flags;
    private final int rangePresent;
    private final List<IPv4Address> ipv4Range;
    private final List<IPv6Address> ipv6Range;
    private final List<U16> portRange;
    private final List<U8> pad;
//
    // Immutable default instance
    final static OFActionNiciraNatVer12 DEFAULT = new OFActionNiciraNatVer12(
        DEFAULT_FLAGS, DEFAULT_RANGE_PRESENT, DEFAULT_IPV4_RANGE, DEFAULT_IPV6_RANGE, DEFAULT_PORT_RANGE, DEFAULT_PAD
    );

    // package private constructor - used by readers, builders, and factory
    OFActionNiciraNatVer12(int flags, int rangePresent, List<IPv4Address> ipv4Range, List<IPv6Address> ipv6Range, List<U16> portRange, List<U8> pad) {
        if(ipv4Range == null) {
            throw new NullPointerException("OFActionNiciraNatVer12: property ipv4Range cannot be null");
        }
        if(ipv6Range == null) {
            throw new NullPointerException("OFActionNiciraNatVer12: property ipv6Range cannot be null");
        }
        if(portRange == null) {
            throw new NullPointerException("OFActionNiciraNatVer12: property portRange cannot be null");
        }
        if(pad == null) {
            throw new NullPointerException("OFActionNiciraNatVer12: property pad cannot be null");
        }
        this.flags = flags;
        this.rangePresent = rangePresent;
        this.ipv4Range = ipv4Range;
        this.ipv6Range = ipv6Range;
        this.portRange = portRange;
        this.pad = pad;
    }

    // Accessors for OF message fields
    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x2320L;
    }

    @Override
    public int getSubtype() {
        return 0x24;
    }

    @Override
    public int getFlags() {
        return flags;
    }

    @Override
    public int getRangePresent() {
        return rangePresent;
    }

    @Override
    public List<IPv4Address> getIpv4Range() {
        return ipv4Range;
    }

    @Override
    public List<IPv6Address> getIpv6Range() {
        return ipv6Range;
    }

    @Override
    public List<U16> getPortRange() {
        return portRange;
    }

    @Override
    public List<U8> getPad() {
        return pad;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }



    public OFActionNiciraNat.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFActionNiciraNat.Builder {
        final OFActionNiciraNatVer12 parentMessage;

        // OF message fields
        private boolean flagsSet;
        private int flags;
        private boolean rangePresentSet;
        private int rangePresent;
        private boolean ipv4RangeSet;
        private List<IPv4Address> ipv4Range;
        private boolean ipv6RangeSet;
        private List<IPv6Address> ipv6Range;
        private boolean portRangeSet;
        private List<U16> portRange;
        private boolean padSet;
        private List<U8> pad;

        BuilderWithParent(OFActionNiciraNatVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x2320L;
    }

    @Override
    public int getSubtype() {
        return 0x24;
    }

    @Override
    public int getFlags() {
        return flags;
    }

    @Override
    public OFActionNiciraNat.Builder setFlags(int flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public int getRangePresent() {
        return rangePresent;
    }

    @Override
    public OFActionNiciraNat.Builder setRangePresent(int rangePresent) {
        this.rangePresent = rangePresent;
        this.rangePresentSet = true;
        return this;
    }
    @Override
    public List<IPv4Address> getIpv4Range() {
        return ipv4Range;
    }

    @Override
    public OFActionNiciraNat.Builder setIpv4Range(List<IPv4Address> ipv4Range) {
        this.ipv4Range = ipv4Range;
        this.ipv4RangeSet = true;
        return this;
    }
    @Override
    public List<IPv6Address> getIpv6Range() {
        return ipv6Range;
    }

    @Override
    public OFActionNiciraNat.Builder setIpv6Range(List<IPv6Address> ipv6Range) {
        this.ipv6Range = ipv6Range;
        this.ipv6RangeSet = true;
        return this;
    }
    @Override
    public List<U16> getPortRange() {
        return portRange;
    }

    @Override
    public OFActionNiciraNat.Builder setPortRange(List<U16> portRange) {
        this.portRange = portRange;
        this.portRangeSet = true;
        return this;
    }
    @Override
    public List<U8> getPad() {
        return pad;
    }

    @Override
    public OFActionNiciraNat.Builder setPad(List<U8> pad) {
        this.pad = pad;
        this.padSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }



        @Override
        public OFActionNiciraNat build() {
                int flags = this.flagsSet ? this.flags : parentMessage.flags;
                int rangePresent = this.rangePresentSet ? this.rangePresent : parentMessage.rangePresent;
                List<IPv4Address> ipv4Range = this.ipv4RangeSet ? this.ipv4Range : parentMessage.ipv4Range;
                if(ipv4Range == null)
                    throw new NullPointerException("Property ipv4Range must not be null");
                List<IPv6Address> ipv6Range = this.ipv6RangeSet ? this.ipv6Range : parentMessage.ipv6Range;
                if(ipv6Range == null)
                    throw new NullPointerException("Property ipv6Range must not be null");
                List<U16> portRange = this.portRangeSet ? this.portRange : parentMessage.portRange;
                if(portRange == null)
                    throw new NullPointerException("Property portRange must not be null");
                List<U8> pad = this.padSet ? this.pad : parentMessage.pad;
                if(pad == null)
                    throw new NullPointerException("Property pad must not be null");

                //
                return new OFActionNiciraNatVer12(
                    flags,
                    rangePresent,
                    ipv4Range,
                    ipv6Range,
                    portRange,
                    pad
                );
        }

    }

    static class Builder implements OFActionNiciraNat.Builder {
        // OF message fields
        private boolean flagsSet;
        private int flags;
        private boolean rangePresentSet;
        private int rangePresent;
        private boolean ipv4RangeSet;
        private List<IPv4Address> ipv4Range;
        private boolean ipv6RangeSet;
        private List<IPv6Address> ipv6Range;
        private boolean portRangeSet;
        private List<U16> portRange;
        private boolean padSet;
        private List<U8> pad;

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x2320L;
    }

    @Override
    public int getSubtype() {
        return 0x24;
    }

    @Override
    public int getFlags() {
        return flags;
    }

    @Override
    public OFActionNiciraNat.Builder setFlags(int flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public int getRangePresent() {
        return rangePresent;
    }

    @Override
    public OFActionNiciraNat.Builder setRangePresent(int rangePresent) {
        this.rangePresent = rangePresent;
        this.rangePresentSet = true;
        return this;
    }
    @Override
    public List<IPv4Address> getIpv4Range() {
        return ipv4Range;
    }

    @Override
    public OFActionNiciraNat.Builder setIpv4Range(List<IPv4Address> ipv4Range) {
        this.ipv4Range = ipv4Range;
        this.ipv4RangeSet = true;
        return this;
    }
    @Override
    public List<IPv6Address> getIpv6Range() {
        return ipv6Range;
    }

    @Override
    public OFActionNiciraNat.Builder setIpv6Range(List<IPv6Address> ipv6Range) {
        this.ipv6Range = ipv6Range;
        this.ipv6RangeSet = true;
        return this;
    }
    @Override
    public List<U16> getPortRange() {
        return portRange;
    }

    @Override
    public OFActionNiciraNat.Builder setPortRange(List<U16> portRange) {
        this.portRange = portRange;
        this.portRangeSet = true;
        return this;
    }
    @Override
    public List<U8> getPad() {
        return pad;
    }

    @Override
    public OFActionNiciraNat.Builder setPad(List<U8> pad) {
        this.pad = pad;
        this.padSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

//
        @Override
        public OFActionNiciraNat build() {
            int flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            int rangePresent = this.rangePresentSet ? this.rangePresent : DEFAULT_RANGE_PRESENT;
            List<IPv4Address> ipv4Range = this.ipv4RangeSet ? this.ipv4Range : DEFAULT_IPV4_RANGE;
            if(ipv4Range == null)
                throw new NullPointerException("Property ipv4Range must not be null");
            List<IPv6Address> ipv6Range = this.ipv6RangeSet ? this.ipv6Range : DEFAULT_IPV6_RANGE;
            if(ipv6Range == null)
                throw new NullPointerException("Property ipv6Range must not be null");
            List<U16> portRange = this.portRangeSet ? this.portRange : DEFAULT_PORT_RANGE;
            if(portRange == null)
                throw new NullPointerException("Property portRange must not be null");
            List<U8> pad = this.padSet ? this.pad : DEFAULT_PAD;
            if(pad == null)
                throw new NullPointerException("Property pad must not be null");


            return new OFActionNiciraNatVer12(
                    flags,
                    rangePresent,
                    ipv4Range,
                    ipv6Range,
                    portRange,
                    pad
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFActionNiciraNat> {
        @Override
        public OFActionNiciraNat readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 65535
            short type = bb.readShort();
            if(type != (short) 0xffff)
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // fixed value property experimenter == 0x2320L
            int experimenter = bb.readInt();
            if(experimenter != 0x2320)
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got="+experimenter);
            // fixed value property subtype == 0x24
            short subtype = bb.readShort();
            if(subtype != (short) 0x24)
                throw new OFParseError("Wrong subtype: Expected=0x24(0x24), got="+subtype);
            // pad: 2 bytes
            bb.skipBytes(2);
            int flags = U16.f(bb.readShort());
            int rangePresent = U16.f(bb.readShort());
            List<IPv4Address> ipv4Range = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), IPv4Address.READER);
            List<IPv6Address> ipv6Range = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), IPv6Address.READER);
            List<U16> portRange = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U16.READER);
            List<U8> pad = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U8.READER);

            OFActionNiciraNatVer12 actionNiciraNatVer12 = new OFActionNiciraNatVer12(
                    flags,
                      rangePresent,
                      ipv4Range,
                      ipv6Range,
                      portRange,
                      pad
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", actionNiciraNatVer12);
            return actionNiciraNatVer12;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFActionNiciraNatVer12Funnel FUNNEL = new OFActionNiciraNatVer12Funnel();
    static class OFActionNiciraNatVer12Funnel implements Funnel<OFActionNiciraNatVer12> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFActionNiciraNatVer12 message, PrimitiveSink sink) {
            // fixed value property type = 65535
            sink.putShort((short) 0xffff);
            // FIXME: skip funnel of length
            // fixed value property experimenter = 0x2320L
            sink.putInt(0x2320);
            // fixed value property subtype = 0x24
            sink.putShort((short) 0x24);
            // skip pad (2 bytes)
            sink.putInt(message.flags);
            sink.putInt(message.rangePresent);
            FunnelUtils.putList(message.ipv4Range, sink);
            FunnelUtils.putList(message.ipv6Range, sink);
            FunnelUtils.putList(message.portRange, sink);
            FunnelUtils.putList(message.pad, sink);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFActionNiciraNatVer12> {
        @Override
        public void write(ChannelBuffer bb, OFActionNiciraNatVer12 message) {
            int startIndex = bb.writerIndex();
            // fixed value property type = 65535
            bb.writeShort((short) 0xffff);
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            // fixed value property experimenter = 0x2320L
            bb.writeInt(0x2320);
            // fixed value property subtype = 0x24
            bb.writeShort((short) 0x24);
            // pad: 2 bytes
            bb.writeZero(2);
            bb.writeShort(U16.t(message.flags));
            bb.writeShort(U16.t(message.rangePresent));
            ChannelUtils.writeList(bb, message.ipv4Range);
            ChannelUtils.writeList(bb, message.ipv6Range);
            ChannelUtils.writeList(bb, message.portRange);
            ChannelUtils.writeList(bb, message.pad);

            // update length field
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraNatVer12(");
        b.append("flags=").append(flags);
        b.append(", ");
        b.append("rangePresent=").append(rangePresent);
        b.append(", ");
        b.append("ipv4Range=").append(ipv4Range);
        b.append(", ");
        b.append("ipv6Range=").append(ipv6Range);
        b.append(", ");
        b.append("portRange=").append(portRange);
        b.append(", ");
        b.append("pad=").append(pad);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFActionNiciraNatVer12 other = (OFActionNiciraNatVer12) obj;

        if( flags != other.flags)
            return false;
        if( rangePresent != other.rangePresent)
            return false;
        if (ipv4Range == null) {
            if (other.ipv4Range != null)
                return false;
        } else if (!ipv4Range.equals(other.ipv4Range))
            return false;
        if (ipv6Range == null) {
            if (other.ipv6Range != null)
                return false;
        } else if (!ipv6Range.equals(other.ipv6Range))
            return false;
        if (portRange == null) {
            if (other.portRange != null)
                return false;
        } else if (!portRange.equals(other.portRange))
            return false;
        if (pad == null) {
            if (other.pad != null)
                return false;
        } else if (!pad.equals(other.pad))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + flags;
        result = prime * result + rangePresent;
        result = prime * result + ((ipv4Range == null) ? 0 : ipv4Range.hashCode());
        result = prime * result + ((ipv6Range == null) ? 0 : ipv6Range.hashCode());
        result = prime * result + ((portRange == null) ? 0 : portRange.hashCode());
        result = prime * result + ((pad == null) ? 0 : pad.hashCode());
        return result;
    }

}
