// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOxmOfdpaQosIndexVer13 implements OFOxmOfdpaQosIndex {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmOfdpaQosIndexVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 9;

        private final static U8 DEFAULT_VALUE = U8.ZERO;

    // OF message fields
    private final U8 value;
//
    // Immutable default instance
    final static OFOxmOfdpaQosIndexVer13 DEFAULT = new OFOxmOfdpaQosIndexVer13(
        DEFAULT_VALUE
    );

    // package private constructor - used by readers, builders, and factory
    OFOxmOfdpaQosIndexVer13(U8 value) {
        if(value == null) {
            throw new NullPointerException("OFOxmOfdpaQosIndexVer13: property value cannot be null");
        }
        this.value = value;
    }

    // Accessors for OF message fields
    @Override
    public long getTypeLen() {
        return 0xffff0a05L;
    }

    @Override
    public long getExperimenterId() {
        return 0x1018L;
    }

    @Override
    public U8 getValue() {
        return value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.OFDPA_QOS_INDEX;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    public OFOxm<U8> getCanonical() {
        // exact match OXM is always canonical
        return this;
    }

    @Override
    public U8 getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFOxmOfdpaQosIndex.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOxmOfdpaQosIndex.Builder {
        final OFOxmOfdpaQosIndexVer13 parentMessage;

        // OF message fields
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmOfdpaQosIndexVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public long getTypeLen() {
        return 0xffff0a05L;
    }

    @Override
    public long getExperimenterId() {
        return 0x1018L;
    }

    @Override
    public U8 getValue() {
        return value;
    }

    @Override
    public OFOxmOfdpaQosIndex.Builder setValue(U8 value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.OFDPA_QOS_INDEX;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
    }

    @Override
    public U8 getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFOxmOfdpaQosIndex build() {
                U8 value = this.valueSet ? this.value : parentMessage.value;
                if(value == null)
                    throw new NullPointerException("Property value must not be null");

                //
                return new OFOxmOfdpaQosIndexVer13(
                    value
                );
        }

    }

    static class Builder implements OFOxmOfdpaQosIndex.Builder {
        // OF message fields
        private boolean valueSet;
        private U8 value;

    @Override
    public long getTypeLen() {
        return 0xffff0a05L;
    }

    @Override
    public long getExperimenterId() {
        return 0x1018L;
    }

    @Override
    public U8 getValue() {
        return value;
    }

    @Override
    public OFOxmOfdpaQosIndex.Builder setValue(U8 value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.OFDPA_QOS_INDEX;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
    }

    @Override
    public U8 getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFOxmOfdpaQosIndex build() {
            U8 value = this.valueSet ? this.value : DEFAULT_VALUE;
            if(value == null)
                throw new NullPointerException("Property value must not be null");


            return new OFOxmOfdpaQosIndexVer13(
                    value
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOxmOfdpaQosIndex> {
        @Override
        public OFOxmOfdpaQosIndex readFrom(ChannelBuffer bb) throws OFParseError {
            // fixed value property typeLen == 0xffff0a05L
            int typeLen = bb.readInt();
            if(typeLen != (int) 0xffff0a05)
                throw new OFParseError("Wrong typeLen: Expected=0xffff0a05L(0xffff0a05L), got="+typeLen);
            // fixed value property experimenterId == 0x1018L
            int experimenterId = bb.readInt();
            if(experimenterId != 0x1018)
                throw new OFParseError("Wrong experimenterId: Expected=0x1018L(0x1018L), got="+experimenterId);
            U8 value = U8.of(bb.readByte());

            OFOxmOfdpaQosIndexVer13 oxmOfdpaQosIndexVer13 = new OFOxmOfdpaQosIndexVer13(
                    value
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oxmOfdpaQosIndexVer13);
            return oxmOfdpaQosIndexVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOxmOfdpaQosIndexVer13Funnel FUNNEL = new OFOxmOfdpaQosIndexVer13Funnel();
    static class OFOxmOfdpaQosIndexVer13Funnel implements Funnel<OFOxmOfdpaQosIndexVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOxmOfdpaQosIndexVer13 message, PrimitiveSink sink) {
            // fixed value property typeLen = 0xffff0a05L
            sink.putInt((int) 0xffff0a05);
            // fixed value property experimenterId = 0x1018L
            sink.putInt(0x1018);
            message.value.putTo(sink);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOxmOfdpaQosIndexVer13> {
        @Override
        public void write(ChannelBuffer bb, OFOxmOfdpaQosIndexVer13 message) {
            // fixed value property typeLen = 0xffff0a05L
            bb.writeInt((int) 0xffff0a05);
            // fixed value property experimenterId = 0x1018L
            bb.writeInt(0x1018);
            bb.writeByte(message.value.getRaw());


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmOfdpaQosIndexVer13(");
        b.append("value=").append(value);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOxmOfdpaQosIndexVer13 other = (OFOxmOfdpaQosIndexVer13) obj;

        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

}
