// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFBsnSetAuxCxnsRequestVer13 implements OFBsnSetAuxCxnsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnSetAuxCxnsRequestVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 20;

        private final static long DEFAULT_XID = 0x0L;
        private final static long DEFAULT_NUM_AUX = 0x0L;

    // OF message fields
    private final long xid;
    private final long numAux;
//
    // Immutable default instance
    final static OFBsnSetAuxCxnsRequestVer13 DEFAULT = new OFBsnSetAuxCxnsRequestVer13(
        DEFAULT_XID, DEFAULT_NUM_AUX
    );

    // package private constructor - used by readers, builders, and factory
    OFBsnSetAuxCxnsRequestVer13(long xid, long numAux) {
        this.xid = xid;
        this.numAux = numAux;
    }

    // Accessors for OF message fields
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public long getExperimenter() {
        return 0x5c16c7L;
    }

    @Override
    public long getSubtype() {
        return 0x3aL;
    }

    @Override
    public long getNumAux() {
        return numAux;
    }



    public OFBsnSetAuxCxnsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFBsnSetAuxCxnsRequest.Builder {
        final OFBsnSetAuxCxnsRequestVer13 parentMessage;

        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean numAuxSet;
        private long numAux;

        BuilderWithParent(OFBsnSetAuxCxnsRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFBsnSetAuxCxnsRequest.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public long getExperimenter() {
        return 0x5c16c7L;
    }

    @Override
    public long getSubtype() {
        return 0x3aL;
    }

    @Override
    public long getNumAux() {
        return numAux;
    }

    @Override
    public OFBsnSetAuxCxnsRequest.Builder setNumAux(long numAux) {
        this.numAux = numAux;
        this.numAuxSet = true;
        return this;
    }


        @Override
        public OFBsnSetAuxCxnsRequest build() {
                long xid = this.xidSet ? this.xid : parentMessage.xid;
                long numAux = this.numAuxSet ? this.numAux : parentMessage.numAux;

                //
                return new OFBsnSetAuxCxnsRequestVer13(
                    xid,
                    numAux
                );
        }

    }

    static class Builder implements OFBsnSetAuxCxnsRequest.Builder {
        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean numAuxSet;
        private long numAux;

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFBsnSetAuxCxnsRequest.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public long getExperimenter() {
        return 0x5c16c7L;
    }

    @Override
    public long getSubtype() {
        return 0x3aL;
    }

    @Override
    public long getNumAux() {
        return numAux;
    }

    @Override
    public OFBsnSetAuxCxnsRequest.Builder setNumAux(long numAux) {
        this.numAux = numAux;
        this.numAuxSet = true;
        return this;
    }
//
        @Override
        public OFBsnSetAuxCxnsRequest build() {
            long xid = this.xidSet ? this.xid : DEFAULT_XID;
            long numAux = this.numAuxSet ? this.numAux : DEFAULT_NUM_AUX;


            return new OFBsnSetAuxCxnsRequestVer13(
                    xid,
                    numAux
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFBsnSetAuxCxnsRequest> {
        @Override
        public OFBsnSetAuxCxnsRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property version == 4
            byte version = bb.readByte();
            if(version != (byte) 0x4)
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got="+version);
            // fixed value property type == 4
            byte type = bb.readByte();
            if(type != (byte) 0x4)
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 20)
                throw new OFParseError("Wrong length: Expected=20(20), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            long xid = U32.f(bb.readInt());
            // fixed value property experimenter == 0x5c16c7L
            int experimenter = bb.readInt();
            if(experimenter != 0x5c16c7)
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got="+experimenter);
            // fixed value property subtype == 0x3aL
            int subtype = bb.readInt();
            if(subtype != 0x3a)
                throw new OFParseError("Wrong subtype: Expected=0x3aL(0x3aL), got="+subtype);
            long numAux = U32.f(bb.readInt());

            OFBsnSetAuxCxnsRequestVer13 bsnSetAuxCxnsRequestVer13 = new OFBsnSetAuxCxnsRequestVer13(
                    xid,
                      numAux
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", bsnSetAuxCxnsRequestVer13);
            return bsnSetAuxCxnsRequestVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFBsnSetAuxCxnsRequestVer13Funnel FUNNEL = new OFBsnSetAuxCxnsRequestVer13Funnel();
    static class OFBsnSetAuxCxnsRequestVer13Funnel implements Funnel<OFBsnSetAuxCxnsRequestVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFBsnSetAuxCxnsRequestVer13 message, PrimitiveSink sink) {
            // fixed value property version = 4
            sink.putByte((byte) 0x4);
            // fixed value property type = 4
            sink.putByte((byte) 0x4);
            // fixed value property length = 20
            sink.putShort((short) 0x14);
            sink.putLong(message.xid);
            // fixed value property experimenter = 0x5c16c7L
            sink.putInt(0x5c16c7);
            // fixed value property subtype = 0x3aL
            sink.putInt(0x3a);
            sink.putLong(message.numAux);
        }
    }


    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFBsnSetAuxCxnsRequestVer13> {
        @Override
        public void write(ChannelBuffer bb, OFBsnSetAuxCxnsRequestVer13 message) {
            // fixed value property version = 4
            bb.writeByte((byte) 0x4);
            // fixed value property type = 4
            bb.writeByte((byte) 0x4);
            // fixed value property length = 20
            bb.writeShort((short) 0x14);
            bb.writeInt(U32.t(message.xid));
            // fixed value property experimenter = 0x5c16c7L
            bb.writeInt(0x5c16c7);
            // fixed value property subtype = 0x3aL
            bb.writeInt(0x3a);
            bb.writeInt(U32.t(message.numAux));


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnSetAuxCxnsRequestVer13(");
        b.append("xid=").append(xid);
        b.append(", ");
        b.append("numAux=").append(numAux);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFBsnSetAuxCxnsRequestVer13 other = (OFBsnSetAuxCxnsRequestVer13) obj;

        if( xid != other.xid)
            return false;
        if( numAux != other.numAux)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime *  (int) (xid ^ (xid >>> 32));
        result = prime *  (int) (numAux ^ (numAux >>> 32));
        return result;
    }

}
