/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.protocol.match;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.match.MatchFields;
import org.projectfloodlight.openflow.types.ArpOpcode;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IpProtocol;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.Masked;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.TransportPort;

public class MatchFieldIterationBase {
    protected OFFactory factory;

    protected MatchFieldIterationBase(OFFactory factory) {
        this.factory = factory;
    }

    @Test
    public void iterateEmptyMatch() {
        Match match = this.factory.buildMatch().build();
        Iterator iter = match.getMatchFields().iterator();
        Assert.assertThat((Object)iter.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void iterateSingleExactMatchField() {
        OFPort port5 = OFPort.of((int)5);
        Match match = this.factory.buildMatch().setExact(MatchField.IN_PORT, (OFValueType)port5).build();
        Iterator iter = match.getMatchFields().iterator();
        Assert.assertThat((Object)iter.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        MatchField matchField = (MatchField)iter.next();
        Assert.assertThat((Object)matchField.id, (Matcher)CoreMatchers.is((Object)MatchFields.IN_PORT));
        Assert.assertThat((Object)match.isExact(matchField), (Matcher)CoreMatchers.is((Object)true));
        MatchField portMatchField = matchField;
        OFPort port = (OFPort)match.get(portMatchField);
        Assert.assertThat((Object)port, (Matcher)CoreMatchers.is((Object)port5));
        Assert.assertThat((Object)iter.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void iterateExactMatchFields() {
        OFPort port5 = OFPort.of((int)5);
        MacAddress macSrc = MacAddress.of((String)"00:01:02:03:04:05");
        MacAddress macDst = MacAddress.of((String)"01:01:02:02:03:03");
        IPv4Address ipSrc = IPv4Address.of((String)"10.192.20.1");
        IPv4Address ipDst = IPv4Address.of((String)"10.192.20.2");
        TransportPort tcpSrc = TransportPort.of((int)100);
        TransportPort tcpDst = TransportPort.of((int)200);
        Match match = this.factory.buildMatch().setExact(MatchField.IN_PORT, (OFValueType)port5).setExact(MatchField.ETH_TYPE, (OFValueType)EthType.IPv4).setExact(MatchField.ETH_SRC, (OFValueType)macSrc).setExact(MatchField.ETH_DST, (OFValueType)macDst).setExact(MatchField.IP_PROTO, (OFValueType)IpProtocol.TCP).setExact(MatchField.IPV4_SRC, (OFValueType)ipSrc).setExact(MatchField.IPV4_DST, (OFValueType)ipDst).setExact(MatchField.TCP_SRC, (OFValueType)tcpSrc).setExact(MatchField.TCP_DST, (OFValueType)tcpDst).build();
        Assert.assertThat((Object)Iterables.size((Iterable)match.getMatchFields()), (Matcher)CoreMatchers.is((Object)9));
        block11: for (MatchField matchField : match.getMatchFields()) {
            switch (matchField.id) {
                case IN_PORT: {
                    OFPort port = (OFPort)match.get(matchField);
                    Assert.assertThat((Object)port, (Matcher)CoreMatchers.is((Object)port5));
                    continue block11;
                }
                case ETH_TYPE: {
                    EthType ethType = (EthType)match.get(matchField);
                    Assert.assertThat((Object)ethType, (Matcher)CoreMatchers.is((Object)EthType.IPv4));
                    continue block11;
                }
                case ETH_SRC: {
                    MacAddress mac = (MacAddress)match.get(matchField);
                    Assert.assertThat((Object)mac, (Matcher)CoreMatchers.is((Object)macSrc));
                    continue block11;
                }
                case ETH_DST: {
                    MacAddress mac = (MacAddress)match.get(matchField);
                    Assert.assertThat((Object)mac, (Matcher)CoreMatchers.is((Object)macDst));
                    continue block11;
                }
                case IP_PROTO: {
                    IpProtocol ipProtocol = (IpProtocol)match.get(matchField);
                    Assert.assertThat((Object)ipProtocol, (Matcher)CoreMatchers.is((Object)IpProtocol.TCP));
                    continue block11;
                }
                case IPV4_SRC: {
                    IPv4Address ip = (IPv4Address)match.get(matchField);
                    Assert.assertThat((Object)ip, (Matcher)CoreMatchers.is((Object)ipSrc));
                    continue block11;
                }
                case IPV4_DST: {
                    IPv4Address ip = (IPv4Address)match.get(matchField);
                    Assert.assertThat((Object)ip, (Matcher)CoreMatchers.is((Object)ipDst));
                    continue block11;
                }
                case TCP_SRC: {
                    TransportPort tcp = (TransportPort)match.get(matchField);
                    Assert.assertThat((Object)tcp, (Matcher)CoreMatchers.is((Object)tcpSrc));
                    continue block11;
                }
                case TCP_DST: {
                    TransportPort tcp = (TransportPort)match.get(matchField);
                    Assert.assertThat((Object)tcp, (Matcher)CoreMatchers.is((Object)tcpDst));
                    continue block11;
                }
            }
            Assert.fail((String)"Unexpected match field returned from iterator");
        }
    }

    @Test
    public void iterateArpFields() {
        MacAddress macSrc = MacAddress.of((String)"00:01:02:03:04:05");
        MacAddress macDst = MacAddress.of((String)"01:01:02:02:03:03");
        IPv4Address ipSrc = IPv4Address.of((String)"10.192.20.1");
        IPv4Address ipDst = IPv4Address.of((String)"10.192.20.2");
        OFVersion version = this.factory.getVersion();
        boolean supportsArpHardwareAddress = version != OFVersion.OF_10 && version != OFVersion.OF_11 && version != OFVersion.OF_12;
        int matchFieldCount = 4;
        Match.Builder builder = this.factory.buildMatch();
        builder.setExact(MatchField.ETH_TYPE, (OFValueType)EthType.ARP).setExact(MatchField.ARP_OP, (OFValueType)ArpOpcode.REPLY).setExact(MatchField.ARP_SPA, (OFValueType)ipSrc).setExact(MatchField.ARP_TPA, (OFValueType)ipDst);
        if (supportsArpHardwareAddress) {
            builder.setExact(MatchField.ARP_SHA, (OFValueType)macSrc);
            builder.setExact(MatchField.ARP_THA, (OFValueType)macDst);
            matchFieldCount += 2;
        }
        Match match = builder.build();
        Assert.assertThat((Object)Iterables.size((Iterable)match.getMatchFields()), (Matcher)CoreMatchers.is((Object)matchFieldCount));
        block8: for (MatchField matchField : match.getMatchFields()) {
            switch (matchField.id) {
                case ETH_TYPE: {
                    EthType ethType = (EthType)match.get(matchField);
                    Assert.assertThat((Object)ethType, (Matcher)CoreMatchers.is((Object)EthType.ARP));
                    continue block8;
                }
                case ARP_OP: {
                    ArpOpcode opcode = (ArpOpcode)match.get(matchField);
                    Assert.assertThat((Object)opcode, (Matcher)CoreMatchers.is((Object)ArpOpcode.REPLY));
                    continue block8;
                }
                case ARP_SHA: {
                    MacAddress mac = (MacAddress)match.get(matchField);
                    Assert.assertThat((Object)mac, (Matcher)CoreMatchers.is((Object)macSrc));
                    continue block8;
                }
                case ARP_THA: {
                    MacAddress mac = (MacAddress)match.get(matchField);
                    Assert.assertThat((Object)mac, (Matcher)CoreMatchers.is((Object)macDst));
                    continue block8;
                }
                case ARP_SPA: {
                    IPv4Address ip = (IPv4Address)match.get(matchField);
                    Assert.assertThat((Object)ip, (Matcher)CoreMatchers.is((Object)ipSrc));
                    continue block8;
                }
                case ARP_TPA: {
                    IPv4Address ip = (IPv4Address)match.get(matchField);
                    Assert.assertThat((Object)ip, (Matcher)CoreMatchers.is((Object)ipDst));
                    continue block8;
                }
            }
            Assert.fail((String)"Unexpected match field returned from iterator");
        }
    }

    @Test
    public void iterateMaskedFields() {
        MacAddress macSrc = MacAddress.of((String)"01:02:03:04:00:00");
        MacAddress macSrcMask = MacAddress.of((String)"FF:FF:FF:FF:00:00");
        MacAddress macDst = MacAddress.of((String)"11:22:33:00:00:00");
        MacAddress macDstMask = MacAddress.of((String)"FF:FF:FF:00:00:00");
        IPv4Address ipSrc = IPv4Address.of((String)"10.192.20.0");
        IPv4Address ipSrcMask = IPv4Address.of((String)"255.255.255.0");
        IPv4Address ipDst = IPv4Address.of((String)"10.192.20.0");
        IPv4Address ipDstMask = IPv4Address.of((String)"255.255.255.128");
        TransportPort tcpSrcMask = TransportPort.of((int)496);
        OFVersion version = this.factory.getVersion();
        boolean supportsAllMasks = version != OFVersion.OF_10 && version != OFVersion.OF_11 && version != OFVersion.OF_12;
        int matchFieldCount = 4;
        Match.Builder builder = this.factory.buildMatch().setExact(MatchField.ETH_TYPE, (OFValueType)EthType.IPv4).setMasked(MatchField.IPV4_SRC, (OFValueType)ipSrc, (OFValueType)ipSrcMask).setMasked(MatchField.IPV4_DST, (OFValueType)ipDst, (OFValueType)ipDstMask).setExact(MatchField.IP_PROTO, (OFValueType)IpProtocol.TCP);
        if (supportsAllMasks) {
            builder.setMasked(MatchField.ETH_SRC, (OFValueType)macSrc, (OFValueType)macSrcMask);
            builder.setMasked(MatchField.ETH_DST, (OFValueType)macDst, (OFValueType)macDstMask);
            builder.setMasked(MatchField.TCP_SRC, (OFValueType)tcpSrcMask, (OFValueType)tcpSrcMask);
            matchFieldCount += 3;
        }
        Match match = builder.build();
        Assert.assertThat((Object)Iterables.size((Iterable)match.getMatchFields()), (Matcher)CoreMatchers.is((Object)matchFieldCount));
        block9: for (MatchField matchField : match.getMatchFields()) {
            switch (matchField.id) {
                case ETH_TYPE: {
                    EthType ethType = (EthType)match.get(matchField);
                    Assert.assertThat((Object)ethType, (Matcher)CoreMatchers.is((Object)EthType.IPv4));
                    continue block9;
                }
                case ETH_SRC: {
                    Masked mac = match.getMasked(matchField);
                    Assert.assertThat((Object)mac.getValue(), (Matcher)CoreMatchers.is((Object)macSrc));
                    Assert.assertThat((Object)mac.getMask(), (Matcher)CoreMatchers.is((Object)macSrcMask));
                    continue block9;
                }
                case ETH_DST: {
                    Masked mac = match.getMasked(matchField);
                    Assert.assertThat((Object)mac.getValue(), (Matcher)CoreMatchers.is((Object)macDst));
                    Assert.assertThat((Object)mac.getMask(), (Matcher)CoreMatchers.is((Object)macDstMask));
                    continue block9;
                }
                case IP_PROTO: {
                    IpProtocol ipProtocol = (IpProtocol)match.get(matchField);
                    Assert.assertThat((Object)ipProtocol, (Matcher)CoreMatchers.is((Object)IpProtocol.TCP));
                    continue block9;
                }
                case IPV4_SRC: {
                    Masked ip = match.getMasked(matchField);
                    Assert.assertThat((Object)ip.getValue(), (Matcher)CoreMatchers.is((Object)ipSrc));
                    Assert.assertThat((Object)ip.getMask(), (Matcher)CoreMatchers.is((Object)ipSrcMask));
                    continue block9;
                }
                case IPV4_DST: {
                    Masked ip = match.getMasked(matchField);
                    Assert.assertThat((Object)ip.getValue(), (Matcher)CoreMatchers.is((Object)ipDst));
                    Assert.assertThat((Object)ip.getMask(), (Matcher)CoreMatchers.is((Object)ipDstMask));
                    continue block9;
                }
                case TCP_SRC: {
                    Masked tcp = match.getMasked(matchField);
                    Assert.assertThat((Object)tcp.getValue(), (Matcher)CoreMatchers.is((Object)tcpSrcMask));
                    Assert.assertThat((Object)tcp.getMask(), (Matcher)CoreMatchers.is((Object)tcpSrcMask));
                    continue block9;
                }
            }
            Assert.fail((String)"Unexpected match field returned from iterator");
        }
    }
}

