// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFCalientFlowStatsEntryVer13 implements OFCalientFlowStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFCalientFlowStatsEntryVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int MINIMUM_LENGTH = 128;

        private final static TableId DEFAULT_TABLE_ID = TableId.ALL;
        private final static long DEFAULT_DURATION_SEC = 0x0L;
        private final static long DEFAULT_DURATION_NSEC = 0x0L;
        private final static int DEFAULT_PRIORITY = 0x0;
        private final static int DEFAULT_IDLE_TIMEOUT = 0x0;
        private final static int DEFAULT_HARD_TIMEOUT = 0x0;
        private final static Set<OFFlowModFlags> DEFAULT_FLAGS = ImmutableSet.<OFFlowModFlags>of();
        private final static U64 DEFAULT_COOKIE = U64.ZERO;
        private final static Set<OFCalientCflowAdminState> DEFAULT_ADMIN_STATUS = ImmutableSet.<OFCalientCflowAdminState>of();
        private final static Set<OFCalientCflowOperationalState> DEFAULT_OPER_STATUS = ImmutableSet.<OFCalientCflowOperationalState>of();
        private final static Set<OFCalientCflowCapability> DEFAULT_OPER_CAPABILITY = ImmutableSet.<OFCalientCflowCapability>of();
        private final static Set<OFCalientOcsAlarm> DEFAULT_ALARM = ImmutableSet.<OFCalientOcsAlarm>of();
        private final static OFPort DEFAULT_OUT_PORT = OFPort.ANY;
        private final static String DEFAULT_PORT_POWER = "";
        private final static String DEFAULT_CONNECTED_PORT_POWER = "";
        private final static String DEFAULT_CFLOW_NAME = "";
        private final static Match DEFAULT_MATCH = OFFactoryVer13.MATCH_WILDCARD_ALL;
        private final static List<OFInstruction> DEFAULT_INSTRUCTIONS = ImmutableList.<OFInstruction>of();

    // OF message fields
    private final TableId tableId;
    private final long durationSec;
    private final long durationNsec;
    private final int priority;
    private final int idleTimeout;
    private final int hardTimeout;
    private final Set<OFFlowModFlags> flags;
    private final U64 cookie;
    private final Set<OFCalientCflowAdminState> adminStatus;
    private final Set<OFCalientCflowOperationalState> operStatus;
    private final Set<OFCalientCflowCapability> operCapability;
    private final Set<OFCalientOcsAlarm> alarm;
    private final OFPort outPort;
    private final String portPower;
    private final String connectedPortPower;
    private final String cflowName;
    private final Match match;
    private final List<OFInstruction> instructions;
//
    // Immutable default instance
    final static OFCalientFlowStatsEntryVer13 DEFAULT = new OFCalientFlowStatsEntryVer13(
        DEFAULT_TABLE_ID, DEFAULT_DURATION_SEC, DEFAULT_DURATION_NSEC, DEFAULT_PRIORITY, DEFAULT_IDLE_TIMEOUT, DEFAULT_HARD_TIMEOUT, DEFAULT_FLAGS, DEFAULT_COOKIE, DEFAULT_ADMIN_STATUS, DEFAULT_OPER_STATUS, DEFAULT_OPER_CAPABILITY, DEFAULT_ALARM, DEFAULT_OUT_PORT, DEFAULT_PORT_POWER, DEFAULT_CONNECTED_PORT_POWER, DEFAULT_CFLOW_NAME, DEFAULT_MATCH, DEFAULT_INSTRUCTIONS
    );

    // package private constructor - used by readers, builders, and factory
    OFCalientFlowStatsEntryVer13(TableId tableId, long durationSec, long durationNsec, int priority, int idleTimeout, int hardTimeout, Set<OFFlowModFlags> flags, U64 cookie, Set<OFCalientCflowAdminState> adminStatus, Set<OFCalientCflowOperationalState> operStatus, Set<OFCalientCflowCapability> operCapability, Set<OFCalientOcsAlarm> alarm, OFPort outPort, String portPower, String connectedPortPower, String cflowName, Match match, List<OFInstruction> instructions) {
        if(tableId == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property tableId cannot be null");
        }
        if(flags == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property flags cannot be null");
        }
        if(cookie == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property cookie cannot be null");
        }
        if(adminStatus == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property adminStatus cannot be null");
        }
        if(operStatus == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property operStatus cannot be null");
        }
        if(operCapability == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property operCapability cannot be null");
        }
        if(alarm == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property alarm cannot be null");
        }
        if(outPort == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property outPort cannot be null");
        }
        if(portPower == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property portPower cannot be null");
        }
        if(connectedPortPower == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property connectedPortPower cannot be null");
        }
        if(cflowName == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property cflowName cannot be null");
        }
        if(match == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property match cannot be null");
        }
        if(instructions == null) {
            throw new NullPointerException("OFCalientFlowStatsEntryVer13: property instructions cannot be null");
        }
        this.tableId = tableId;
        this.durationSec = durationSec;
        this.durationNsec = durationNsec;
        this.priority = priority;
        this.idleTimeout = idleTimeout;
        this.hardTimeout = hardTimeout;
        this.flags = flags;
        this.cookie = cookie;
        this.adminStatus = adminStatus;
        this.operStatus = operStatus;
        this.operCapability = operCapability;
        this.alarm = alarm;
        this.outPort = outPort;
        this.portPower = portPower;
        this.connectedPortPower = connectedPortPower;
        this.cflowName = cflowName;
        this.match = match;
        this.instructions = instructions;
    }

    // Accessors for OF message fields
    @Override
    public TableId getTableId() {
        return tableId;
    }

    @Override
    public long getDurationSec() {
        return durationSec;
    }

    @Override
    public long getDurationNsec() {
        return durationNsec;
    }

    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public int getIdleTimeout() {
        return idleTimeout;
    }

    @Override
    public int getHardTimeout() {
        return hardTimeout;
    }

    @Override
    public Set<OFFlowModFlags> getFlags() {
        return flags;
    }

    @Override
    public U64 getCookie() {
        return cookie;
    }

    @Override
    public Set<OFCalientCflowAdminState> getAdminStatus() {
        return adminStatus;
    }

    @Override
    public Set<OFCalientCflowOperationalState> getOperStatus() {
        return operStatus;
    }

    @Override
    public Set<OFCalientCflowCapability> getOperCapability() {
        return operCapability;
    }

    @Override
    public Set<OFCalientOcsAlarm> getAlarm() {
        return alarm;
    }

    @Override
    public OFPort getOutPort() {
        return outPort;
    }

    @Override
    public String getPortPower() {
        return portPower;
    }

    @Override
    public String getConnectedPortPower() {
        return connectedPortPower;
    }

    @Override
    public String getCflowName() {
        return cflowName;
    }

    @Override
    public Match getMatch() {
        return match;
    }

    @Override
    public List<OFInstruction> getInstructions() {
        return instructions;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFCalientFlowStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFCalientFlowStatsEntry.Builder {
        final OFCalientFlowStatsEntryVer13 parentMessage;

        // OF message fields
        private boolean tableIdSet;
        private TableId tableId;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean flagsSet;
        private Set<OFFlowModFlags> flags;
        private boolean cookieSet;
        private U64 cookie;
        private boolean adminStatusSet;
        private Set<OFCalientCflowAdminState> adminStatus;
        private boolean operStatusSet;
        private Set<OFCalientCflowOperationalState> operStatus;
        private boolean operCapabilitySet;
        private Set<OFCalientCflowCapability> operCapability;
        private boolean alarmSet;
        private Set<OFCalientOcsAlarm> alarm;
        private boolean outPortSet;
        private OFPort outPort;
        private boolean portPowerSet;
        private String portPower;
        private boolean connectedPortPowerSet;
        private String connectedPortPower;
        private boolean cflowNameSet;
        private String cflowName;
        private boolean matchSet;
        private Match match;
        private boolean instructionsSet;
        private List<OFInstruction> instructions;

        BuilderWithParent(OFCalientFlowStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public TableId getTableId() {
        return tableId;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setTableId(TableId tableId) {
        this.tableId = tableId;
        this.tableIdSet = true;
        return this;
    }
    @Override
    public long getDurationSec() {
        return durationSec;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setDurationSec(long durationSec) {
        this.durationSec = durationSec;
        this.durationSecSet = true;
        return this;
    }
    @Override
    public long getDurationNsec() {
        return durationNsec;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setDurationNsec(long durationNsec) {
        this.durationNsec = durationNsec;
        this.durationNsecSet = true;
        return this;
    }
    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setPriority(int priority) {
        this.priority = priority;
        this.prioritySet = true;
        return this;
    }
    @Override
    public int getIdleTimeout() {
        return idleTimeout;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        this.idleTimeoutSet = true;
        return this;
    }
    @Override
    public int getHardTimeout() {
        return hardTimeout;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setHardTimeout(int hardTimeout) {
        this.hardTimeout = hardTimeout;
        this.hardTimeoutSet = true;
        return this;
    }
    @Override
    public Set<OFFlowModFlags> getFlags() {
        return flags;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setFlags(Set<OFFlowModFlags> flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public U64 getCookie() {
        return cookie;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setCookie(U64 cookie) {
        this.cookie = cookie;
        this.cookieSet = true;
        return this;
    }
    @Override
    public Set<OFCalientCflowAdminState> getAdminStatus() {
        return adminStatus;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setAdminStatus(Set<OFCalientCflowAdminState> adminStatus) {
        this.adminStatus = adminStatus;
        this.adminStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientCflowOperationalState> getOperStatus() {
        return operStatus;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setOperStatus(Set<OFCalientCflowOperationalState> operStatus) {
        this.operStatus = operStatus;
        this.operStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientCflowCapability> getOperCapability() {
        return operCapability;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setOperCapability(Set<OFCalientCflowCapability> operCapability) {
        this.operCapability = operCapability;
        this.operCapabilitySet = true;
        return this;
    }
    @Override
    public Set<OFCalientOcsAlarm> getAlarm() {
        return alarm;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setAlarm(Set<OFCalientOcsAlarm> alarm) {
        this.alarm = alarm;
        this.alarmSet = true;
        return this;
    }
    @Override
    public OFPort getOutPort() {
        return outPort;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setOutPort(OFPort outPort) {
        this.outPort = outPort;
        this.outPortSet = true;
        return this;
    }
    @Override
    public String getPortPower() {
        return portPower;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setPortPower(String portPower) {
        this.portPower = portPower;
        this.portPowerSet = true;
        return this;
    }
    @Override
    public String getConnectedPortPower() {
        return connectedPortPower;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setConnectedPortPower(String connectedPortPower) {
        this.connectedPortPower = connectedPortPower;
        this.connectedPortPowerSet = true;
        return this;
    }
    @Override
    public String getCflowName() {
        return cflowName;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setCflowName(String cflowName) {
        this.cflowName = cflowName;
        this.cflowNameSet = true;
        return this;
    }
    @Override
    public Match getMatch() {
        return match;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setMatch(Match match) {
        this.match = match;
        this.matchSet = true;
        return this;
    }
    @Override
    public List<OFInstruction> getInstructions() {
        return instructions;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setInstructions(List<OFInstruction> instructions) {
        this.instructions = instructions;
        this.instructionsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFCalientFlowStatsEntry build() {
                TableId tableId = this.tableIdSet ? this.tableId : parentMessage.tableId;
                if(tableId == null)
                    throw new NullPointerException("Property tableId must not be null");
                long durationSec = this.durationSecSet ? this.durationSec : parentMessage.durationSec;
                long durationNsec = this.durationNsecSet ? this.durationNsec : parentMessage.durationNsec;
                int priority = this.prioritySet ? this.priority : parentMessage.priority;
                int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : parentMessage.idleTimeout;
                int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : parentMessage.hardTimeout;
                Set<OFFlowModFlags> flags = this.flagsSet ? this.flags : parentMessage.flags;
                if(flags == null)
                    throw new NullPointerException("Property flags must not be null");
                U64 cookie = this.cookieSet ? this.cookie : parentMessage.cookie;
                if(cookie == null)
                    throw new NullPointerException("Property cookie must not be null");
                Set<OFCalientCflowAdminState> adminStatus = this.adminStatusSet ? this.adminStatus : parentMessage.adminStatus;
                if(adminStatus == null)
                    throw new NullPointerException("Property adminStatus must not be null");
                Set<OFCalientCflowOperationalState> operStatus = this.operStatusSet ? this.operStatus : parentMessage.operStatus;
                if(operStatus == null)
                    throw new NullPointerException("Property operStatus must not be null");
                Set<OFCalientCflowCapability> operCapability = this.operCapabilitySet ? this.operCapability : parentMessage.operCapability;
                if(operCapability == null)
                    throw new NullPointerException("Property operCapability must not be null");
                Set<OFCalientOcsAlarm> alarm = this.alarmSet ? this.alarm : parentMessage.alarm;
                if(alarm == null)
                    throw new NullPointerException("Property alarm must not be null");
                OFPort outPort = this.outPortSet ? this.outPort : parentMessage.outPort;
                if(outPort == null)
                    throw new NullPointerException("Property outPort must not be null");
                String portPower = this.portPowerSet ? this.portPower : parentMessage.portPower;
                if(portPower == null)
                    throw new NullPointerException("Property portPower must not be null");
                String connectedPortPower = this.connectedPortPowerSet ? this.connectedPortPower : parentMessage.connectedPortPower;
                if(connectedPortPower == null)
                    throw new NullPointerException("Property connectedPortPower must not be null");
                String cflowName = this.cflowNameSet ? this.cflowName : parentMessage.cflowName;
                if(cflowName == null)
                    throw new NullPointerException("Property cflowName must not be null");
                Match match = this.matchSet ? this.match : parentMessage.match;
                if(match == null)
                    throw new NullPointerException("Property match must not be null");
                List<OFInstruction> instructions = this.instructionsSet ? this.instructions : parentMessage.instructions;
                if(instructions == null)
                    throw new NullPointerException("Property instructions must not be null");

                //
                return new OFCalientFlowStatsEntryVer13(
                    tableId,
                    durationSec,
                    durationNsec,
                    priority,
                    idleTimeout,
                    hardTimeout,
                    flags,
                    cookie,
                    adminStatus,
                    operStatus,
                    operCapability,
                    alarm,
                    outPort,
                    portPower,
                    connectedPortPower,
                    cflowName,
                    match,
                    instructions
                );
        }

    }

    static class Builder implements OFCalientFlowStatsEntry.Builder {
        // OF message fields
        private boolean tableIdSet;
        private TableId tableId;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean flagsSet;
        private Set<OFFlowModFlags> flags;
        private boolean cookieSet;
        private U64 cookie;
        private boolean adminStatusSet;
        private Set<OFCalientCflowAdminState> adminStatus;
        private boolean operStatusSet;
        private Set<OFCalientCflowOperationalState> operStatus;
        private boolean operCapabilitySet;
        private Set<OFCalientCflowCapability> operCapability;
        private boolean alarmSet;
        private Set<OFCalientOcsAlarm> alarm;
        private boolean outPortSet;
        private OFPort outPort;
        private boolean portPowerSet;
        private String portPower;
        private boolean connectedPortPowerSet;
        private String connectedPortPower;
        private boolean cflowNameSet;
        private String cflowName;
        private boolean matchSet;
        private Match match;
        private boolean instructionsSet;
        private List<OFInstruction> instructions;

    @Override
    public TableId getTableId() {
        return tableId;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setTableId(TableId tableId) {
        this.tableId = tableId;
        this.tableIdSet = true;
        return this;
    }
    @Override
    public long getDurationSec() {
        return durationSec;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setDurationSec(long durationSec) {
        this.durationSec = durationSec;
        this.durationSecSet = true;
        return this;
    }
    @Override
    public long getDurationNsec() {
        return durationNsec;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setDurationNsec(long durationNsec) {
        this.durationNsec = durationNsec;
        this.durationNsecSet = true;
        return this;
    }
    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setPriority(int priority) {
        this.priority = priority;
        this.prioritySet = true;
        return this;
    }
    @Override
    public int getIdleTimeout() {
        return idleTimeout;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        this.idleTimeoutSet = true;
        return this;
    }
    @Override
    public int getHardTimeout() {
        return hardTimeout;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setHardTimeout(int hardTimeout) {
        this.hardTimeout = hardTimeout;
        this.hardTimeoutSet = true;
        return this;
    }
    @Override
    public Set<OFFlowModFlags> getFlags() {
        return flags;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setFlags(Set<OFFlowModFlags> flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public U64 getCookie() {
        return cookie;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setCookie(U64 cookie) {
        this.cookie = cookie;
        this.cookieSet = true;
        return this;
    }
    @Override
    public Set<OFCalientCflowAdminState> getAdminStatus() {
        return adminStatus;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setAdminStatus(Set<OFCalientCflowAdminState> adminStatus) {
        this.adminStatus = adminStatus;
        this.adminStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientCflowOperationalState> getOperStatus() {
        return operStatus;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setOperStatus(Set<OFCalientCflowOperationalState> operStatus) {
        this.operStatus = operStatus;
        this.operStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientCflowCapability> getOperCapability() {
        return operCapability;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setOperCapability(Set<OFCalientCflowCapability> operCapability) {
        this.operCapability = operCapability;
        this.operCapabilitySet = true;
        return this;
    }
    @Override
    public Set<OFCalientOcsAlarm> getAlarm() {
        return alarm;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setAlarm(Set<OFCalientOcsAlarm> alarm) {
        this.alarm = alarm;
        this.alarmSet = true;
        return this;
    }
    @Override
    public OFPort getOutPort() {
        return outPort;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setOutPort(OFPort outPort) {
        this.outPort = outPort;
        this.outPortSet = true;
        return this;
    }
    @Override
    public String getPortPower() {
        return portPower;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setPortPower(String portPower) {
        this.portPower = portPower;
        this.portPowerSet = true;
        return this;
    }
    @Override
    public String getConnectedPortPower() {
        return connectedPortPower;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setConnectedPortPower(String connectedPortPower) {
        this.connectedPortPower = connectedPortPower;
        this.connectedPortPowerSet = true;
        return this;
    }
    @Override
    public String getCflowName() {
        return cflowName;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setCflowName(String cflowName) {
        this.cflowName = cflowName;
        this.cflowNameSet = true;
        return this;
    }
    @Override
    public Match getMatch() {
        return match;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setMatch(Match match) {
        this.match = match;
        this.matchSet = true;
        return this;
    }
    @Override
    public List<OFInstruction> getInstructions() {
        return instructions;
    }

    @Override
    public OFCalientFlowStatsEntry.Builder setInstructions(List<OFInstruction> instructions) {
        this.instructions = instructions;
        this.instructionsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFCalientFlowStatsEntry build() {
            TableId tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if(tableId == null)
                throw new NullPointerException("Property tableId must not be null");
            long durationSec = this.durationSecSet ? this.durationSec : DEFAULT_DURATION_SEC;
            long durationNsec = this.durationNsecSet ? this.durationNsec : DEFAULT_DURATION_NSEC;
            int priority = this.prioritySet ? this.priority : DEFAULT_PRIORITY;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : DEFAULT_IDLE_TIMEOUT;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : DEFAULT_HARD_TIMEOUT;
            Set<OFFlowModFlags> flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if(flags == null)
                throw new NullPointerException("Property flags must not be null");
            U64 cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if(cookie == null)
                throw new NullPointerException("Property cookie must not be null");
            Set<OFCalientCflowAdminState> adminStatus = this.adminStatusSet ? this.adminStatus : DEFAULT_ADMIN_STATUS;
            if(adminStatus == null)
                throw new NullPointerException("Property adminStatus must not be null");
            Set<OFCalientCflowOperationalState> operStatus = this.operStatusSet ? this.operStatus : DEFAULT_OPER_STATUS;
            if(operStatus == null)
                throw new NullPointerException("Property operStatus must not be null");
            Set<OFCalientCflowCapability> operCapability = this.operCapabilitySet ? this.operCapability : DEFAULT_OPER_CAPABILITY;
            if(operCapability == null)
                throw new NullPointerException("Property operCapability must not be null");
            Set<OFCalientOcsAlarm> alarm = this.alarmSet ? this.alarm : DEFAULT_ALARM;
            if(alarm == null)
                throw new NullPointerException("Property alarm must not be null");
            OFPort outPort = this.outPortSet ? this.outPort : DEFAULT_OUT_PORT;
            if(outPort == null)
                throw new NullPointerException("Property outPort must not be null");
            String portPower = this.portPowerSet ? this.portPower : DEFAULT_PORT_POWER;
            if(portPower == null)
                throw new NullPointerException("Property portPower must not be null");
            String connectedPortPower = this.connectedPortPowerSet ? this.connectedPortPower : DEFAULT_CONNECTED_PORT_POWER;
            if(connectedPortPower == null)
                throw new NullPointerException("Property connectedPortPower must not be null");
            String cflowName = this.cflowNameSet ? this.cflowName : DEFAULT_CFLOW_NAME;
            if(cflowName == null)
                throw new NullPointerException("Property cflowName must not be null");
            Match match = this.matchSet ? this.match : DEFAULT_MATCH;
            if(match == null)
                throw new NullPointerException("Property match must not be null");
            List<OFInstruction> instructions = this.instructionsSet ? this.instructions : DEFAULT_INSTRUCTIONS;
            if(instructions == null)
                throw new NullPointerException("Property instructions must not be null");


            return new OFCalientFlowStatsEntryVer13(
                    tableId,
                    durationSec,
                    durationNsec,
                    priority,
                    idleTimeout,
                    hardTimeout,
                    flags,
                    cookie,
                    adminStatus,
                    operStatus,
                    operCapability,
                    alarm,
                    outPort,
                    portPower,
                    connectedPortPower,
                    cflowName,
                    match,
                    instructions
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFCalientFlowStatsEntry> {
        @Override
        public OFCalientFlowStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            TableId tableId = TableId.readByte(bb);
            // pad: 1 bytes
            bb.skipBytes(1);
            long durationSec = U32.f(bb.readInt());
            long durationNsec = U32.f(bb.readInt());
            int priority = U16.f(bb.readShort());
            int idleTimeout = U16.f(bb.readShort());
            int hardTimeout = U16.f(bb.readShort());
            Set<OFFlowModFlags> flags = OFFlowModFlagsSerializerVer13.readFrom(bb);
            // pad: 4 bytes
            bb.skipBytes(4);
            U64 cookie = U64.ofRaw(bb.readLong());
            Set<OFCalientCflowAdminState> adminStatus = OFCalientCflowAdminStateSerializerVer13.readFrom(bb);
            Set<OFCalientCflowOperationalState> operStatus = OFCalientCflowOperationalStateSerializerVer13.readFrom(bb);
            Set<OFCalientCflowCapability> operCapability = OFCalientCflowCapabilitySerializerVer13.readFrom(bb);
            Set<OFCalientOcsAlarm> alarm = OFCalientOcsAlarmSerializerVer13.readFrom(bb);
            OFPort outPort = OFPort.read4Bytes(bb);
            String portPower = ChannelUtils.readFixedLengthString(bb, 6);
            // pad: 2 bytes
            bb.skipBytes(2);
            String connectedPortPower = ChannelUtils.readFixedLengthString(bb, 6);
            // pad: 2 bytes
            bb.skipBytes(2);
            String cflowName = ChannelUtils.readFixedLengthString(bb, 64);
            Match match = ChannelUtilsVer13.readOFMatch(bb);
            List<OFInstruction> instructions = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFInstructionVer13.READER);

            OFCalientFlowStatsEntryVer13 calientFlowStatsEntryVer13 = new OFCalientFlowStatsEntryVer13(
                    tableId,
                      durationSec,
                      durationNsec,
                      priority,
                      idleTimeout,
                      hardTimeout,
                      flags,
                      cookie,
                      adminStatus,
                      operStatus,
                      operCapability,
                      alarm,
                      outPort,
                      portPower,
                      connectedPortPower,
                      cflowName,
                      match,
                      instructions
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", calientFlowStatsEntryVer13);
            return calientFlowStatsEntryVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFCalientFlowStatsEntryVer13Funnel FUNNEL = new OFCalientFlowStatsEntryVer13Funnel();
    static class OFCalientFlowStatsEntryVer13Funnel implements Funnel<OFCalientFlowStatsEntryVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFCalientFlowStatsEntryVer13 message, PrimitiveSink sink) {
            // FIXME: skip funnel of length
            message.tableId.putTo(sink);
            // skip pad (1 bytes)
            sink.putLong(message.durationSec);
            sink.putLong(message.durationNsec);
            sink.putInt(message.priority);
            sink.putInt(message.idleTimeout);
            sink.putInt(message.hardTimeout);
            OFFlowModFlagsSerializerVer13.putTo(message.flags, sink);
            // skip pad (4 bytes)
            message.cookie.putTo(sink);
            OFCalientCflowAdminStateSerializerVer13.putTo(message.adminStatus, sink);
            OFCalientCflowOperationalStateSerializerVer13.putTo(message.operStatus, sink);
            OFCalientCflowCapabilitySerializerVer13.putTo(message.operCapability, sink);
            OFCalientOcsAlarmSerializerVer13.putTo(message.alarm, sink);
            message.outPort.putTo(sink);
            sink.putUnencodedChars(message.portPower);
            // skip pad (2 bytes)
            sink.putUnencodedChars(message.connectedPortPower);
            // skip pad (2 bytes)
            sink.putUnencodedChars(message.cflowName);
            message.match.putTo(sink);
            FunnelUtils.putList(message.instructions, sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFCalientFlowStatsEntryVer13> {
        @Override
        public void write(ByteBuf bb, OFCalientFlowStatsEntryVer13 message) {
            int startIndex = bb.writerIndex();
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            message.tableId.writeByte(bb);
            // pad: 1 bytes
            bb.writeZero(1);
            bb.writeInt(U32.t(message.durationSec));
            bb.writeInt(U32.t(message.durationNsec));
            bb.writeShort(U16.t(message.priority));
            bb.writeShort(U16.t(message.idleTimeout));
            bb.writeShort(U16.t(message.hardTimeout));
            OFFlowModFlagsSerializerVer13.writeTo(bb, message.flags);
            // pad: 4 bytes
            bb.writeZero(4);
            bb.writeLong(message.cookie.getValue());
            OFCalientCflowAdminStateSerializerVer13.writeTo(bb, message.adminStatus);
            OFCalientCflowOperationalStateSerializerVer13.writeTo(bb, message.operStatus);
            OFCalientCflowCapabilitySerializerVer13.writeTo(bb, message.operCapability);
            OFCalientOcsAlarmSerializerVer13.writeTo(bb, message.alarm);
            message.outPort.write4Bytes(bb);
            ChannelUtils.writeFixedLengthString(bb, message.portPower, 6);
            // pad: 2 bytes
            bb.writeZero(2);
            ChannelUtils.writeFixedLengthString(bb, message.connectedPortPower, 6);
            // pad: 2 bytes
            bb.writeZero(2);
            ChannelUtils.writeFixedLengthString(bb, message.cflowName, 64);
            message.match.writeTo(bb);
            ChannelUtils.writeList(bb, message.instructions);

            // update length field
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFCalientFlowStatsEntryVer13(");
        b.append("tableId=").append(tableId);
        b.append(", ");
        b.append("durationSec=").append(durationSec);
        b.append(", ");
        b.append("durationNsec=").append(durationNsec);
        b.append(", ");
        b.append("priority=").append(priority);
        b.append(", ");
        b.append("idleTimeout=").append(idleTimeout);
        b.append(", ");
        b.append("hardTimeout=").append(hardTimeout);
        b.append(", ");
        b.append("flags=").append(flags);
        b.append(", ");
        b.append("cookie=").append(cookie);
        b.append(", ");
        b.append("adminStatus=").append(adminStatus);
        b.append(", ");
        b.append("operStatus=").append(operStatus);
        b.append(", ");
        b.append("operCapability=").append(operCapability);
        b.append(", ");
        b.append("alarm=").append(alarm);
        b.append(", ");
        b.append("outPort=").append(outPort);
        b.append(", ");
        b.append("portPower=").append(portPower);
        b.append(", ");
        b.append("connectedPortPower=").append(connectedPortPower);
        b.append(", ");
        b.append("cflowName=").append(cflowName);
        b.append(", ");
        b.append("match=").append(match);
        b.append(", ");
        b.append("instructions=").append(instructions);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFCalientFlowStatsEntryVer13 other = (OFCalientFlowStatsEntryVer13) obj;

        if (tableId == null) {
            if (other.tableId != null)
                return false;
        } else if (!tableId.equals(other.tableId))
            return false;
        if( durationSec != other.durationSec)
            return false;
        if( durationNsec != other.durationNsec)
            return false;
        if( priority != other.priority)
            return false;
        if( idleTimeout != other.idleTimeout)
            return false;
        if( hardTimeout != other.hardTimeout)
            return false;
        if (flags == null) {
            if (other.flags != null)
                return false;
        } else if (!flags.equals(other.flags))
            return false;
        if (cookie == null) {
            if (other.cookie != null)
                return false;
        } else if (!cookie.equals(other.cookie))
            return false;
        if (adminStatus == null) {
            if (other.adminStatus != null)
                return false;
        } else if (!adminStatus.equals(other.adminStatus))
            return false;
        if (operStatus == null) {
            if (other.operStatus != null)
                return false;
        } else if (!operStatus.equals(other.operStatus))
            return false;
        if (operCapability == null) {
            if (other.operCapability != null)
                return false;
        } else if (!operCapability.equals(other.operCapability))
            return false;
        if (alarm == null) {
            if (other.alarm != null)
                return false;
        } else if (!alarm.equals(other.alarm))
            return false;
        if (outPort == null) {
            if (other.outPort != null)
                return false;
        } else if (!outPort.equals(other.outPort))
            return false;
        if (portPower == null) {
            if (other.portPower != null)
                return false;
        } else if (!portPower.equals(other.portPower))
            return false;
        if (connectedPortPower == null) {
            if (other.connectedPortPower != null)
                return false;
        } else if (!connectedPortPower.equals(other.connectedPortPower))
            return false;
        if (cflowName == null) {
            if (other.cflowName != null)
                return false;
        } else if (!cflowName.equals(other.cflowName))
            return false;
        if (match == null) {
            if (other.match != null)
                return false;
        } else if (!match.equals(other.match))
            return false;
        if (instructions == null) {
            if (other.instructions != null)
                return false;
        } else if (!instructions.equals(other.instructions))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((tableId == null) ? 0 : tableId.hashCode());
        result = prime *  (int) (durationSec ^ (durationSec >>> 32));
        result = prime *  (int) (durationNsec ^ (durationNsec >>> 32));
        result = prime * result + priority;
        result = prime * result + idleTimeout;
        result = prime * result + hardTimeout;
        result = prime * result + ((flags == null) ? 0 : flags.hashCode());
        result = prime * result + ((cookie == null) ? 0 : cookie.hashCode());
        result = prime * result + ((adminStatus == null) ? 0 : adminStatus.hashCode());
        result = prime * result + ((operStatus == null) ? 0 : operStatus.hashCode());
        result = prime * result + ((operCapability == null) ? 0 : operCapability.hashCode());
        result = prime * result + ((alarm == null) ? 0 : alarm.hashCode());
        result = prime * result + ((outPort == null) ? 0 : outPort.hashCode());
        result = prime * result + ((portPower == null) ? 0 : portPower.hashCode());
        result = prime * result + ((connectedPortPower == null) ? 0 : connectedPortPower.hashCode());
        result = prime * result + ((cflowName == null) ? 0 : cflowName.hashCode());
        result = prime * result + ((match == null) ? 0 : match.hashCode());
        result = prime * result + ((instructions == null) ? 0 : instructions.hashCode());
        return result;
    }

}
