// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFCalientPortStatsEntryVer13 implements OFCalientPortStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFCalientPortStatsEntryVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 104;

        private final static OFPort DEFAULT_PORT_NO = OFPort.ANY;
        private final static Set<OFCalientOpticalPortAdminState> DEFAULT_IN_ADMIN_STATUS = ImmutableSet.<OFCalientOpticalPortAdminState>of();
        private final static Set<OFCalientOpticalPortOperState> DEFAULT_IN_OPER_STATUS = ImmutableSet.<OFCalientOpticalPortOperState>of();
        private final static Set<OFCalientOpticalPortOperCapability> DEFAULT_IN_OPER_CAPABILITY = ImmutableSet.<OFCalientOpticalPortOperCapability>of();
        private final static Set<OFCalientOcsAlarm> DEFAULT_IN_ALARM = ImmutableSet.<OFCalientOcsAlarm>of();
        private final static String DEFAULT_INPORT_POWER = "";
        private final static String DEFAULT_OUTPORT_POWER = "";
        private final static Set<OFCalientOpticalPortAdminState> DEFAULT_OUT_ADMIN_STATUS = ImmutableSet.<OFCalientOpticalPortAdminState>of();
        private final static Set<OFCalientOpticalPortOperState> DEFAULT_OUT_OPER_STATUS = ImmutableSet.<OFCalientOpticalPortOperState>of();
        private final static Set<OFCalientOpticalPortOperCapability> DEFAULT_OUT_OPER_CAPABILITY = ImmutableSet.<OFCalientOpticalPortOperCapability>of();
        private final static Set<OFCalientOcsAlarm> DEFAULT_OUT_ALARM = ImmutableSet.<OFCalientOcsAlarm>of();
        private final static String DEFAULT_IN_CIRCUIT_ID = "";
        private final static String DEFAULT_OUT_CIRCUIT_ID = "";

    // OF message fields
    private final OFPort portNo;
    private final Set<OFCalientOpticalPortAdminState> inAdminStatus;
    private final Set<OFCalientOpticalPortOperState> inOperStatus;
    private final Set<OFCalientOpticalPortOperCapability> inOperCapability;
    private final Set<OFCalientOcsAlarm> inAlarm;
    private final String inportPower;
    private final String outportPower;
    private final Set<OFCalientOpticalPortAdminState> outAdminStatus;
    private final Set<OFCalientOpticalPortOperState> outOperStatus;
    private final Set<OFCalientOpticalPortOperCapability> outOperCapability;
    private final Set<OFCalientOcsAlarm> outAlarm;
    private final String inCircuitId;
    private final String outCircuitId;
//
    // Immutable default instance
    final static OFCalientPortStatsEntryVer13 DEFAULT = new OFCalientPortStatsEntryVer13(
        DEFAULT_PORT_NO, DEFAULT_IN_ADMIN_STATUS, DEFAULT_IN_OPER_STATUS, DEFAULT_IN_OPER_CAPABILITY, DEFAULT_IN_ALARM, DEFAULT_INPORT_POWER, DEFAULT_OUTPORT_POWER, DEFAULT_OUT_ADMIN_STATUS, DEFAULT_OUT_OPER_STATUS, DEFAULT_OUT_OPER_CAPABILITY, DEFAULT_OUT_ALARM, DEFAULT_IN_CIRCUIT_ID, DEFAULT_OUT_CIRCUIT_ID
    );

    // package private constructor - used by readers, builders, and factory
    OFCalientPortStatsEntryVer13(OFPort portNo, Set<OFCalientOpticalPortAdminState> inAdminStatus, Set<OFCalientOpticalPortOperState> inOperStatus, Set<OFCalientOpticalPortOperCapability> inOperCapability, Set<OFCalientOcsAlarm> inAlarm, String inportPower, String outportPower, Set<OFCalientOpticalPortAdminState> outAdminStatus, Set<OFCalientOpticalPortOperState> outOperStatus, Set<OFCalientOpticalPortOperCapability> outOperCapability, Set<OFCalientOcsAlarm> outAlarm, String inCircuitId, String outCircuitId) {
        if(portNo == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property portNo cannot be null");
        }
        if(inAdminStatus == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property inAdminStatus cannot be null");
        }
        if(inOperStatus == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property inOperStatus cannot be null");
        }
        if(inOperCapability == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property inOperCapability cannot be null");
        }
        if(inAlarm == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property inAlarm cannot be null");
        }
        if(inportPower == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property inportPower cannot be null");
        }
        if(outportPower == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property outportPower cannot be null");
        }
        if(outAdminStatus == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property outAdminStatus cannot be null");
        }
        if(outOperStatus == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property outOperStatus cannot be null");
        }
        if(outOperCapability == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property outOperCapability cannot be null");
        }
        if(outAlarm == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property outAlarm cannot be null");
        }
        if(inCircuitId == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property inCircuitId cannot be null");
        }
        if(outCircuitId == null) {
            throw new NullPointerException("OFCalientPortStatsEntryVer13: property outCircuitId cannot be null");
        }
        this.portNo = portNo;
        this.inAdminStatus = inAdminStatus;
        this.inOperStatus = inOperStatus;
        this.inOperCapability = inOperCapability;
        this.inAlarm = inAlarm;
        this.inportPower = inportPower;
        this.outportPower = outportPower;
        this.outAdminStatus = outAdminStatus;
        this.outOperStatus = outOperStatus;
        this.outOperCapability = outOperCapability;
        this.outAlarm = outAlarm;
        this.inCircuitId = inCircuitId;
        this.outCircuitId = outCircuitId;
    }

    // Accessors for OF message fields
    @Override
    public OFPort getPortNo() {
        return portNo;
    }

    @Override
    public Set<OFCalientOpticalPortAdminState> getInAdminStatus() {
        return inAdminStatus;
    }

    @Override
    public Set<OFCalientOpticalPortOperState> getInOperStatus() {
        return inOperStatus;
    }

    @Override
    public Set<OFCalientOpticalPortOperCapability> getInOperCapability() {
        return inOperCapability;
    }

    @Override
    public Set<OFCalientOcsAlarm> getInAlarm() {
        return inAlarm;
    }

    @Override
    public String getInportPower() {
        return inportPower;
    }

    @Override
    public String getOutportPower() {
        return outportPower;
    }

    @Override
    public Set<OFCalientOpticalPortAdminState> getOutAdminStatus() {
        return outAdminStatus;
    }

    @Override
    public Set<OFCalientOpticalPortOperState> getOutOperStatus() {
        return outOperStatus;
    }

    @Override
    public Set<OFCalientOpticalPortOperCapability> getOutOperCapability() {
        return outOperCapability;
    }

    @Override
    public Set<OFCalientOcsAlarm> getOutAlarm() {
        return outAlarm;
    }

    @Override
    public String getInCircuitId() {
        return inCircuitId;
    }

    @Override
    public String getOutCircuitId() {
        return outCircuitId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFCalientPortStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFCalientPortStatsEntry.Builder {
        final OFCalientPortStatsEntryVer13 parentMessage;

        // OF message fields
        private boolean portNoSet;
        private OFPort portNo;
        private boolean inAdminStatusSet;
        private Set<OFCalientOpticalPortAdminState> inAdminStatus;
        private boolean inOperStatusSet;
        private Set<OFCalientOpticalPortOperState> inOperStatus;
        private boolean inOperCapabilitySet;
        private Set<OFCalientOpticalPortOperCapability> inOperCapability;
        private boolean inAlarmSet;
        private Set<OFCalientOcsAlarm> inAlarm;
        private boolean inportPowerSet;
        private String inportPower;
        private boolean outportPowerSet;
        private String outportPower;
        private boolean outAdminStatusSet;
        private Set<OFCalientOpticalPortAdminState> outAdminStatus;
        private boolean outOperStatusSet;
        private Set<OFCalientOpticalPortOperState> outOperStatus;
        private boolean outOperCapabilitySet;
        private Set<OFCalientOpticalPortOperCapability> outOperCapability;
        private boolean outAlarmSet;
        private Set<OFCalientOcsAlarm> outAlarm;
        private boolean inCircuitIdSet;
        private String inCircuitId;
        private boolean outCircuitIdSet;
        private String outCircuitId;

        BuilderWithParent(OFCalientPortStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFPort getPortNo() {
        return portNo;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setPortNo(OFPort portNo) {
        this.portNo = portNo;
        this.portNoSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortAdminState> getInAdminStatus() {
        return inAdminStatus;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setInAdminStatus(Set<OFCalientOpticalPortAdminState> inAdminStatus) {
        this.inAdminStatus = inAdminStatus;
        this.inAdminStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperState> getInOperStatus() {
        return inOperStatus;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setInOperStatus(Set<OFCalientOpticalPortOperState> inOperStatus) {
        this.inOperStatus = inOperStatus;
        this.inOperStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperCapability> getInOperCapability() {
        return inOperCapability;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setInOperCapability(Set<OFCalientOpticalPortOperCapability> inOperCapability) {
        this.inOperCapability = inOperCapability;
        this.inOperCapabilitySet = true;
        return this;
    }
    @Override
    public Set<OFCalientOcsAlarm> getInAlarm() {
        return inAlarm;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setInAlarm(Set<OFCalientOcsAlarm> inAlarm) {
        this.inAlarm = inAlarm;
        this.inAlarmSet = true;
        return this;
    }
    @Override
    public String getInportPower() {
        return inportPower;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setInportPower(String inportPower) {
        this.inportPower = inportPower;
        this.inportPowerSet = true;
        return this;
    }
    @Override
    public String getOutportPower() {
        return outportPower;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setOutportPower(String outportPower) {
        this.outportPower = outportPower;
        this.outportPowerSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortAdminState> getOutAdminStatus() {
        return outAdminStatus;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setOutAdminStatus(Set<OFCalientOpticalPortAdminState> outAdminStatus) {
        this.outAdminStatus = outAdminStatus;
        this.outAdminStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperState> getOutOperStatus() {
        return outOperStatus;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setOutOperStatus(Set<OFCalientOpticalPortOperState> outOperStatus) {
        this.outOperStatus = outOperStatus;
        this.outOperStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperCapability> getOutOperCapability() {
        return outOperCapability;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setOutOperCapability(Set<OFCalientOpticalPortOperCapability> outOperCapability) {
        this.outOperCapability = outOperCapability;
        this.outOperCapabilitySet = true;
        return this;
    }
    @Override
    public Set<OFCalientOcsAlarm> getOutAlarm() {
        return outAlarm;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setOutAlarm(Set<OFCalientOcsAlarm> outAlarm) {
        this.outAlarm = outAlarm;
        this.outAlarmSet = true;
        return this;
    }
    @Override
    public String getInCircuitId() {
        return inCircuitId;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setInCircuitId(String inCircuitId) {
        this.inCircuitId = inCircuitId;
        this.inCircuitIdSet = true;
        return this;
    }
    @Override
    public String getOutCircuitId() {
        return outCircuitId;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setOutCircuitId(String outCircuitId) {
        this.outCircuitId = outCircuitId;
        this.outCircuitIdSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFCalientPortStatsEntry build() {
                OFPort portNo = this.portNoSet ? this.portNo : parentMessage.portNo;
                if(portNo == null)
                    throw new NullPointerException("Property portNo must not be null");
                Set<OFCalientOpticalPortAdminState> inAdminStatus = this.inAdminStatusSet ? this.inAdminStatus : parentMessage.inAdminStatus;
                if(inAdminStatus == null)
                    throw new NullPointerException("Property inAdminStatus must not be null");
                Set<OFCalientOpticalPortOperState> inOperStatus = this.inOperStatusSet ? this.inOperStatus : parentMessage.inOperStatus;
                if(inOperStatus == null)
                    throw new NullPointerException("Property inOperStatus must not be null");
                Set<OFCalientOpticalPortOperCapability> inOperCapability = this.inOperCapabilitySet ? this.inOperCapability : parentMessage.inOperCapability;
                if(inOperCapability == null)
                    throw new NullPointerException("Property inOperCapability must not be null");
                Set<OFCalientOcsAlarm> inAlarm = this.inAlarmSet ? this.inAlarm : parentMessage.inAlarm;
                if(inAlarm == null)
                    throw new NullPointerException("Property inAlarm must not be null");
                String inportPower = this.inportPowerSet ? this.inportPower : parentMessage.inportPower;
                if(inportPower == null)
                    throw new NullPointerException("Property inportPower must not be null");
                String outportPower = this.outportPowerSet ? this.outportPower : parentMessage.outportPower;
                if(outportPower == null)
                    throw new NullPointerException("Property outportPower must not be null");
                Set<OFCalientOpticalPortAdminState> outAdminStatus = this.outAdminStatusSet ? this.outAdminStatus : parentMessage.outAdminStatus;
                if(outAdminStatus == null)
                    throw new NullPointerException("Property outAdminStatus must not be null");
                Set<OFCalientOpticalPortOperState> outOperStatus = this.outOperStatusSet ? this.outOperStatus : parentMessage.outOperStatus;
                if(outOperStatus == null)
                    throw new NullPointerException("Property outOperStatus must not be null");
                Set<OFCalientOpticalPortOperCapability> outOperCapability = this.outOperCapabilitySet ? this.outOperCapability : parentMessage.outOperCapability;
                if(outOperCapability == null)
                    throw new NullPointerException("Property outOperCapability must not be null");
                Set<OFCalientOcsAlarm> outAlarm = this.outAlarmSet ? this.outAlarm : parentMessage.outAlarm;
                if(outAlarm == null)
                    throw new NullPointerException("Property outAlarm must not be null");
                String inCircuitId = this.inCircuitIdSet ? this.inCircuitId : parentMessage.inCircuitId;
                if(inCircuitId == null)
                    throw new NullPointerException("Property inCircuitId must not be null");
                String outCircuitId = this.outCircuitIdSet ? this.outCircuitId : parentMessage.outCircuitId;
                if(outCircuitId == null)
                    throw new NullPointerException("Property outCircuitId must not be null");

                //
                return new OFCalientPortStatsEntryVer13(
                    portNo,
                    inAdminStatus,
                    inOperStatus,
                    inOperCapability,
                    inAlarm,
                    inportPower,
                    outportPower,
                    outAdminStatus,
                    outOperStatus,
                    outOperCapability,
                    outAlarm,
                    inCircuitId,
                    outCircuitId
                );
        }

    }

    static class Builder implements OFCalientPortStatsEntry.Builder {
        // OF message fields
        private boolean portNoSet;
        private OFPort portNo;
        private boolean inAdminStatusSet;
        private Set<OFCalientOpticalPortAdminState> inAdminStatus;
        private boolean inOperStatusSet;
        private Set<OFCalientOpticalPortOperState> inOperStatus;
        private boolean inOperCapabilitySet;
        private Set<OFCalientOpticalPortOperCapability> inOperCapability;
        private boolean inAlarmSet;
        private Set<OFCalientOcsAlarm> inAlarm;
        private boolean inportPowerSet;
        private String inportPower;
        private boolean outportPowerSet;
        private String outportPower;
        private boolean outAdminStatusSet;
        private Set<OFCalientOpticalPortAdminState> outAdminStatus;
        private boolean outOperStatusSet;
        private Set<OFCalientOpticalPortOperState> outOperStatus;
        private boolean outOperCapabilitySet;
        private Set<OFCalientOpticalPortOperCapability> outOperCapability;
        private boolean outAlarmSet;
        private Set<OFCalientOcsAlarm> outAlarm;
        private boolean inCircuitIdSet;
        private String inCircuitId;
        private boolean outCircuitIdSet;
        private String outCircuitId;

    @Override
    public OFPort getPortNo() {
        return portNo;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setPortNo(OFPort portNo) {
        this.portNo = portNo;
        this.portNoSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortAdminState> getInAdminStatus() {
        return inAdminStatus;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setInAdminStatus(Set<OFCalientOpticalPortAdminState> inAdminStatus) {
        this.inAdminStatus = inAdminStatus;
        this.inAdminStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperState> getInOperStatus() {
        return inOperStatus;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setInOperStatus(Set<OFCalientOpticalPortOperState> inOperStatus) {
        this.inOperStatus = inOperStatus;
        this.inOperStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperCapability> getInOperCapability() {
        return inOperCapability;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setInOperCapability(Set<OFCalientOpticalPortOperCapability> inOperCapability) {
        this.inOperCapability = inOperCapability;
        this.inOperCapabilitySet = true;
        return this;
    }
    @Override
    public Set<OFCalientOcsAlarm> getInAlarm() {
        return inAlarm;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setInAlarm(Set<OFCalientOcsAlarm> inAlarm) {
        this.inAlarm = inAlarm;
        this.inAlarmSet = true;
        return this;
    }
    @Override
    public String getInportPower() {
        return inportPower;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setInportPower(String inportPower) {
        this.inportPower = inportPower;
        this.inportPowerSet = true;
        return this;
    }
    @Override
    public String getOutportPower() {
        return outportPower;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setOutportPower(String outportPower) {
        this.outportPower = outportPower;
        this.outportPowerSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortAdminState> getOutAdminStatus() {
        return outAdminStatus;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setOutAdminStatus(Set<OFCalientOpticalPortAdminState> outAdminStatus) {
        this.outAdminStatus = outAdminStatus;
        this.outAdminStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperState> getOutOperStatus() {
        return outOperStatus;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setOutOperStatus(Set<OFCalientOpticalPortOperState> outOperStatus) {
        this.outOperStatus = outOperStatus;
        this.outOperStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperCapability> getOutOperCapability() {
        return outOperCapability;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setOutOperCapability(Set<OFCalientOpticalPortOperCapability> outOperCapability) {
        this.outOperCapability = outOperCapability;
        this.outOperCapabilitySet = true;
        return this;
    }
    @Override
    public Set<OFCalientOcsAlarm> getOutAlarm() {
        return outAlarm;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setOutAlarm(Set<OFCalientOcsAlarm> outAlarm) {
        this.outAlarm = outAlarm;
        this.outAlarmSet = true;
        return this;
    }
    @Override
    public String getInCircuitId() {
        return inCircuitId;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setInCircuitId(String inCircuitId) {
        this.inCircuitId = inCircuitId;
        this.inCircuitIdSet = true;
        return this;
    }
    @Override
    public String getOutCircuitId() {
        return outCircuitId;
    }

    @Override
    public OFCalientPortStatsEntry.Builder setOutCircuitId(String outCircuitId) {
        this.outCircuitId = outCircuitId;
        this.outCircuitIdSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFCalientPortStatsEntry build() {
            OFPort portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if(portNo == null)
                throw new NullPointerException("Property portNo must not be null");
            Set<OFCalientOpticalPortAdminState> inAdminStatus = this.inAdminStatusSet ? this.inAdminStatus : DEFAULT_IN_ADMIN_STATUS;
            if(inAdminStatus == null)
                throw new NullPointerException("Property inAdminStatus must not be null");
            Set<OFCalientOpticalPortOperState> inOperStatus = this.inOperStatusSet ? this.inOperStatus : DEFAULT_IN_OPER_STATUS;
            if(inOperStatus == null)
                throw new NullPointerException("Property inOperStatus must not be null");
            Set<OFCalientOpticalPortOperCapability> inOperCapability = this.inOperCapabilitySet ? this.inOperCapability : DEFAULT_IN_OPER_CAPABILITY;
            if(inOperCapability == null)
                throw new NullPointerException("Property inOperCapability must not be null");
            Set<OFCalientOcsAlarm> inAlarm = this.inAlarmSet ? this.inAlarm : DEFAULT_IN_ALARM;
            if(inAlarm == null)
                throw new NullPointerException("Property inAlarm must not be null");
            String inportPower = this.inportPowerSet ? this.inportPower : DEFAULT_INPORT_POWER;
            if(inportPower == null)
                throw new NullPointerException("Property inportPower must not be null");
            String outportPower = this.outportPowerSet ? this.outportPower : DEFAULT_OUTPORT_POWER;
            if(outportPower == null)
                throw new NullPointerException("Property outportPower must not be null");
            Set<OFCalientOpticalPortAdminState> outAdminStatus = this.outAdminStatusSet ? this.outAdminStatus : DEFAULT_OUT_ADMIN_STATUS;
            if(outAdminStatus == null)
                throw new NullPointerException("Property outAdminStatus must not be null");
            Set<OFCalientOpticalPortOperState> outOperStatus = this.outOperStatusSet ? this.outOperStatus : DEFAULT_OUT_OPER_STATUS;
            if(outOperStatus == null)
                throw new NullPointerException("Property outOperStatus must not be null");
            Set<OFCalientOpticalPortOperCapability> outOperCapability = this.outOperCapabilitySet ? this.outOperCapability : DEFAULT_OUT_OPER_CAPABILITY;
            if(outOperCapability == null)
                throw new NullPointerException("Property outOperCapability must not be null");
            Set<OFCalientOcsAlarm> outAlarm = this.outAlarmSet ? this.outAlarm : DEFAULT_OUT_ALARM;
            if(outAlarm == null)
                throw new NullPointerException("Property outAlarm must not be null");
            String inCircuitId = this.inCircuitIdSet ? this.inCircuitId : DEFAULT_IN_CIRCUIT_ID;
            if(inCircuitId == null)
                throw new NullPointerException("Property inCircuitId must not be null");
            String outCircuitId = this.outCircuitIdSet ? this.outCircuitId : DEFAULT_OUT_CIRCUIT_ID;
            if(outCircuitId == null)
                throw new NullPointerException("Property outCircuitId must not be null");


            return new OFCalientPortStatsEntryVer13(
                    portNo,
                    inAdminStatus,
                    inOperStatus,
                    inOperCapability,
                    inAlarm,
                    inportPower,
                    outportPower,
                    outAdminStatus,
                    outOperStatus,
                    outOperCapability,
                    outAlarm,
                    inCircuitId,
                    outCircuitId
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFCalientPortStatsEntry> {
        @Override
        public OFCalientPortStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if(length != 104)
                throw new OFParseError("Wrong length: Expected=104(104), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // pad: 2 bytes
            bb.skipBytes(2);
            OFPort portNo = OFPort.read4Bytes(bb);
            Set<OFCalientOpticalPortAdminState> inAdminStatus = OFCalientOpticalPortAdminStateSerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortOperState> inOperStatus = OFCalientOpticalPortOperStateSerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortOperCapability> inOperCapability = OFCalientOpticalPortOperCapabilitySerializerVer13.readFrom(bb);
            Set<OFCalientOcsAlarm> inAlarm = OFCalientOcsAlarmSerializerVer13.readFrom(bb);
            // pad: 4 bytes
            bb.skipBytes(4);
            String inportPower = ChannelUtils.readFixedLengthString(bb, 6);
            // pad: 2 bytes
            bb.skipBytes(2);
            String outportPower = ChannelUtils.readFixedLengthString(bb, 6);
            // pad: 2 bytes
            bb.skipBytes(2);
            Set<OFCalientOpticalPortAdminState> outAdminStatus = OFCalientOpticalPortAdminStateSerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortOperState> outOperStatus = OFCalientOpticalPortOperStateSerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortOperCapability> outOperCapability = OFCalientOpticalPortOperCapabilitySerializerVer13.readFrom(bb);
            Set<OFCalientOcsAlarm> outAlarm = OFCalientOcsAlarmSerializerVer13.readFrom(bb);
            // pad: 4 bytes
            bb.skipBytes(4);
            String inCircuitId = ChannelUtils.readFixedLengthString(bb, 32);
            String outCircuitId = ChannelUtils.readFixedLengthString(bb, 32);

            OFCalientPortStatsEntryVer13 calientPortStatsEntryVer13 = new OFCalientPortStatsEntryVer13(
                    portNo,
                      inAdminStatus,
                      inOperStatus,
                      inOperCapability,
                      inAlarm,
                      inportPower,
                      outportPower,
                      outAdminStatus,
                      outOperStatus,
                      outOperCapability,
                      outAlarm,
                      inCircuitId,
                      outCircuitId
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", calientPortStatsEntryVer13);
            return calientPortStatsEntryVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFCalientPortStatsEntryVer13Funnel FUNNEL = new OFCalientPortStatsEntryVer13Funnel();
    static class OFCalientPortStatsEntryVer13Funnel implements Funnel<OFCalientPortStatsEntryVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFCalientPortStatsEntryVer13 message, PrimitiveSink sink) {
            // fixed value property length = 104
            sink.putShort((short) 0x68);
            // skip pad (2 bytes)
            message.portNo.putTo(sink);
            OFCalientOpticalPortAdminStateSerializerVer13.putTo(message.inAdminStatus, sink);
            OFCalientOpticalPortOperStateSerializerVer13.putTo(message.inOperStatus, sink);
            OFCalientOpticalPortOperCapabilitySerializerVer13.putTo(message.inOperCapability, sink);
            OFCalientOcsAlarmSerializerVer13.putTo(message.inAlarm, sink);
            // skip pad (4 bytes)
            sink.putUnencodedChars(message.inportPower);
            // skip pad (2 bytes)
            sink.putUnencodedChars(message.outportPower);
            // skip pad (2 bytes)
            OFCalientOpticalPortAdminStateSerializerVer13.putTo(message.outAdminStatus, sink);
            OFCalientOpticalPortOperStateSerializerVer13.putTo(message.outOperStatus, sink);
            OFCalientOpticalPortOperCapabilitySerializerVer13.putTo(message.outOperCapability, sink);
            OFCalientOcsAlarmSerializerVer13.putTo(message.outAlarm, sink);
            // skip pad (4 bytes)
            sink.putUnencodedChars(message.inCircuitId);
            sink.putUnencodedChars(message.outCircuitId);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFCalientPortStatsEntryVer13> {
        @Override
        public void write(ByteBuf bb, OFCalientPortStatsEntryVer13 message) {
            // fixed value property length = 104
            bb.writeShort((short) 0x68);
            // pad: 2 bytes
            bb.writeZero(2);
            message.portNo.write4Bytes(bb);
            OFCalientOpticalPortAdminStateSerializerVer13.writeTo(bb, message.inAdminStatus);
            OFCalientOpticalPortOperStateSerializerVer13.writeTo(bb, message.inOperStatus);
            OFCalientOpticalPortOperCapabilitySerializerVer13.writeTo(bb, message.inOperCapability);
            OFCalientOcsAlarmSerializerVer13.writeTo(bb, message.inAlarm);
            // pad: 4 bytes
            bb.writeZero(4);
            ChannelUtils.writeFixedLengthString(bb, message.inportPower, 6);
            // pad: 2 bytes
            bb.writeZero(2);
            ChannelUtils.writeFixedLengthString(bb, message.outportPower, 6);
            // pad: 2 bytes
            bb.writeZero(2);
            OFCalientOpticalPortAdminStateSerializerVer13.writeTo(bb, message.outAdminStatus);
            OFCalientOpticalPortOperStateSerializerVer13.writeTo(bb, message.outOperStatus);
            OFCalientOpticalPortOperCapabilitySerializerVer13.writeTo(bb, message.outOperCapability);
            OFCalientOcsAlarmSerializerVer13.writeTo(bb, message.outAlarm);
            // pad: 4 bytes
            bb.writeZero(4);
            ChannelUtils.writeFixedLengthString(bb, message.inCircuitId, 32);
            ChannelUtils.writeFixedLengthString(bb, message.outCircuitId, 32);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFCalientPortStatsEntryVer13(");
        b.append("portNo=").append(portNo);
        b.append(", ");
        b.append("inAdminStatus=").append(inAdminStatus);
        b.append(", ");
        b.append("inOperStatus=").append(inOperStatus);
        b.append(", ");
        b.append("inOperCapability=").append(inOperCapability);
        b.append(", ");
        b.append("inAlarm=").append(inAlarm);
        b.append(", ");
        b.append("inportPower=").append(inportPower);
        b.append(", ");
        b.append("outportPower=").append(outportPower);
        b.append(", ");
        b.append("outAdminStatus=").append(outAdminStatus);
        b.append(", ");
        b.append("outOperStatus=").append(outOperStatus);
        b.append(", ");
        b.append("outOperCapability=").append(outOperCapability);
        b.append(", ");
        b.append("outAlarm=").append(outAlarm);
        b.append(", ");
        b.append("inCircuitId=").append(inCircuitId);
        b.append(", ");
        b.append("outCircuitId=").append(outCircuitId);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFCalientPortStatsEntryVer13 other = (OFCalientPortStatsEntryVer13) obj;

        if (portNo == null) {
            if (other.portNo != null)
                return false;
        } else if (!portNo.equals(other.portNo))
            return false;
        if (inAdminStatus == null) {
            if (other.inAdminStatus != null)
                return false;
        } else if (!inAdminStatus.equals(other.inAdminStatus))
            return false;
        if (inOperStatus == null) {
            if (other.inOperStatus != null)
                return false;
        } else if (!inOperStatus.equals(other.inOperStatus))
            return false;
        if (inOperCapability == null) {
            if (other.inOperCapability != null)
                return false;
        } else if (!inOperCapability.equals(other.inOperCapability))
            return false;
        if (inAlarm == null) {
            if (other.inAlarm != null)
                return false;
        } else if (!inAlarm.equals(other.inAlarm))
            return false;
        if (inportPower == null) {
            if (other.inportPower != null)
                return false;
        } else if (!inportPower.equals(other.inportPower))
            return false;
        if (outportPower == null) {
            if (other.outportPower != null)
                return false;
        } else if (!outportPower.equals(other.outportPower))
            return false;
        if (outAdminStatus == null) {
            if (other.outAdminStatus != null)
                return false;
        } else if (!outAdminStatus.equals(other.outAdminStatus))
            return false;
        if (outOperStatus == null) {
            if (other.outOperStatus != null)
                return false;
        } else if (!outOperStatus.equals(other.outOperStatus))
            return false;
        if (outOperCapability == null) {
            if (other.outOperCapability != null)
                return false;
        } else if (!outOperCapability.equals(other.outOperCapability))
            return false;
        if (outAlarm == null) {
            if (other.outAlarm != null)
                return false;
        } else if (!outAlarm.equals(other.outAlarm))
            return false;
        if (inCircuitId == null) {
            if (other.inCircuitId != null)
                return false;
        } else if (!inCircuitId.equals(other.inCircuitId))
            return false;
        if (outCircuitId == null) {
            if (other.outCircuitId != null)
                return false;
        } else if (!outCircuitId.equals(other.outCircuitId))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((portNo == null) ? 0 : portNo.hashCode());
        result = prime * result + ((inAdminStatus == null) ? 0 : inAdminStatus.hashCode());
        result = prime * result + ((inOperStatus == null) ? 0 : inOperStatus.hashCode());
        result = prime * result + ((inOperCapability == null) ? 0 : inOperCapability.hashCode());
        result = prime * result + ((inAlarm == null) ? 0 : inAlarm.hashCode());
        result = prime * result + ((inportPower == null) ? 0 : inportPower.hashCode());
        result = prime * result + ((outportPower == null) ? 0 : outportPower.hashCode());
        result = prime * result + ((outAdminStatus == null) ? 0 : outAdminStatus.hashCode());
        result = prime * result + ((outOperStatus == null) ? 0 : outOperStatus.hashCode());
        result = prime * result + ((outOperCapability == null) ? 0 : outOperCapability.hashCode());
        result = prime * result + ((outAlarm == null) ? 0 : outAlarm.hashCode());
        result = prime * result + ((inCircuitId == null) ? 0 : inCircuitId.hashCode());
        result = prime * result + ((outCircuitId == null) ? 0 : outCircuitId.hashCode());
        return result;
    }

}
