// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_virtual_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import io.netty.buffer.ByteBuf;
import java.util.Set;

abstract class OFMessageVer13 {
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int MINIMUM_LENGTH = 8;


    public final static OFMessageVer13.Reader READER = new Reader();

    static class Reader implements OFMessageReader<OFMessage> {
        @Override
        public OFMessage readFrom(ByteBuf bb) throws OFParseError {
            if(bb.readableBytes() < MINIMUM_LENGTH)
                return null;
            int start = bb.readerIndex();
            // fixed value property version == 4
            byte version = bb.readByte();
            if(version != (byte) 0x4)
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got="+version);
            byte type = bb.readByte();
            bb.readerIndex(start);
            switch(type) {
               case (byte) 0x13:
                   // discriminator value OFType.STATS_REPLY=19 for class OFStatsReplyVer13
                   return OFStatsReplyVer13.READER.readFrom(bb);
               case (byte) 0x12:
                   // discriminator value OFType.STATS_REQUEST=18 for class OFStatsRequestVer13
                   return OFStatsRequestVer13.READER.readFrom(bb);
               case (byte) 0x1:
                   // discriminator value OFType.ERROR=1 for class OFErrorMsgVer13
                   return OFErrorMsgVer13.READER.readFrom(bb);
               case (byte) 0x15:
                   // discriminator value OFType.BARRIER_REPLY=21 for class OFBarrierReplyVer13
                   return OFBarrierReplyVer13.READER.readFrom(bb);
               case (byte) 0x14:
                   // discriminator value OFType.BARRIER_REQUEST=20 for class OFBarrierRequestVer13
                   return OFBarrierRequestVer13.READER.readFrom(bb);
               case (byte) 0x4:
                   // discriminator value OFType.EXPERIMENTER=4 for class OFExperimenterVer13
                   return OFExperimenterVer13.READER.readFrom(bb);
               case (byte) 0x3:
                   // discriminator value OFType.ECHO_REPLY=3 for class OFEchoReplyVer13
                   return OFEchoReplyVer13.READER.readFrom(bb);
               case (byte) 0x2:
                   // discriminator value OFType.ECHO_REQUEST=2 for class OFEchoRequestVer13
                   return OFEchoRequestVer13.READER.readFrom(bb);
               case (byte) 0x6:
                   // discriminator value OFType.FEATURES_REPLY=6 for class OFFeaturesReplyVer13
                   return OFFeaturesReplyVer13.READER.readFrom(bb);
               case (byte) 0x5:
                   // discriminator value OFType.FEATURES_REQUEST=5 for class OFFeaturesRequestVer13
                   return OFFeaturesRequestVer13.READER.readFrom(bb);
               case (byte) 0xe:
                   // discriminator value OFType.FLOW_MOD=14 for class OFFlowModVer13
                   return OFFlowModVer13.READER.readFrom(bb);
               case (byte) 0xb:
                   // discriminator value OFType.FLOW_REMOVED=11 for class OFFlowRemovedVer13
                   return OFFlowRemovedVer13.READER.readFrom(bb);
               case (byte) 0x8:
                   // discriminator value OFType.GET_CONFIG_REPLY=8 for class OFGetConfigReplyVer13
                   return OFGetConfigReplyVer13.READER.readFrom(bb);
               case (byte) 0x7:
                   // discriminator value OFType.GET_CONFIG_REQUEST=7 for class OFGetConfigRequestVer13
                   return OFGetConfigRequestVer13.READER.readFrom(bb);
               case (byte) 0x0:
                   // discriminator value OFType.HELLO=0 for class OFHelloVer13
                   return OFHelloVer13.READER.readFrom(bb);
               case (byte) 0xa:
                   // discriminator value OFType.PACKET_IN=10 for class OFPacketInVer13
                   return OFPacketInVer13.READER.readFrom(bb);
               case (byte) 0xd:
                   // discriminator value OFType.PACKET_OUT=13 for class OFPacketOutVer13
                   return OFPacketOutVer13.READER.readFrom(bb);
               case (byte) 0x10:
                   // discriminator value OFType.PORT_MOD=16 for class OFPortModVer13
                   return OFPortModVer13.READER.readFrom(bb);
               case (byte) 0xc:
                   // discriminator value OFType.PORT_STATUS=12 for class OFPortStatusVer13
                   return OFPortStatusVer13.READER.readFrom(bb);
               case (byte) 0x17:
                   // discriminator value OFType.QUEUE_GET_CONFIG_REPLY=23 for class OFQueueGetConfigReplyVer13
                   return OFQueueGetConfigReplyVer13.READER.readFrom(bb);
               case (byte) 0x16:
                   // discriminator value OFType.QUEUE_GET_CONFIG_REQUEST=22 for class OFQueueGetConfigRequestVer13
                   return OFQueueGetConfigRequestVer13.READER.readFrom(bb);
               case (byte) 0x9:
                   // discriminator value OFType.SET_CONFIG=9 for class OFSetConfigVer13
                   return OFSetConfigVer13.READER.readFrom(bb);
               case (byte) 0x11:
                   // discriminator value OFType.TABLE_MOD=17 for class OFTableModVer13
                   return OFTableModVer13.READER.readFrom(bb);
               case (byte) 0xf:
                   // discriminator value OFType.GROUP_MOD=15 for class OFGroupModVer13
                   return OFGroupModVer13.READER.readFrom(bb);
               case (byte) 0x19:
                   // discriminator value OFType.ROLE_REPLY=25 for class OFRoleReplyVer13
                   return OFRoleReplyVer13.READER.readFrom(bb);
               case (byte) 0x18:
                   // discriminator value OFType.ROLE_REQUEST=24 for class OFRoleRequestVer13
                   return OFRoleRequestVer13.READER.readFrom(bb);
               case (byte) 0x1b:
                   // discriminator value OFType.GET_ASYNC_REPLY=27 for class OFAsyncGetReplyVer13
                   return OFAsyncGetReplyVer13.READER.readFrom(bb);
               case (byte) 0x1a:
                   // discriminator value OFType.GET_ASYNC_REQUEST=26 for class OFAsyncGetRequestVer13
                   return OFAsyncGetRequestVer13.READER.readFrom(bb);
               case (byte) 0x1c:
                   // discriminator value OFType.SET_ASYNC=28 for class OFAsyncSetVer13
                   return OFAsyncSetVer13.READER.readFrom(bb);
               case (byte) 0x1d:
                   // discriminator value OFType.METER_MOD=29 for class OFMeterModVer13
                   return OFMeterModVer13.READER.readFrom(bb);
               default:
                   throw new OFParseError("Unknown value for discriminator type of class OFMessageVer13: " + type);
            }
        }
    }
}
