// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOplinkChannelPowerVer13 implements OFOplinkChannelPower {
    private static final Logger logger = LoggerFactory.getLogger(OFOplinkChannelPowerVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 8;

        private final static int DEFAULT_IN_PORT = 0x0;
        private final static int DEFAULT_OUT_PORT = 0x0;
        private final static int DEFAULT_CHANNEL = 0x0;
        private final static int DEFAULT_POWER_VALUE = 0x0;

    // OF message fields
    private final int inPort;
    private final int outPort;
    private final int channel;
    private final int powerValue;
//
    // Immutable default instance
    final static OFOplinkChannelPowerVer13 DEFAULT = new OFOplinkChannelPowerVer13(
        DEFAULT_IN_PORT, DEFAULT_OUT_PORT, DEFAULT_CHANNEL, DEFAULT_POWER_VALUE
    );

    // package private constructor - used by readers, builders, and factory
    OFOplinkChannelPowerVer13(int inPort, int outPort, int channel, int powerValue) {
        this.inPort = inPort;
        this.outPort = outPort;
        this.channel = channel;
        this.powerValue = powerValue;
    }

    // Accessors for OF message fields
    @Override
    public int getInPort() {
        return inPort;
    }

    @Override
    public int getOutPort() {
        return outPort;
    }

    @Override
    public int getChannel() {
        return channel;
    }

    @Override
    public int getPowerValue() {
        return powerValue;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFOplinkChannelPower.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOplinkChannelPower.Builder {
        final OFOplinkChannelPowerVer13 parentMessage;

        // OF message fields
        private boolean inPortSet;
        private int inPort;
        private boolean outPortSet;
        private int outPort;
        private boolean channelSet;
        private int channel;
        private boolean powerValueSet;
        private int powerValue;

        BuilderWithParent(OFOplinkChannelPowerVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getInPort() {
        return inPort;
    }

    @Override
    public OFOplinkChannelPower.Builder setInPort(int inPort) {
        this.inPort = inPort;
        this.inPortSet = true;
        return this;
    }
    @Override
    public int getOutPort() {
        return outPort;
    }

    @Override
    public OFOplinkChannelPower.Builder setOutPort(int outPort) {
        this.outPort = outPort;
        this.outPortSet = true;
        return this;
    }
    @Override
    public int getChannel() {
        return channel;
    }

    @Override
    public OFOplinkChannelPower.Builder setChannel(int channel) {
        this.channel = channel;
        this.channelSet = true;
        return this;
    }
    @Override
    public int getPowerValue() {
        return powerValue;
    }

    @Override
    public OFOplinkChannelPower.Builder setPowerValue(int powerValue) {
        this.powerValue = powerValue;
        this.powerValueSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFOplinkChannelPower build() {
                int inPort = this.inPortSet ? this.inPort : parentMessage.inPort;
                int outPort = this.outPortSet ? this.outPort : parentMessage.outPort;
                int channel = this.channelSet ? this.channel : parentMessage.channel;
                int powerValue = this.powerValueSet ? this.powerValue : parentMessage.powerValue;

                //
                return new OFOplinkChannelPowerVer13(
                    inPort,
                    outPort,
                    channel,
                    powerValue
                );
        }

    }

    static class Builder implements OFOplinkChannelPower.Builder {
        // OF message fields
        private boolean inPortSet;
        private int inPort;
        private boolean outPortSet;
        private int outPort;
        private boolean channelSet;
        private int channel;
        private boolean powerValueSet;
        private int powerValue;

    @Override
    public int getInPort() {
        return inPort;
    }

    @Override
    public OFOplinkChannelPower.Builder setInPort(int inPort) {
        this.inPort = inPort;
        this.inPortSet = true;
        return this;
    }
    @Override
    public int getOutPort() {
        return outPort;
    }

    @Override
    public OFOplinkChannelPower.Builder setOutPort(int outPort) {
        this.outPort = outPort;
        this.outPortSet = true;
        return this;
    }
    @Override
    public int getChannel() {
        return channel;
    }

    @Override
    public OFOplinkChannelPower.Builder setChannel(int channel) {
        this.channel = channel;
        this.channelSet = true;
        return this;
    }
    @Override
    public int getPowerValue() {
        return powerValue;
    }

    @Override
    public OFOplinkChannelPower.Builder setPowerValue(int powerValue) {
        this.powerValue = powerValue;
        this.powerValueSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFOplinkChannelPower build() {
            int inPort = this.inPortSet ? this.inPort : DEFAULT_IN_PORT;
            int outPort = this.outPortSet ? this.outPort : DEFAULT_OUT_PORT;
            int channel = this.channelSet ? this.channel : DEFAULT_CHANNEL;
            int powerValue = this.powerValueSet ? this.powerValue : DEFAULT_POWER_VALUE;


            return new OFOplinkChannelPowerVer13(
                    inPort,
                    outPort,
                    channel,
                    powerValue
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOplinkChannelPower> {
        @Override
        public OFOplinkChannelPower readFrom(ByteBuf bb) throws OFParseError {
            int inPort = U16.f(bb.readShort());
            int outPort = U16.f(bb.readShort());
            int channel = U16.f(bb.readShort());
            int powerValue = U16.f(bb.readShort());

            OFOplinkChannelPowerVer13 oplinkChannelPowerVer13 = new OFOplinkChannelPowerVer13(
                    inPort,
                      outPort,
                      channel,
                      powerValue
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oplinkChannelPowerVer13);
            return oplinkChannelPowerVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOplinkChannelPowerVer13Funnel FUNNEL = new OFOplinkChannelPowerVer13Funnel();
    static class OFOplinkChannelPowerVer13Funnel implements Funnel<OFOplinkChannelPowerVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOplinkChannelPowerVer13 message, PrimitiveSink sink) {
            sink.putInt(message.inPort);
            sink.putInt(message.outPort);
            sink.putInt(message.channel);
            sink.putInt(message.powerValue);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOplinkChannelPowerVer13> {
        @Override
        public void write(ByteBuf bb, OFOplinkChannelPowerVer13 message) {
            bb.writeShort(U16.t(message.inPort));
            bb.writeShort(U16.t(message.outPort));
            bb.writeShort(U16.t(message.channel));
            bb.writeShort(U16.t(message.powerValue));


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOplinkChannelPowerVer13(");
        b.append("inPort=").append(inPort);
        b.append(", ");
        b.append("outPort=").append(outPort);
        b.append(", ");
        b.append("channel=").append(channel);
        b.append(", ");
        b.append("powerValue=").append(powerValue);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOplinkChannelPowerVer13 other = (OFOplinkChannelPowerVer13) obj;

        if( inPort != other.inPort)
            return false;
        if( outPort != other.outPort)
            return false;
        if( channel != other.channel)
            return false;
        if( powerValue != other.powerValue)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + inPort;
        result = prime * result + outPort;
        result = prime * result + channel;
        result = prime * result + powerValue;
        return result;
    }

}
