// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOplinkPortPowerSetVer13 implements OFOplinkPortPowerSet {
    private static final Logger logger = LoggerFactory.getLogger(OFOplinkPortPowerSetVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 20;

        private final static long DEFAULT_XID = 0x0L;
        private final static int DEFAULT_PORT = 0x0;
        private final static int DEFAULT_POWER_VALUE = 0x0;

    // OF message fields
    private final long xid;
    private final int port;
    private final int powerValue;
//
    // Immutable default instance
    final static OFOplinkPortPowerSetVer13 DEFAULT = new OFOplinkPortPowerSetVer13(
        DEFAULT_XID, DEFAULT_PORT, DEFAULT_POWER_VALUE
    );

    // package private constructor - used by readers, builders, and factory
    OFOplinkPortPowerSetVer13(long xid, int port, int powerValue) {
        this.xid = xid;
        this.port = port;
        this.powerValue = powerValue;
    }

    // Accessors for OF message fields
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public long getExperimenter() {
        return 0xff000088L;
    }

    @Override
    public long getExpType() {
        return 0xaL;
    }

    @Override
    public int getPort() {
        return port;
    }

    @Override
    public int getPowerValue() {
        return powerValue;
    }



    public OFOplinkPortPowerSet.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOplinkPortPowerSet.Builder {
        final OFOplinkPortPowerSetVer13 parentMessage;

        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean portSet;
        private int port;
        private boolean powerValueSet;
        private int powerValue;

        BuilderWithParent(OFOplinkPortPowerSetVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFOplinkPortPowerSet.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public long getExperimenter() {
        return 0xff000088L;
    }

    @Override
    public long getExpType() {
        return 0xaL;
    }

    @Override
    public int getPort() {
        return port;
    }

    @Override
    public OFOplinkPortPowerSet.Builder setPort(int port) {
        this.port = port;
        this.portSet = true;
        return this;
    }
    @Override
    public int getPowerValue() {
        return powerValue;
    }

    @Override
    public OFOplinkPortPowerSet.Builder setPowerValue(int powerValue) {
        this.powerValue = powerValue;
        this.powerValueSet = true;
        return this;
    }


        @Override
        public OFOplinkPortPowerSet build() {
                long xid = this.xidSet ? this.xid : parentMessage.xid;
                int port = this.portSet ? this.port : parentMessage.port;
                int powerValue = this.powerValueSet ? this.powerValue : parentMessage.powerValue;

                //
                return new OFOplinkPortPowerSetVer13(
                    xid,
                    port,
                    powerValue
                );
        }

    }

    static class Builder implements OFOplinkPortPowerSet.Builder {
        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean portSet;
        private int port;
        private boolean powerValueSet;
        private int powerValue;

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFOplinkPortPowerSet.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public long getExperimenter() {
        return 0xff000088L;
    }

    @Override
    public long getExpType() {
        return 0xaL;
    }

    @Override
    public int getPort() {
        return port;
    }

    @Override
    public OFOplinkPortPowerSet.Builder setPort(int port) {
        this.port = port;
        this.portSet = true;
        return this;
    }
    @Override
    public int getPowerValue() {
        return powerValue;
    }

    @Override
    public OFOplinkPortPowerSet.Builder setPowerValue(int powerValue) {
        this.powerValue = powerValue;
        this.powerValueSet = true;
        return this;
    }
//
        @Override
        public OFOplinkPortPowerSet build() {
            long xid = this.xidSet ? this.xid : DEFAULT_XID;
            int port = this.portSet ? this.port : DEFAULT_PORT;
            int powerValue = this.powerValueSet ? this.powerValue : DEFAULT_POWER_VALUE;


            return new OFOplinkPortPowerSetVer13(
                    xid,
                    port,
                    powerValue
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOplinkPortPowerSet> {
        @Override
        public OFOplinkPortPowerSet readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property version == 4
            byte version = bb.readByte();
            if(version != (byte) 0x4)
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got="+version);
            // fixed value property type == 4
            byte type = bb.readByte();
            if(type != (byte) 0x4)
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 20)
                throw new OFParseError("Wrong length: Expected=20(20), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            long xid = U32.f(bb.readInt());
            // fixed value property experimenter == 0xff000088L
            int experimenter = bb.readInt();
            if(experimenter != (int) 0xff000088)
                throw new OFParseError("Wrong experimenter: Expected=0xff000088L(0xff000088L), got="+experimenter);
            // fixed value property expType == 0xaL
            int expType = bb.readInt();
            if(expType != 0xa)
                throw new OFParseError("Wrong expType: Expected=0xaL(0xaL), got="+expType);
            int port = U16.f(bb.readShort());
            int powerValue = U16.f(bb.readShort());

            OFOplinkPortPowerSetVer13 oplinkPortPowerSetVer13 = new OFOplinkPortPowerSetVer13(
                    xid,
                      port,
                      powerValue
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oplinkPortPowerSetVer13);
            return oplinkPortPowerSetVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOplinkPortPowerSetVer13Funnel FUNNEL = new OFOplinkPortPowerSetVer13Funnel();
    static class OFOplinkPortPowerSetVer13Funnel implements Funnel<OFOplinkPortPowerSetVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOplinkPortPowerSetVer13 message, PrimitiveSink sink) {
            // fixed value property version = 4
            sink.putByte((byte) 0x4);
            // fixed value property type = 4
            sink.putByte((byte) 0x4);
            // fixed value property length = 20
            sink.putShort((short) 0x14);
            sink.putLong(message.xid);
            // fixed value property experimenter = 0xff000088L
            sink.putInt((int) 0xff000088);
            // fixed value property expType = 0xaL
            sink.putInt(0xa);
            sink.putInt(message.port);
            sink.putInt(message.powerValue);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOplinkPortPowerSetVer13> {
        @Override
        public void write(ByteBuf bb, OFOplinkPortPowerSetVer13 message) {
            // fixed value property version = 4
            bb.writeByte((byte) 0x4);
            // fixed value property type = 4
            bb.writeByte((byte) 0x4);
            // fixed value property length = 20
            bb.writeShort((short) 0x14);
            bb.writeInt(U32.t(message.xid));
            // fixed value property experimenter = 0xff000088L
            bb.writeInt((int) 0xff000088);
            // fixed value property expType = 0xaL
            bb.writeInt(0xa);
            bb.writeShort(U16.t(message.port));
            bb.writeShort(U16.t(message.powerValue));


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOplinkPortPowerSetVer13(");
        b.append("xid=").append(xid);
        b.append(", ");
        b.append("port=").append(port);
        b.append(", ");
        b.append("powerValue=").append(powerValue);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOplinkPortPowerSetVer13 other = (OFOplinkPortPowerSetVer13) obj;

        if( xid != other.xid)
            return false;
        if( port != other.port)
            return false;
        if( powerValue != other.powerValue)
            return false;
        return true;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOplinkPortPowerSetVer13 other = (OFOplinkPortPowerSetVer13) obj;

        // ignore XID
        if( port != other.port)
            return false;
        if( powerValue != other.powerValue)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime *  (int) (xid ^ (xid >>> 32));
        result = prime * result + port;
        result = prime * result + powerValue;
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        final int prime = 31;
        int result = 1;

        // ignore XID
        result = prime * result + port;
        result = prime * result + powerValue;
        return result;
    }

}
