// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOxmOchSigidBasicVer13 implements OFOxmOchSigidBasic {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmOchSigidBasicVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 10;

        private final static CircuitSignalID DEFAULT_VALUE = CircuitSignalID.NONE;

    // OF message fields
    private final CircuitSignalID value;
//
    // Immutable default instance
    final static OFOxmOchSigidBasicVer13 DEFAULT = new OFOxmOchSigidBasicVer13(
        DEFAULT_VALUE
    );

    // package private constructor - used by readers, builders, and factory
    OFOxmOchSigidBasicVer13(CircuitSignalID value) {
        if(value == null) {
            throw new NullPointerException("OFOxmOchSigidBasicVer13: property value cannot be null");
        }
        this.value = value;
    }

    // Accessors for OF message fields
    @Override
    public long getTypeLen() {
        return 0x80005a06L;
    }

    @Override
    public CircuitSignalID getValue() {
        return value;
    }

    @Override
    public MatchField<CircuitSignalID> getMatchField() {
        return MatchField.OCH_SIGID_BASIC;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    public OFOxm<CircuitSignalID> getCanonical() {
        // exact match OXM is always canonical
        return this;
    }

    @Override
    public CircuitSignalID getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFOxmOchSigidBasic.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOxmOchSigidBasic.Builder {
        final OFOxmOchSigidBasicVer13 parentMessage;

        // OF message fields
        private boolean valueSet;
        private CircuitSignalID value;

        BuilderWithParent(OFOxmOchSigidBasicVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public long getTypeLen() {
        return 0x80005a06L;
    }

    @Override
    public CircuitSignalID getValue() {
        return value;
    }

    @Override
    public OFOxmOchSigidBasic.Builder setValue(CircuitSignalID value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public MatchField<CircuitSignalID> getMatchField() {
        return MatchField.OCH_SIGID_BASIC;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<CircuitSignalID> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
    }

    @Override
    public CircuitSignalID getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFOxmOchSigidBasic build() {
                CircuitSignalID value = this.valueSet ? this.value : parentMessage.value;
                if(value == null)
                    throw new NullPointerException("Property value must not be null");

                //
                return new OFOxmOchSigidBasicVer13(
                    value
                );
        }

    }

    static class Builder implements OFOxmOchSigidBasic.Builder {
        // OF message fields
        private boolean valueSet;
        private CircuitSignalID value;

    @Override
    public long getTypeLen() {
        return 0x80005a06L;
    }

    @Override
    public CircuitSignalID getValue() {
        return value;
    }

    @Override
    public OFOxmOchSigidBasic.Builder setValue(CircuitSignalID value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public MatchField<CircuitSignalID> getMatchField() {
        return MatchField.OCH_SIGID_BASIC;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<CircuitSignalID> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
    }

    @Override
    public CircuitSignalID getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFOxmOchSigidBasic build() {
            CircuitSignalID value = this.valueSet ? this.value : DEFAULT_VALUE;
            if(value == null)
                throw new NullPointerException("Property value must not be null");


            return new OFOxmOchSigidBasicVer13(
                    value
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOxmOchSigidBasic> {
        @Override
        public OFOxmOchSigidBasic readFrom(ByteBuf bb) throws OFParseError {
            // fixed value property typeLen == 0x80005a06L
            int typeLen = bb.readInt();
            if(typeLen != (int) 0x80005a06)
                throw new OFParseError("Wrong typeLen: Expected=0x80005a06L(0x80005a06L), got="+typeLen);
            CircuitSignalID value = CircuitSignalID.read6Bytes(bb);

            OFOxmOchSigidBasicVer13 oxmOchSigidBasicVer13 = new OFOxmOchSigidBasicVer13(
                    value
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oxmOchSigidBasicVer13);
            return oxmOchSigidBasicVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOxmOchSigidBasicVer13Funnel FUNNEL = new OFOxmOchSigidBasicVer13Funnel();
    static class OFOxmOchSigidBasicVer13Funnel implements Funnel<OFOxmOchSigidBasicVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOxmOchSigidBasicVer13 message, PrimitiveSink sink) {
            // fixed value property typeLen = 0x80005a06L
            sink.putInt((int) 0x80005a06);
            message.value.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOxmOchSigidBasicVer13> {
        @Override
        public void write(ByteBuf bb, OFOxmOchSigidBasicVer13 message) {
            // fixed value property typeLen = 0x80005a06L
            bb.writeInt((int) 0x80005a06);
            message.value.write6Bytes(bb);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmOchSigidBasicVer13(");
        b.append("value=").append(value);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOxmOchSigidBasicVer13 other = (OFOxmOchSigidBasicVer13) obj;

        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

}
