// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver14;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFInstructionBsnHashSelectVer14 implements OFInstructionBsnHashSelect {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionBsnHashSelectVer14.class);
    // version: 1.4
    final static byte WIRE_VERSION = 5;
    final static int LENGTH = 16;

        private final static Set<OFBsnHashSelectFlags> DEFAULT_FLAGS = ImmutableSet.<OFBsnHashSelectFlags>of();

    // OF message fields
    private final Set<OFBsnHashSelectFlags> flags;
//
    // Immutable default instance
    final static OFInstructionBsnHashSelectVer14 DEFAULT = new OFInstructionBsnHashSelectVer14(
        DEFAULT_FLAGS
    );

    // package private constructor - used by readers, builders, and factory
    OFInstructionBsnHashSelectVer14(Set<OFBsnHashSelectFlags> flags) {
        if(flags == null) {
            throw new NullPointerException("OFInstructionBsnHashSelectVer14: property flags cannot be null");
        }
        this.flags = flags;
    }

    // Accessors for OF message fields
    @Override
    public OFInstructionType getType() {
        return OFInstructionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x5c16c7L;
    }

    @Override
    public long getSubtype() {
        return 0xfL;
    }

    @Override
    public Set<OFBsnHashSelectFlags> getFlags() {
        return flags;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }



    public OFInstructionBsnHashSelect.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFInstructionBsnHashSelect.Builder {
        final OFInstructionBsnHashSelectVer14 parentMessage;

        // OF message fields
        private boolean flagsSet;
        private Set<OFBsnHashSelectFlags> flags;

        BuilderWithParent(OFInstructionBsnHashSelectVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x5c16c7L;
    }

    @Override
    public long getSubtype() {
        return 0xfL;
    }

    @Override
    public Set<OFBsnHashSelectFlags> getFlags() {
        return flags;
    }

    @Override
    public OFInstructionBsnHashSelect.Builder setFlags(Set<OFBsnHashSelectFlags> flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }



        @Override
        public OFInstructionBsnHashSelect build() {
                Set<OFBsnHashSelectFlags> flags = this.flagsSet ? this.flags : parentMessage.flags;
                if(flags == null)
                    throw new NullPointerException("Property flags must not be null");

                //
                return new OFInstructionBsnHashSelectVer14(
                    flags
                );
        }

    }

    static class Builder implements OFInstructionBsnHashSelect.Builder {
        // OF message fields
        private boolean flagsSet;
        private Set<OFBsnHashSelectFlags> flags;

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x5c16c7L;
    }

    @Override
    public long getSubtype() {
        return 0xfL;
    }

    @Override
    public Set<OFBsnHashSelectFlags> getFlags() {
        return flags;
    }

    @Override
    public OFInstructionBsnHashSelect.Builder setFlags(Set<OFBsnHashSelectFlags> flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

//
        @Override
        public OFInstructionBsnHashSelect build() {
            Set<OFBsnHashSelectFlags> flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if(flags == null)
                throw new NullPointerException("Property flags must not be null");


            return new OFInstructionBsnHashSelectVer14(
                    flags
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFInstructionBsnHashSelect> {
        @Override
        public OFInstructionBsnHashSelect readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 65535
            short type = bb.readShort();
            if(type != (short) 0xffff)
                throw new OFParseError("Wrong type: Expected=OFInstructionType.EXPERIMENTER(65535), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 16)
                throw new OFParseError("Wrong length: Expected=16(16), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // fixed value property experimenter == 0x5c16c7L
            int experimenter = bb.readInt();
            if(experimenter != 0x5c16c7)
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got="+experimenter);
            // fixed value property subtype == 0xfL
            int subtype = bb.readInt();
            if(subtype != 0xf)
                throw new OFParseError("Wrong subtype: Expected=0xfL(0xfL), got="+subtype);
            Set<OFBsnHashSelectFlags> flags = OFBsnHashSelectFlagsSerializerVer14.readFrom(bb);

            OFInstructionBsnHashSelectVer14 instructionBsnHashSelectVer14 = new OFInstructionBsnHashSelectVer14(
                    flags
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", instructionBsnHashSelectVer14);
            return instructionBsnHashSelectVer14;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFInstructionBsnHashSelectVer14Funnel FUNNEL = new OFInstructionBsnHashSelectVer14Funnel();
    static class OFInstructionBsnHashSelectVer14Funnel implements Funnel<OFInstructionBsnHashSelectVer14> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFInstructionBsnHashSelectVer14 message, PrimitiveSink sink) {
            // fixed value property type = 65535
            sink.putShort((short) 0xffff);
            // fixed value property length = 16
            sink.putShort((short) 0x10);
            // fixed value property experimenter = 0x5c16c7L
            sink.putInt(0x5c16c7);
            // fixed value property subtype = 0xfL
            sink.putInt(0xf);
            OFBsnHashSelectFlagsSerializerVer14.putTo(message.flags, sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFInstructionBsnHashSelectVer14> {
        @Override
        public void write(ByteBuf bb, OFInstructionBsnHashSelectVer14 message) {
            // fixed value property type = 65535
            bb.writeShort((short) 0xffff);
            // fixed value property length = 16
            bb.writeShort((short) 0x10);
            // fixed value property experimenter = 0x5c16c7L
            bb.writeInt(0x5c16c7);
            // fixed value property subtype = 0xfL
            bb.writeInt(0xf);
            OFBsnHashSelectFlagsSerializerVer14.writeTo(bb, message.flags);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionBsnHashSelectVer14(");
        b.append("flags=").append(flags);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFInstructionBsnHashSelectVer14 other = (OFInstructionBsnHashSelectVer14) obj;

        if (flags == null) {
            if (other.flags != null)
                return false;
        } else if (!flags.equals(other.flags))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((flags == null) ? 0 : flags.hashCode());
        return result;
    }

}
