// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFInstructionStatTriggerVer15 implements OFInstructionStatTrigger {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionStatTriggerVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int MINIMUM_LENGTH = 8;

        private final static Set<OFStatTriggerFlags> DEFAULT_FLAGS = ImmutableSet.<OFStatTriggerFlags>of();
        private final static OFOxsList DEFAULT_THRESHOLDS = OFOxsList.EMPTY;

    // OF message fields
    private final Set<OFStatTriggerFlags> flags;
    private final OFOxsList thresholds;
//
    // Immutable default instance
    final static OFInstructionStatTriggerVer15 DEFAULT = new OFInstructionStatTriggerVer15(
        DEFAULT_FLAGS, DEFAULT_THRESHOLDS
    );

    // package private constructor - used by readers, builders, and factory
    OFInstructionStatTriggerVer15(Set<OFStatTriggerFlags> flags, OFOxsList thresholds) {
        if(flags == null) {
            throw new NullPointerException("OFInstructionStatTriggerVer15: property flags cannot be null");
        }
        if(thresholds == null) {
            throw new NullPointerException("OFInstructionStatTriggerVer15: property thresholds cannot be null");
        }
        this.flags = flags;
        this.thresholds = thresholds;
    }

    // Accessors for OF message fields
    @Override
    public OFInstructionType getType() {
        return OFInstructionType.STAT_TRIGGER;
    }

    @Override
    public Set<OFStatTriggerFlags> getFlags() {
        return flags;
    }

    @Override
    public OFOxsList getThresholds() {
        return thresholds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



    public OFInstructionStatTrigger.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFInstructionStatTrigger.Builder {
        final OFInstructionStatTriggerVer15 parentMessage;

        // OF message fields
        private boolean flagsSet;
        private Set<OFStatTriggerFlags> flags;
        private boolean thresholdsSet;
        private OFOxsList thresholds;

        BuilderWithParent(OFInstructionStatTriggerVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.STAT_TRIGGER;
    }

    @Override
    public Set<OFStatTriggerFlags> getFlags() {
        return flags;
    }

    @Override
    public OFInstructionStatTrigger.Builder setFlags(Set<OFStatTriggerFlags> flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public OFOxsList getThresholds() {
        return thresholds;
    }

    @Override
    public OFInstructionStatTrigger.Builder setThresholds(OFOxsList thresholds) {
        this.thresholds = thresholds;
        this.thresholdsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



        @Override
        public OFInstructionStatTrigger build() {
                Set<OFStatTriggerFlags> flags = this.flagsSet ? this.flags : parentMessage.flags;
                if(flags == null)
                    throw new NullPointerException("Property flags must not be null");
                OFOxsList thresholds = this.thresholdsSet ? this.thresholds : parentMessage.thresholds;
                if(thresholds == null)
                    throw new NullPointerException("Property thresholds must not be null");

                //
                return new OFInstructionStatTriggerVer15(
                    flags,
                    thresholds
                );
        }

    }

    static class Builder implements OFInstructionStatTrigger.Builder {
        // OF message fields
        private boolean flagsSet;
        private Set<OFStatTriggerFlags> flags;
        private boolean thresholdsSet;
        private OFOxsList thresholds;

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.STAT_TRIGGER;
    }

    @Override
    public Set<OFStatTriggerFlags> getFlags() {
        return flags;
    }

    @Override
    public OFInstructionStatTrigger.Builder setFlags(Set<OFStatTriggerFlags> flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public OFOxsList getThresholds() {
        return thresholds;
    }

    @Override
    public OFInstructionStatTrigger.Builder setThresholds(OFOxsList thresholds) {
        this.thresholds = thresholds;
        this.thresholdsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

//
        @Override
        public OFInstructionStatTrigger build() {
            Set<OFStatTriggerFlags> flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if(flags == null)
                throw new NullPointerException("Property flags must not be null");
            OFOxsList thresholds = this.thresholdsSet ? this.thresholds : DEFAULT_THRESHOLDS;
            if(thresholds == null)
                throw new NullPointerException("Property thresholds must not be null");


            return new OFInstructionStatTriggerVer15(
                    flags,
                    thresholds
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFInstructionStatTrigger> {
        @Override
        public OFInstructionStatTrigger readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 7
            short type = bb.readShort();
            if(type != (short) 0x7)
                throw new OFParseError("Wrong type: Expected=OFInstructionType.STAT_TRIGGER(7), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            Set<OFStatTriggerFlags> flags = OFStatTriggerFlagsSerializerVer15.readFrom(bb);
            OFOxsList thresholds = OFOxsList.readFrom(bb, length - (bb.readerIndex() - start), OFOxsVer15.READER);

            OFInstructionStatTriggerVer15 instructionStatTriggerVer15 = new OFInstructionStatTriggerVer15(
                    flags,
                      thresholds
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", instructionStatTriggerVer15);
            return instructionStatTriggerVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFInstructionStatTriggerVer15Funnel FUNNEL = new OFInstructionStatTriggerVer15Funnel();
    static class OFInstructionStatTriggerVer15Funnel implements Funnel<OFInstructionStatTriggerVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFInstructionStatTriggerVer15 message, PrimitiveSink sink) {
            // fixed value property type = 7
            sink.putShort((short) 0x7);
            // FIXME: skip funnel of length
            OFStatTriggerFlagsSerializerVer15.putTo(message.flags, sink);
            message.thresholds.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFInstructionStatTriggerVer15> {
        @Override
        public void write(ByteBuf bb, OFInstructionStatTriggerVer15 message) {
            int startIndex = bb.writerIndex();
            // fixed value property type = 7
            bb.writeShort((short) 0x7);
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            OFStatTriggerFlagsSerializerVer15.writeTo(bb, message.flags);
            message.thresholds.writeTo(bb);

            // update length field
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionStatTriggerVer15(");
        b.append("flags=").append(flags);
        b.append(", ");
        b.append("thresholds=").append(thresholds);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFInstructionStatTriggerVer15 other = (OFInstructionStatTriggerVer15) obj;

        if (flags == null) {
            if (other.flags != null)
                return false;
        } else if (!flags.equals(other.flags))
            return false;
        if (thresholds == null) {
            if (other.thresholds != null)
                return false;
        } else if (!thresholds.equals(other.thresholds))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((flags == null) ? 0 : flags.hashCode());
        result = prime * result + ((thresholds == null) ? 0 : thresholds.hashCode());
        return result;
    }

}
