// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFPortStatsPropExperimenterIntelVer15 implements OFPortStatsPropExperimenterIntel {
    private static final Logger logger = LoggerFactory.getLogger(OFPortStatsPropExperimenterIntelVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int LENGTH = 184;

        private final static U64 DEFAULT_RX_1_TO_64_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_RX_65_TO_127_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_RX_128_TO_255_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_RX_256_TO_511_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_RX_512_TO_1023_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_RX_1024_TO_1522_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_RX_1523_TO_MAX_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_TX_1_TO_64_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_TX_65_TO_127_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_TX_128_TO_255_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_TX_256_TO_511_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_TX_512_TO_1023_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_TX_1024_TO_1522_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_TX_1523_TO_MAX_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_TX_MULTICAST_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_RX_BROADCAST_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_TX_BROADCAST_PACKETS = U64.ZERO;
        private final static U64 DEFAULT_RX_UNDERSIZED_ERRORS = U64.ZERO;
        private final static U64 DEFAULT_RX_OVERSIZE_ERRORS = U64.ZERO;
        private final static U64 DEFAULT_RX_FRAGMENTED_ERRORS = U64.ZERO;
        private final static U64 DEFAULT_RX_JABBER_ERRORS = U64.ZERO;

    // OF message fields
    private final U64 rx1To64Packets;
    private final U64 rx65To127Packets;
    private final U64 rx128To255Packets;
    private final U64 rx256To511Packets;
    private final U64 rx512To1023Packets;
    private final U64 rx1024To1522Packets;
    private final U64 rx1523ToMaxPackets;
    private final U64 tx1To64Packets;
    private final U64 tx65To127Packets;
    private final U64 tx128To255Packets;
    private final U64 tx256To511Packets;
    private final U64 tx512To1023Packets;
    private final U64 tx1024To1522Packets;
    private final U64 tx1523ToMaxPackets;
    private final U64 txMulticastPackets;
    private final U64 rxBroadcastPackets;
    private final U64 txBroadcastPackets;
    private final U64 rxUndersizedErrors;
    private final U64 rxOversizeErrors;
    private final U64 rxFragmentedErrors;
    private final U64 rxJabberErrors;
//
    // Immutable default instance
    final static OFPortStatsPropExperimenterIntelVer15 DEFAULT = new OFPortStatsPropExperimenterIntelVer15(
        DEFAULT_RX_1_TO_64_PACKETS, DEFAULT_RX_65_TO_127_PACKETS, DEFAULT_RX_128_TO_255_PACKETS, DEFAULT_RX_256_TO_511_PACKETS, DEFAULT_RX_512_TO_1023_PACKETS, DEFAULT_RX_1024_TO_1522_PACKETS, DEFAULT_RX_1523_TO_MAX_PACKETS, DEFAULT_TX_1_TO_64_PACKETS, DEFAULT_TX_65_TO_127_PACKETS, DEFAULT_TX_128_TO_255_PACKETS, DEFAULT_TX_256_TO_511_PACKETS, DEFAULT_TX_512_TO_1023_PACKETS, DEFAULT_TX_1024_TO_1522_PACKETS, DEFAULT_TX_1523_TO_MAX_PACKETS, DEFAULT_TX_MULTICAST_PACKETS, DEFAULT_RX_BROADCAST_PACKETS, DEFAULT_TX_BROADCAST_PACKETS, DEFAULT_RX_UNDERSIZED_ERRORS, DEFAULT_RX_OVERSIZE_ERRORS, DEFAULT_RX_FRAGMENTED_ERRORS, DEFAULT_RX_JABBER_ERRORS
    );

    // package private constructor - used by readers, builders, and factory
    OFPortStatsPropExperimenterIntelVer15(U64 rx1To64Packets, U64 rx65To127Packets, U64 rx128To255Packets, U64 rx256To511Packets, U64 rx512To1023Packets, U64 rx1024To1522Packets, U64 rx1523ToMaxPackets, U64 tx1To64Packets, U64 tx65To127Packets, U64 tx128To255Packets, U64 tx256To511Packets, U64 tx512To1023Packets, U64 tx1024To1522Packets, U64 tx1523ToMaxPackets, U64 txMulticastPackets, U64 rxBroadcastPackets, U64 txBroadcastPackets, U64 rxUndersizedErrors, U64 rxOversizeErrors, U64 rxFragmentedErrors, U64 rxJabberErrors) {
        if(rx1To64Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx1To64Packets cannot be null");
        }
        if(rx65To127Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx65To127Packets cannot be null");
        }
        if(rx128To255Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx128To255Packets cannot be null");
        }
        if(rx256To511Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx256To511Packets cannot be null");
        }
        if(rx512To1023Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx512To1023Packets cannot be null");
        }
        if(rx1024To1522Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx1024To1522Packets cannot be null");
        }
        if(rx1523ToMaxPackets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rx1523ToMaxPackets cannot be null");
        }
        if(tx1To64Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx1To64Packets cannot be null");
        }
        if(tx65To127Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx65To127Packets cannot be null");
        }
        if(tx128To255Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx128To255Packets cannot be null");
        }
        if(tx256To511Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx256To511Packets cannot be null");
        }
        if(tx512To1023Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx512To1023Packets cannot be null");
        }
        if(tx1024To1522Packets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx1024To1522Packets cannot be null");
        }
        if(tx1523ToMaxPackets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property tx1523ToMaxPackets cannot be null");
        }
        if(txMulticastPackets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property txMulticastPackets cannot be null");
        }
        if(rxBroadcastPackets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rxBroadcastPackets cannot be null");
        }
        if(txBroadcastPackets == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property txBroadcastPackets cannot be null");
        }
        if(rxUndersizedErrors == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rxUndersizedErrors cannot be null");
        }
        if(rxOversizeErrors == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rxOversizeErrors cannot be null");
        }
        if(rxFragmentedErrors == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rxFragmentedErrors cannot be null");
        }
        if(rxJabberErrors == null) {
            throw new NullPointerException("OFPortStatsPropExperimenterIntelVer15: property rxJabberErrors cannot be null");
        }
        this.rx1To64Packets = rx1To64Packets;
        this.rx65To127Packets = rx65To127Packets;
        this.rx128To255Packets = rx128To255Packets;
        this.rx256To511Packets = rx256To511Packets;
        this.rx512To1023Packets = rx512To1023Packets;
        this.rx1024To1522Packets = rx1024To1522Packets;
        this.rx1523ToMaxPackets = rx1523ToMaxPackets;
        this.tx1To64Packets = tx1To64Packets;
        this.tx65To127Packets = tx65To127Packets;
        this.tx128To255Packets = tx128To255Packets;
        this.tx256To511Packets = tx256To511Packets;
        this.tx512To1023Packets = tx512To1023Packets;
        this.tx1024To1522Packets = tx1024To1522Packets;
        this.tx1523ToMaxPackets = tx1523ToMaxPackets;
        this.txMulticastPackets = txMulticastPackets;
        this.rxBroadcastPackets = rxBroadcastPackets;
        this.txBroadcastPackets = txBroadcastPackets;
        this.rxUndersizedErrors = rxUndersizedErrors;
        this.rxOversizeErrors = rxOversizeErrors;
        this.rxFragmentedErrors = rxFragmentedErrors;
        this.rxJabberErrors = rxJabberErrors;
    }

    // Accessors for OF message fields
    @Override
    public int getType() {
        return 0xffff;
    }

    @Override
    public long getExperimenter() {
        return 0xaa01L;
    }

    @Override
    public long getExpType() {
        return 0x1L;
    }

    @Override
    public U64 getRx1To64Packets() {
        return rx1To64Packets;
    }

    @Override
    public U64 getRx65To127Packets() {
        return rx65To127Packets;
    }

    @Override
    public U64 getRx128To255Packets() {
        return rx128To255Packets;
    }

    @Override
    public U64 getRx256To511Packets() {
        return rx256To511Packets;
    }

    @Override
    public U64 getRx512To1023Packets() {
        return rx512To1023Packets;
    }

    @Override
    public U64 getRx1024To1522Packets() {
        return rx1024To1522Packets;
    }

    @Override
    public U64 getRx1523ToMaxPackets() {
        return rx1523ToMaxPackets;
    }

    @Override
    public U64 getTx1To64Packets() {
        return tx1To64Packets;
    }

    @Override
    public U64 getTx65To127Packets() {
        return tx65To127Packets;
    }

    @Override
    public U64 getTx128To255Packets() {
        return tx128To255Packets;
    }

    @Override
    public U64 getTx256To511Packets() {
        return tx256To511Packets;
    }

    @Override
    public U64 getTx512To1023Packets() {
        return tx512To1023Packets;
    }

    @Override
    public U64 getTx1024To1522Packets() {
        return tx1024To1522Packets;
    }

    @Override
    public U64 getTx1523ToMaxPackets() {
        return tx1523ToMaxPackets;
    }

    @Override
    public U64 getTxMulticastPackets() {
        return txMulticastPackets;
    }

    @Override
    public U64 getRxBroadcastPackets() {
        return rxBroadcastPackets;
    }

    @Override
    public U64 getTxBroadcastPackets() {
        return txBroadcastPackets;
    }

    @Override
    public U64 getRxUndersizedErrors() {
        return rxUndersizedErrors;
    }

    @Override
    public U64 getRxOversizeErrors() {
        return rxOversizeErrors;
    }

    @Override
    public U64 getRxFragmentedErrors() {
        return rxFragmentedErrors;
    }

    @Override
    public U64 getRxJabberErrors() {
        return rxJabberErrors;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



    public OFPortStatsPropExperimenterIntel.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFPortStatsPropExperimenterIntel.Builder {
        final OFPortStatsPropExperimenterIntelVer15 parentMessage;

        // OF message fields
        private boolean rx1To64PacketsSet;
        private U64 rx1To64Packets;
        private boolean rx65To127PacketsSet;
        private U64 rx65To127Packets;
        private boolean rx128To255PacketsSet;
        private U64 rx128To255Packets;
        private boolean rx256To511PacketsSet;
        private U64 rx256To511Packets;
        private boolean rx512To1023PacketsSet;
        private U64 rx512To1023Packets;
        private boolean rx1024To1522PacketsSet;
        private U64 rx1024To1522Packets;
        private boolean rx1523ToMaxPacketsSet;
        private U64 rx1523ToMaxPackets;
        private boolean tx1To64PacketsSet;
        private U64 tx1To64Packets;
        private boolean tx65To127PacketsSet;
        private U64 tx65To127Packets;
        private boolean tx128To255PacketsSet;
        private U64 tx128To255Packets;
        private boolean tx256To511PacketsSet;
        private U64 tx256To511Packets;
        private boolean tx512To1023PacketsSet;
        private U64 tx512To1023Packets;
        private boolean tx1024To1522PacketsSet;
        private U64 tx1024To1522Packets;
        private boolean tx1523ToMaxPacketsSet;
        private U64 tx1523ToMaxPackets;
        private boolean txMulticastPacketsSet;
        private U64 txMulticastPackets;
        private boolean rxBroadcastPacketsSet;
        private U64 rxBroadcastPackets;
        private boolean txBroadcastPacketsSet;
        private U64 txBroadcastPackets;
        private boolean rxUndersizedErrorsSet;
        private U64 rxUndersizedErrors;
        private boolean rxOversizeErrorsSet;
        private U64 rxOversizeErrors;
        private boolean rxFragmentedErrorsSet;
        private U64 rxFragmentedErrors;
        private boolean rxJabberErrorsSet;
        private U64 rxJabberErrors;

        BuilderWithParent(OFPortStatsPropExperimenterIntelVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getType() {
        return 0xffff;
    }

    @Override
    public long getExperimenter() {
        return 0xaa01L;
    }

    @Override
    public long getExpType() {
        return 0x1L;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
    }
    @Override
    public U64 getRx1To64Packets() {
        return rx1To64Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx1To64Packets(U64 rx1To64Packets) {
        this.rx1To64Packets = rx1To64Packets;
        this.rx1To64PacketsSet = true;
        return this;
    }
    @Override
    public U64 getRx65To127Packets() {
        return rx65To127Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx65To127Packets(U64 rx65To127Packets) {
        this.rx65To127Packets = rx65To127Packets;
        this.rx65To127PacketsSet = true;
        return this;
    }
    @Override
    public U64 getRx128To255Packets() {
        return rx128To255Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx128To255Packets(U64 rx128To255Packets) {
        this.rx128To255Packets = rx128To255Packets;
        this.rx128To255PacketsSet = true;
        return this;
    }
    @Override
    public U64 getRx256To511Packets() {
        return rx256To511Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx256To511Packets(U64 rx256To511Packets) {
        this.rx256To511Packets = rx256To511Packets;
        this.rx256To511PacketsSet = true;
        return this;
    }
    @Override
    public U64 getRx512To1023Packets() {
        return rx512To1023Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx512To1023Packets(U64 rx512To1023Packets) {
        this.rx512To1023Packets = rx512To1023Packets;
        this.rx512To1023PacketsSet = true;
        return this;
    }
    @Override
    public U64 getRx1024To1522Packets() {
        return rx1024To1522Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx1024To1522Packets(U64 rx1024To1522Packets) {
        this.rx1024To1522Packets = rx1024To1522Packets;
        this.rx1024To1522PacketsSet = true;
        return this;
    }
    @Override
    public U64 getRx1523ToMaxPackets() {
        return rx1523ToMaxPackets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx1523ToMaxPackets(U64 rx1523ToMaxPackets) {
        this.rx1523ToMaxPackets = rx1523ToMaxPackets;
        this.rx1523ToMaxPacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx1To64Packets() {
        return tx1To64Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx1To64Packets(U64 tx1To64Packets) {
        this.tx1To64Packets = tx1To64Packets;
        this.tx1To64PacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx65To127Packets() {
        return tx65To127Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx65To127Packets(U64 tx65To127Packets) {
        this.tx65To127Packets = tx65To127Packets;
        this.tx65To127PacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx128To255Packets() {
        return tx128To255Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx128To255Packets(U64 tx128To255Packets) {
        this.tx128To255Packets = tx128To255Packets;
        this.tx128To255PacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx256To511Packets() {
        return tx256To511Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx256To511Packets(U64 tx256To511Packets) {
        this.tx256To511Packets = tx256To511Packets;
        this.tx256To511PacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx512To1023Packets() {
        return tx512To1023Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx512To1023Packets(U64 tx512To1023Packets) {
        this.tx512To1023Packets = tx512To1023Packets;
        this.tx512To1023PacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx1024To1522Packets() {
        return tx1024To1522Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx1024To1522Packets(U64 tx1024To1522Packets) {
        this.tx1024To1522Packets = tx1024To1522Packets;
        this.tx1024To1522PacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx1523ToMaxPackets() {
        return tx1523ToMaxPackets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx1523ToMaxPackets(U64 tx1523ToMaxPackets) {
        this.tx1523ToMaxPackets = tx1523ToMaxPackets;
        this.tx1523ToMaxPacketsSet = true;
        return this;
    }
    @Override
    public U64 getTxMulticastPackets() {
        return txMulticastPackets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTxMulticastPackets(U64 txMulticastPackets) {
        this.txMulticastPackets = txMulticastPackets;
        this.txMulticastPacketsSet = true;
        return this;
    }
    @Override
    public U64 getRxBroadcastPackets() {
        return rxBroadcastPackets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRxBroadcastPackets(U64 rxBroadcastPackets) {
        this.rxBroadcastPackets = rxBroadcastPackets;
        this.rxBroadcastPacketsSet = true;
        return this;
    }
    @Override
    public U64 getTxBroadcastPackets() {
        return txBroadcastPackets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTxBroadcastPackets(U64 txBroadcastPackets) {
        this.txBroadcastPackets = txBroadcastPackets;
        this.txBroadcastPacketsSet = true;
        return this;
    }
    @Override
    public U64 getRxUndersizedErrors() {
        return rxUndersizedErrors;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRxUndersizedErrors(U64 rxUndersizedErrors) {
        this.rxUndersizedErrors = rxUndersizedErrors;
        this.rxUndersizedErrorsSet = true;
        return this;
    }
    @Override
    public U64 getRxOversizeErrors() {
        return rxOversizeErrors;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRxOversizeErrors(U64 rxOversizeErrors) {
        this.rxOversizeErrors = rxOversizeErrors;
        this.rxOversizeErrorsSet = true;
        return this;
    }
    @Override
    public U64 getRxFragmentedErrors() {
        return rxFragmentedErrors;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRxFragmentedErrors(U64 rxFragmentedErrors) {
        this.rxFragmentedErrors = rxFragmentedErrors;
        this.rxFragmentedErrorsSet = true;
        return this;
    }
    @Override
    public U64 getRxJabberErrors() {
        return rxJabberErrors;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRxJabberErrors(U64 rxJabberErrors) {
        this.rxJabberErrors = rxJabberErrors;
        this.rxJabberErrorsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



        @Override
        public OFPortStatsPropExperimenterIntel build() {
                U64 rx1To64Packets = this.rx1To64PacketsSet ? this.rx1To64Packets : parentMessage.rx1To64Packets;
                if(rx1To64Packets == null)
                    throw new NullPointerException("Property rx1To64Packets must not be null");
                U64 rx65To127Packets = this.rx65To127PacketsSet ? this.rx65To127Packets : parentMessage.rx65To127Packets;
                if(rx65To127Packets == null)
                    throw new NullPointerException("Property rx65To127Packets must not be null");
                U64 rx128To255Packets = this.rx128To255PacketsSet ? this.rx128To255Packets : parentMessage.rx128To255Packets;
                if(rx128To255Packets == null)
                    throw new NullPointerException("Property rx128To255Packets must not be null");
                U64 rx256To511Packets = this.rx256To511PacketsSet ? this.rx256To511Packets : parentMessage.rx256To511Packets;
                if(rx256To511Packets == null)
                    throw new NullPointerException("Property rx256To511Packets must not be null");
                U64 rx512To1023Packets = this.rx512To1023PacketsSet ? this.rx512To1023Packets : parentMessage.rx512To1023Packets;
                if(rx512To1023Packets == null)
                    throw new NullPointerException("Property rx512To1023Packets must not be null");
                U64 rx1024To1522Packets = this.rx1024To1522PacketsSet ? this.rx1024To1522Packets : parentMessage.rx1024To1522Packets;
                if(rx1024To1522Packets == null)
                    throw new NullPointerException("Property rx1024To1522Packets must not be null");
                U64 rx1523ToMaxPackets = this.rx1523ToMaxPacketsSet ? this.rx1523ToMaxPackets : parentMessage.rx1523ToMaxPackets;
                if(rx1523ToMaxPackets == null)
                    throw new NullPointerException("Property rx1523ToMaxPackets must not be null");
                U64 tx1To64Packets = this.tx1To64PacketsSet ? this.tx1To64Packets : parentMessage.tx1To64Packets;
                if(tx1To64Packets == null)
                    throw new NullPointerException("Property tx1To64Packets must not be null");
                U64 tx65To127Packets = this.tx65To127PacketsSet ? this.tx65To127Packets : parentMessage.tx65To127Packets;
                if(tx65To127Packets == null)
                    throw new NullPointerException("Property tx65To127Packets must not be null");
                U64 tx128To255Packets = this.tx128To255PacketsSet ? this.tx128To255Packets : parentMessage.tx128To255Packets;
                if(tx128To255Packets == null)
                    throw new NullPointerException("Property tx128To255Packets must not be null");
                U64 tx256To511Packets = this.tx256To511PacketsSet ? this.tx256To511Packets : parentMessage.tx256To511Packets;
                if(tx256To511Packets == null)
                    throw new NullPointerException("Property tx256To511Packets must not be null");
                U64 tx512To1023Packets = this.tx512To1023PacketsSet ? this.tx512To1023Packets : parentMessage.tx512To1023Packets;
                if(tx512To1023Packets == null)
                    throw new NullPointerException("Property tx512To1023Packets must not be null");
                U64 tx1024To1522Packets = this.tx1024To1522PacketsSet ? this.tx1024To1522Packets : parentMessage.tx1024To1522Packets;
                if(tx1024To1522Packets == null)
                    throw new NullPointerException("Property tx1024To1522Packets must not be null");
                U64 tx1523ToMaxPackets = this.tx1523ToMaxPacketsSet ? this.tx1523ToMaxPackets : parentMessage.tx1523ToMaxPackets;
                if(tx1523ToMaxPackets == null)
                    throw new NullPointerException("Property tx1523ToMaxPackets must not be null");
                U64 txMulticastPackets = this.txMulticastPacketsSet ? this.txMulticastPackets : parentMessage.txMulticastPackets;
                if(txMulticastPackets == null)
                    throw new NullPointerException("Property txMulticastPackets must not be null");
                U64 rxBroadcastPackets = this.rxBroadcastPacketsSet ? this.rxBroadcastPackets : parentMessage.rxBroadcastPackets;
                if(rxBroadcastPackets == null)
                    throw new NullPointerException("Property rxBroadcastPackets must not be null");
                U64 txBroadcastPackets = this.txBroadcastPacketsSet ? this.txBroadcastPackets : parentMessage.txBroadcastPackets;
                if(txBroadcastPackets == null)
                    throw new NullPointerException("Property txBroadcastPackets must not be null");
                U64 rxUndersizedErrors = this.rxUndersizedErrorsSet ? this.rxUndersizedErrors : parentMessage.rxUndersizedErrors;
                if(rxUndersizedErrors == null)
                    throw new NullPointerException("Property rxUndersizedErrors must not be null");
                U64 rxOversizeErrors = this.rxOversizeErrorsSet ? this.rxOversizeErrors : parentMessage.rxOversizeErrors;
                if(rxOversizeErrors == null)
                    throw new NullPointerException("Property rxOversizeErrors must not be null");
                U64 rxFragmentedErrors = this.rxFragmentedErrorsSet ? this.rxFragmentedErrors : parentMessage.rxFragmentedErrors;
                if(rxFragmentedErrors == null)
                    throw new NullPointerException("Property rxFragmentedErrors must not be null");
                U64 rxJabberErrors = this.rxJabberErrorsSet ? this.rxJabberErrors : parentMessage.rxJabberErrors;
                if(rxJabberErrors == null)
                    throw new NullPointerException("Property rxJabberErrors must not be null");

                //
                return new OFPortStatsPropExperimenterIntelVer15(
                    rx1To64Packets,
                    rx65To127Packets,
                    rx128To255Packets,
                    rx256To511Packets,
                    rx512To1023Packets,
                    rx1024To1522Packets,
                    rx1523ToMaxPackets,
                    tx1To64Packets,
                    tx65To127Packets,
                    tx128To255Packets,
                    tx256To511Packets,
                    tx512To1023Packets,
                    tx1024To1522Packets,
                    tx1523ToMaxPackets,
                    txMulticastPackets,
                    rxBroadcastPackets,
                    txBroadcastPackets,
                    rxUndersizedErrors,
                    rxOversizeErrors,
                    rxFragmentedErrors,
                    rxJabberErrors
                );
        }

    }

    static class Builder implements OFPortStatsPropExperimenterIntel.Builder {
        // OF message fields
        private boolean rx1To64PacketsSet;
        private U64 rx1To64Packets;
        private boolean rx65To127PacketsSet;
        private U64 rx65To127Packets;
        private boolean rx128To255PacketsSet;
        private U64 rx128To255Packets;
        private boolean rx256To511PacketsSet;
        private U64 rx256To511Packets;
        private boolean rx512To1023PacketsSet;
        private U64 rx512To1023Packets;
        private boolean rx1024To1522PacketsSet;
        private U64 rx1024To1522Packets;
        private boolean rx1523ToMaxPacketsSet;
        private U64 rx1523ToMaxPackets;
        private boolean tx1To64PacketsSet;
        private U64 tx1To64Packets;
        private boolean tx65To127PacketsSet;
        private U64 tx65To127Packets;
        private boolean tx128To255PacketsSet;
        private U64 tx128To255Packets;
        private boolean tx256To511PacketsSet;
        private U64 tx256To511Packets;
        private boolean tx512To1023PacketsSet;
        private U64 tx512To1023Packets;
        private boolean tx1024To1522PacketsSet;
        private U64 tx1024To1522Packets;
        private boolean tx1523ToMaxPacketsSet;
        private U64 tx1523ToMaxPackets;
        private boolean txMulticastPacketsSet;
        private U64 txMulticastPackets;
        private boolean rxBroadcastPacketsSet;
        private U64 rxBroadcastPackets;
        private boolean txBroadcastPacketsSet;
        private U64 txBroadcastPackets;
        private boolean rxUndersizedErrorsSet;
        private U64 rxUndersizedErrors;
        private boolean rxOversizeErrorsSet;
        private U64 rxOversizeErrors;
        private boolean rxFragmentedErrorsSet;
        private U64 rxFragmentedErrors;
        private boolean rxJabberErrorsSet;
        private U64 rxJabberErrors;

    @Override
    public int getType() {
        return 0xffff;
    }

    @Override
    public long getExperimenter() {
        return 0xaa01L;
    }

    @Override
    public long getExpType() {
        return 0x1L;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
    }
    @Override
    public U64 getRx1To64Packets() {
        return rx1To64Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx1To64Packets(U64 rx1To64Packets) {
        this.rx1To64Packets = rx1To64Packets;
        this.rx1To64PacketsSet = true;
        return this;
    }
    @Override
    public U64 getRx65To127Packets() {
        return rx65To127Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx65To127Packets(U64 rx65To127Packets) {
        this.rx65To127Packets = rx65To127Packets;
        this.rx65To127PacketsSet = true;
        return this;
    }
    @Override
    public U64 getRx128To255Packets() {
        return rx128To255Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx128To255Packets(U64 rx128To255Packets) {
        this.rx128To255Packets = rx128To255Packets;
        this.rx128To255PacketsSet = true;
        return this;
    }
    @Override
    public U64 getRx256To511Packets() {
        return rx256To511Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx256To511Packets(U64 rx256To511Packets) {
        this.rx256To511Packets = rx256To511Packets;
        this.rx256To511PacketsSet = true;
        return this;
    }
    @Override
    public U64 getRx512To1023Packets() {
        return rx512To1023Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx512To1023Packets(U64 rx512To1023Packets) {
        this.rx512To1023Packets = rx512To1023Packets;
        this.rx512To1023PacketsSet = true;
        return this;
    }
    @Override
    public U64 getRx1024To1522Packets() {
        return rx1024To1522Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx1024To1522Packets(U64 rx1024To1522Packets) {
        this.rx1024To1522Packets = rx1024To1522Packets;
        this.rx1024To1522PacketsSet = true;
        return this;
    }
    @Override
    public U64 getRx1523ToMaxPackets() {
        return rx1523ToMaxPackets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRx1523ToMaxPackets(U64 rx1523ToMaxPackets) {
        this.rx1523ToMaxPackets = rx1523ToMaxPackets;
        this.rx1523ToMaxPacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx1To64Packets() {
        return tx1To64Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx1To64Packets(U64 tx1To64Packets) {
        this.tx1To64Packets = tx1To64Packets;
        this.tx1To64PacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx65To127Packets() {
        return tx65To127Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx65To127Packets(U64 tx65To127Packets) {
        this.tx65To127Packets = tx65To127Packets;
        this.tx65To127PacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx128To255Packets() {
        return tx128To255Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx128To255Packets(U64 tx128To255Packets) {
        this.tx128To255Packets = tx128To255Packets;
        this.tx128To255PacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx256To511Packets() {
        return tx256To511Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx256To511Packets(U64 tx256To511Packets) {
        this.tx256To511Packets = tx256To511Packets;
        this.tx256To511PacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx512To1023Packets() {
        return tx512To1023Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx512To1023Packets(U64 tx512To1023Packets) {
        this.tx512To1023Packets = tx512To1023Packets;
        this.tx512To1023PacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx1024To1522Packets() {
        return tx1024To1522Packets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx1024To1522Packets(U64 tx1024To1522Packets) {
        this.tx1024To1522Packets = tx1024To1522Packets;
        this.tx1024To1522PacketsSet = true;
        return this;
    }
    @Override
    public U64 getTx1523ToMaxPackets() {
        return tx1523ToMaxPackets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTx1523ToMaxPackets(U64 tx1523ToMaxPackets) {
        this.tx1523ToMaxPackets = tx1523ToMaxPackets;
        this.tx1523ToMaxPacketsSet = true;
        return this;
    }
    @Override
    public U64 getTxMulticastPackets() {
        return txMulticastPackets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTxMulticastPackets(U64 txMulticastPackets) {
        this.txMulticastPackets = txMulticastPackets;
        this.txMulticastPacketsSet = true;
        return this;
    }
    @Override
    public U64 getRxBroadcastPackets() {
        return rxBroadcastPackets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRxBroadcastPackets(U64 rxBroadcastPackets) {
        this.rxBroadcastPackets = rxBroadcastPackets;
        this.rxBroadcastPacketsSet = true;
        return this;
    }
    @Override
    public U64 getTxBroadcastPackets() {
        return txBroadcastPackets;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setTxBroadcastPackets(U64 txBroadcastPackets) {
        this.txBroadcastPackets = txBroadcastPackets;
        this.txBroadcastPacketsSet = true;
        return this;
    }
    @Override
    public U64 getRxUndersizedErrors() {
        return rxUndersizedErrors;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRxUndersizedErrors(U64 rxUndersizedErrors) {
        this.rxUndersizedErrors = rxUndersizedErrors;
        this.rxUndersizedErrorsSet = true;
        return this;
    }
    @Override
    public U64 getRxOversizeErrors() {
        return rxOversizeErrors;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRxOversizeErrors(U64 rxOversizeErrors) {
        this.rxOversizeErrors = rxOversizeErrors;
        this.rxOversizeErrorsSet = true;
        return this;
    }
    @Override
    public U64 getRxFragmentedErrors() {
        return rxFragmentedErrors;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRxFragmentedErrors(U64 rxFragmentedErrors) {
        this.rxFragmentedErrors = rxFragmentedErrors;
        this.rxFragmentedErrorsSet = true;
        return this;
    }
    @Override
    public U64 getRxJabberErrors() {
        return rxJabberErrors;
    }

    @Override
    public OFPortStatsPropExperimenterIntel.Builder setRxJabberErrors(U64 rxJabberErrors) {
        this.rxJabberErrors = rxJabberErrors;
        this.rxJabberErrorsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

//
        @Override
        public OFPortStatsPropExperimenterIntel build() {
            U64 rx1To64Packets = this.rx1To64PacketsSet ? this.rx1To64Packets : DEFAULT_RX_1_TO_64_PACKETS;
            if(rx1To64Packets == null)
                throw new NullPointerException("Property rx1To64Packets must not be null");
            U64 rx65To127Packets = this.rx65To127PacketsSet ? this.rx65To127Packets : DEFAULT_RX_65_TO_127_PACKETS;
            if(rx65To127Packets == null)
                throw new NullPointerException("Property rx65To127Packets must not be null");
            U64 rx128To255Packets = this.rx128To255PacketsSet ? this.rx128To255Packets : DEFAULT_RX_128_TO_255_PACKETS;
            if(rx128To255Packets == null)
                throw new NullPointerException("Property rx128To255Packets must not be null");
            U64 rx256To511Packets = this.rx256To511PacketsSet ? this.rx256To511Packets : DEFAULT_RX_256_TO_511_PACKETS;
            if(rx256To511Packets == null)
                throw new NullPointerException("Property rx256To511Packets must not be null");
            U64 rx512To1023Packets = this.rx512To1023PacketsSet ? this.rx512To1023Packets : DEFAULT_RX_512_TO_1023_PACKETS;
            if(rx512To1023Packets == null)
                throw new NullPointerException("Property rx512To1023Packets must not be null");
            U64 rx1024To1522Packets = this.rx1024To1522PacketsSet ? this.rx1024To1522Packets : DEFAULT_RX_1024_TO_1522_PACKETS;
            if(rx1024To1522Packets == null)
                throw new NullPointerException("Property rx1024To1522Packets must not be null");
            U64 rx1523ToMaxPackets = this.rx1523ToMaxPacketsSet ? this.rx1523ToMaxPackets : DEFAULT_RX_1523_TO_MAX_PACKETS;
            if(rx1523ToMaxPackets == null)
                throw new NullPointerException("Property rx1523ToMaxPackets must not be null");
            U64 tx1To64Packets = this.tx1To64PacketsSet ? this.tx1To64Packets : DEFAULT_TX_1_TO_64_PACKETS;
            if(tx1To64Packets == null)
                throw new NullPointerException("Property tx1To64Packets must not be null");
            U64 tx65To127Packets = this.tx65To127PacketsSet ? this.tx65To127Packets : DEFAULT_TX_65_TO_127_PACKETS;
            if(tx65To127Packets == null)
                throw new NullPointerException("Property tx65To127Packets must not be null");
            U64 tx128To255Packets = this.tx128To255PacketsSet ? this.tx128To255Packets : DEFAULT_TX_128_TO_255_PACKETS;
            if(tx128To255Packets == null)
                throw new NullPointerException("Property tx128To255Packets must not be null");
            U64 tx256To511Packets = this.tx256To511PacketsSet ? this.tx256To511Packets : DEFAULT_TX_256_TO_511_PACKETS;
            if(tx256To511Packets == null)
                throw new NullPointerException("Property tx256To511Packets must not be null");
            U64 tx512To1023Packets = this.tx512To1023PacketsSet ? this.tx512To1023Packets : DEFAULT_TX_512_TO_1023_PACKETS;
            if(tx512To1023Packets == null)
                throw new NullPointerException("Property tx512To1023Packets must not be null");
            U64 tx1024To1522Packets = this.tx1024To1522PacketsSet ? this.tx1024To1522Packets : DEFAULT_TX_1024_TO_1522_PACKETS;
            if(tx1024To1522Packets == null)
                throw new NullPointerException("Property tx1024To1522Packets must not be null");
            U64 tx1523ToMaxPackets = this.tx1523ToMaxPacketsSet ? this.tx1523ToMaxPackets : DEFAULT_TX_1523_TO_MAX_PACKETS;
            if(tx1523ToMaxPackets == null)
                throw new NullPointerException("Property tx1523ToMaxPackets must not be null");
            U64 txMulticastPackets = this.txMulticastPacketsSet ? this.txMulticastPackets : DEFAULT_TX_MULTICAST_PACKETS;
            if(txMulticastPackets == null)
                throw new NullPointerException("Property txMulticastPackets must not be null");
            U64 rxBroadcastPackets = this.rxBroadcastPacketsSet ? this.rxBroadcastPackets : DEFAULT_RX_BROADCAST_PACKETS;
            if(rxBroadcastPackets == null)
                throw new NullPointerException("Property rxBroadcastPackets must not be null");
            U64 txBroadcastPackets = this.txBroadcastPacketsSet ? this.txBroadcastPackets : DEFAULT_TX_BROADCAST_PACKETS;
            if(txBroadcastPackets == null)
                throw new NullPointerException("Property txBroadcastPackets must not be null");
            U64 rxUndersizedErrors = this.rxUndersizedErrorsSet ? this.rxUndersizedErrors : DEFAULT_RX_UNDERSIZED_ERRORS;
            if(rxUndersizedErrors == null)
                throw new NullPointerException("Property rxUndersizedErrors must not be null");
            U64 rxOversizeErrors = this.rxOversizeErrorsSet ? this.rxOversizeErrors : DEFAULT_RX_OVERSIZE_ERRORS;
            if(rxOversizeErrors == null)
                throw new NullPointerException("Property rxOversizeErrors must not be null");
            U64 rxFragmentedErrors = this.rxFragmentedErrorsSet ? this.rxFragmentedErrors : DEFAULT_RX_FRAGMENTED_ERRORS;
            if(rxFragmentedErrors == null)
                throw new NullPointerException("Property rxFragmentedErrors must not be null");
            U64 rxJabberErrors = this.rxJabberErrorsSet ? this.rxJabberErrors : DEFAULT_RX_JABBER_ERRORS;
            if(rxJabberErrors == null)
                throw new NullPointerException("Property rxJabberErrors must not be null");


            return new OFPortStatsPropExperimenterIntelVer15(
                    rx1To64Packets,
                    rx65To127Packets,
                    rx128To255Packets,
                    rx256To511Packets,
                    rx512To1023Packets,
                    rx1024To1522Packets,
                    rx1523ToMaxPackets,
                    tx1To64Packets,
                    tx65To127Packets,
                    tx128To255Packets,
                    tx256To511Packets,
                    tx512To1023Packets,
                    tx1024To1522Packets,
                    tx1523ToMaxPackets,
                    txMulticastPackets,
                    rxBroadcastPackets,
                    txBroadcastPackets,
                    rxUndersizedErrors,
                    rxOversizeErrors,
                    rxFragmentedErrors,
                    rxJabberErrors
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFPortStatsPropExperimenterIntel> {
        @Override
        public OFPortStatsPropExperimenterIntel readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 0xffff
            short type = bb.readShort();
            if(type != (short) 0xffff)
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 184)
                throw new OFParseError("Wrong length: Expected=184(184), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // fixed value property experimenter == 0xaa01L
            int experimenter = bb.readInt();
            if(experimenter != 0xaa01)
                throw new OFParseError("Wrong experimenter: Expected=0xaa01L(0xaa01L), got="+experimenter);
            // fixed value property expType == 0x1L
            int expType = bb.readInt();
            if(expType != 0x1)
                throw new OFParseError("Wrong expType: Expected=0x1L(0x1L), got="+expType);
            // pad: 4 bytes
            bb.skipBytes(4);
            U64 rx1To64Packets = U64.ofRaw(bb.readLong());
            U64 rx65To127Packets = U64.ofRaw(bb.readLong());
            U64 rx128To255Packets = U64.ofRaw(bb.readLong());
            U64 rx256To511Packets = U64.ofRaw(bb.readLong());
            U64 rx512To1023Packets = U64.ofRaw(bb.readLong());
            U64 rx1024To1522Packets = U64.ofRaw(bb.readLong());
            U64 rx1523ToMaxPackets = U64.ofRaw(bb.readLong());
            U64 tx1To64Packets = U64.ofRaw(bb.readLong());
            U64 tx65To127Packets = U64.ofRaw(bb.readLong());
            U64 tx128To255Packets = U64.ofRaw(bb.readLong());
            U64 tx256To511Packets = U64.ofRaw(bb.readLong());
            U64 tx512To1023Packets = U64.ofRaw(bb.readLong());
            U64 tx1024To1522Packets = U64.ofRaw(bb.readLong());
            U64 tx1523ToMaxPackets = U64.ofRaw(bb.readLong());
            U64 txMulticastPackets = U64.ofRaw(bb.readLong());
            U64 rxBroadcastPackets = U64.ofRaw(bb.readLong());
            U64 txBroadcastPackets = U64.ofRaw(bb.readLong());
            U64 rxUndersizedErrors = U64.ofRaw(bb.readLong());
            U64 rxOversizeErrors = U64.ofRaw(bb.readLong());
            U64 rxFragmentedErrors = U64.ofRaw(bb.readLong());
            U64 rxJabberErrors = U64.ofRaw(bb.readLong());

            OFPortStatsPropExperimenterIntelVer15 portStatsPropExperimenterIntelVer15 = new OFPortStatsPropExperimenterIntelVer15(
                    rx1To64Packets,
                      rx65To127Packets,
                      rx128To255Packets,
                      rx256To511Packets,
                      rx512To1023Packets,
                      rx1024To1522Packets,
                      rx1523ToMaxPackets,
                      tx1To64Packets,
                      tx65To127Packets,
                      tx128To255Packets,
                      tx256To511Packets,
                      tx512To1023Packets,
                      tx1024To1522Packets,
                      tx1523ToMaxPackets,
                      txMulticastPackets,
                      rxBroadcastPackets,
                      txBroadcastPackets,
                      rxUndersizedErrors,
                      rxOversizeErrors,
                      rxFragmentedErrors,
                      rxJabberErrors
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", portStatsPropExperimenterIntelVer15);
            return portStatsPropExperimenterIntelVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFPortStatsPropExperimenterIntelVer15Funnel FUNNEL = new OFPortStatsPropExperimenterIntelVer15Funnel();
    static class OFPortStatsPropExperimenterIntelVer15Funnel implements Funnel<OFPortStatsPropExperimenterIntelVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFPortStatsPropExperimenterIntelVer15 message, PrimitiveSink sink) {
            // fixed value property type = 0xffff
            sink.putShort((short) 0xffff);
            // fixed value property length = 184
            sink.putShort((short) 0xb8);
            // fixed value property experimenter = 0xaa01L
            sink.putInt(0xaa01);
            // fixed value property expType = 0x1L
            sink.putInt(0x1);
            // skip pad (4 bytes)
            message.rx1To64Packets.putTo(sink);
            message.rx65To127Packets.putTo(sink);
            message.rx128To255Packets.putTo(sink);
            message.rx256To511Packets.putTo(sink);
            message.rx512To1023Packets.putTo(sink);
            message.rx1024To1522Packets.putTo(sink);
            message.rx1523ToMaxPackets.putTo(sink);
            message.tx1To64Packets.putTo(sink);
            message.tx65To127Packets.putTo(sink);
            message.tx128To255Packets.putTo(sink);
            message.tx256To511Packets.putTo(sink);
            message.tx512To1023Packets.putTo(sink);
            message.tx1024To1522Packets.putTo(sink);
            message.tx1523ToMaxPackets.putTo(sink);
            message.txMulticastPackets.putTo(sink);
            message.rxBroadcastPackets.putTo(sink);
            message.txBroadcastPackets.putTo(sink);
            message.rxUndersizedErrors.putTo(sink);
            message.rxOversizeErrors.putTo(sink);
            message.rxFragmentedErrors.putTo(sink);
            message.rxJabberErrors.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFPortStatsPropExperimenterIntelVer15> {
        @Override
        public void write(ByteBuf bb, OFPortStatsPropExperimenterIntelVer15 message) {
            // fixed value property type = 0xffff
            bb.writeShort((short) 0xffff);
            // fixed value property length = 184
            bb.writeShort((short) 0xb8);
            // fixed value property experimenter = 0xaa01L
            bb.writeInt(0xaa01);
            // fixed value property expType = 0x1L
            bb.writeInt(0x1);
            // pad: 4 bytes
            bb.writeZero(4);
            bb.writeLong(message.rx1To64Packets.getValue());
            bb.writeLong(message.rx65To127Packets.getValue());
            bb.writeLong(message.rx128To255Packets.getValue());
            bb.writeLong(message.rx256To511Packets.getValue());
            bb.writeLong(message.rx512To1023Packets.getValue());
            bb.writeLong(message.rx1024To1522Packets.getValue());
            bb.writeLong(message.rx1523ToMaxPackets.getValue());
            bb.writeLong(message.tx1To64Packets.getValue());
            bb.writeLong(message.tx65To127Packets.getValue());
            bb.writeLong(message.tx128To255Packets.getValue());
            bb.writeLong(message.tx256To511Packets.getValue());
            bb.writeLong(message.tx512To1023Packets.getValue());
            bb.writeLong(message.tx1024To1522Packets.getValue());
            bb.writeLong(message.tx1523ToMaxPackets.getValue());
            bb.writeLong(message.txMulticastPackets.getValue());
            bb.writeLong(message.rxBroadcastPackets.getValue());
            bb.writeLong(message.txBroadcastPackets.getValue());
            bb.writeLong(message.rxUndersizedErrors.getValue());
            bb.writeLong(message.rxOversizeErrors.getValue());
            bb.writeLong(message.rxFragmentedErrors.getValue());
            bb.writeLong(message.rxJabberErrors.getValue());


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFPortStatsPropExperimenterIntelVer15(");
        b.append("rx1To64Packets=").append(rx1To64Packets);
        b.append(", ");
        b.append("rx65To127Packets=").append(rx65To127Packets);
        b.append(", ");
        b.append("rx128To255Packets=").append(rx128To255Packets);
        b.append(", ");
        b.append("rx256To511Packets=").append(rx256To511Packets);
        b.append(", ");
        b.append("rx512To1023Packets=").append(rx512To1023Packets);
        b.append(", ");
        b.append("rx1024To1522Packets=").append(rx1024To1522Packets);
        b.append(", ");
        b.append("rx1523ToMaxPackets=").append(rx1523ToMaxPackets);
        b.append(", ");
        b.append("tx1To64Packets=").append(tx1To64Packets);
        b.append(", ");
        b.append("tx65To127Packets=").append(tx65To127Packets);
        b.append(", ");
        b.append("tx128To255Packets=").append(tx128To255Packets);
        b.append(", ");
        b.append("tx256To511Packets=").append(tx256To511Packets);
        b.append(", ");
        b.append("tx512To1023Packets=").append(tx512To1023Packets);
        b.append(", ");
        b.append("tx1024To1522Packets=").append(tx1024To1522Packets);
        b.append(", ");
        b.append("tx1523ToMaxPackets=").append(tx1523ToMaxPackets);
        b.append(", ");
        b.append("txMulticastPackets=").append(txMulticastPackets);
        b.append(", ");
        b.append("rxBroadcastPackets=").append(rxBroadcastPackets);
        b.append(", ");
        b.append("txBroadcastPackets=").append(txBroadcastPackets);
        b.append(", ");
        b.append("rxUndersizedErrors=").append(rxUndersizedErrors);
        b.append(", ");
        b.append("rxOversizeErrors=").append(rxOversizeErrors);
        b.append(", ");
        b.append("rxFragmentedErrors=").append(rxFragmentedErrors);
        b.append(", ");
        b.append("rxJabberErrors=").append(rxJabberErrors);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFPortStatsPropExperimenterIntelVer15 other = (OFPortStatsPropExperimenterIntelVer15) obj;

        if (rx1To64Packets == null) {
            if (other.rx1To64Packets != null)
                return false;
        } else if (!rx1To64Packets.equals(other.rx1To64Packets))
            return false;
        if (rx65To127Packets == null) {
            if (other.rx65To127Packets != null)
                return false;
        } else if (!rx65To127Packets.equals(other.rx65To127Packets))
            return false;
        if (rx128To255Packets == null) {
            if (other.rx128To255Packets != null)
                return false;
        } else if (!rx128To255Packets.equals(other.rx128To255Packets))
            return false;
        if (rx256To511Packets == null) {
            if (other.rx256To511Packets != null)
                return false;
        } else if (!rx256To511Packets.equals(other.rx256To511Packets))
            return false;
        if (rx512To1023Packets == null) {
            if (other.rx512To1023Packets != null)
                return false;
        } else if (!rx512To1023Packets.equals(other.rx512To1023Packets))
            return false;
        if (rx1024To1522Packets == null) {
            if (other.rx1024To1522Packets != null)
                return false;
        } else if (!rx1024To1522Packets.equals(other.rx1024To1522Packets))
            return false;
        if (rx1523ToMaxPackets == null) {
            if (other.rx1523ToMaxPackets != null)
                return false;
        } else if (!rx1523ToMaxPackets.equals(other.rx1523ToMaxPackets))
            return false;
        if (tx1To64Packets == null) {
            if (other.tx1To64Packets != null)
                return false;
        } else if (!tx1To64Packets.equals(other.tx1To64Packets))
            return false;
        if (tx65To127Packets == null) {
            if (other.tx65To127Packets != null)
                return false;
        } else if (!tx65To127Packets.equals(other.tx65To127Packets))
            return false;
        if (tx128To255Packets == null) {
            if (other.tx128To255Packets != null)
                return false;
        } else if (!tx128To255Packets.equals(other.tx128To255Packets))
            return false;
        if (tx256To511Packets == null) {
            if (other.tx256To511Packets != null)
                return false;
        } else if (!tx256To511Packets.equals(other.tx256To511Packets))
            return false;
        if (tx512To1023Packets == null) {
            if (other.tx512To1023Packets != null)
                return false;
        } else if (!tx512To1023Packets.equals(other.tx512To1023Packets))
            return false;
        if (tx1024To1522Packets == null) {
            if (other.tx1024To1522Packets != null)
                return false;
        } else if (!tx1024To1522Packets.equals(other.tx1024To1522Packets))
            return false;
        if (tx1523ToMaxPackets == null) {
            if (other.tx1523ToMaxPackets != null)
                return false;
        } else if (!tx1523ToMaxPackets.equals(other.tx1523ToMaxPackets))
            return false;
        if (txMulticastPackets == null) {
            if (other.txMulticastPackets != null)
                return false;
        } else if (!txMulticastPackets.equals(other.txMulticastPackets))
            return false;
        if (rxBroadcastPackets == null) {
            if (other.rxBroadcastPackets != null)
                return false;
        } else if (!rxBroadcastPackets.equals(other.rxBroadcastPackets))
            return false;
        if (txBroadcastPackets == null) {
            if (other.txBroadcastPackets != null)
                return false;
        } else if (!txBroadcastPackets.equals(other.txBroadcastPackets))
            return false;
        if (rxUndersizedErrors == null) {
            if (other.rxUndersizedErrors != null)
                return false;
        } else if (!rxUndersizedErrors.equals(other.rxUndersizedErrors))
            return false;
        if (rxOversizeErrors == null) {
            if (other.rxOversizeErrors != null)
                return false;
        } else if (!rxOversizeErrors.equals(other.rxOversizeErrors))
            return false;
        if (rxFragmentedErrors == null) {
            if (other.rxFragmentedErrors != null)
                return false;
        } else if (!rxFragmentedErrors.equals(other.rxFragmentedErrors))
            return false;
        if (rxJabberErrors == null) {
            if (other.rxJabberErrors != null)
                return false;
        } else if (!rxJabberErrors.equals(other.rxJabberErrors))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((rx1To64Packets == null) ? 0 : rx1To64Packets.hashCode());
        result = prime * result + ((rx65To127Packets == null) ? 0 : rx65To127Packets.hashCode());
        result = prime * result + ((rx128To255Packets == null) ? 0 : rx128To255Packets.hashCode());
        result = prime * result + ((rx256To511Packets == null) ? 0 : rx256To511Packets.hashCode());
        result = prime * result + ((rx512To1023Packets == null) ? 0 : rx512To1023Packets.hashCode());
        result = prime * result + ((rx1024To1522Packets == null) ? 0 : rx1024To1522Packets.hashCode());
        result = prime * result + ((rx1523ToMaxPackets == null) ? 0 : rx1523ToMaxPackets.hashCode());
        result = prime * result + ((tx1To64Packets == null) ? 0 : tx1To64Packets.hashCode());
        result = prime * result + ((tx65To127Packets == null) ? 0 : tx65To127Packets.hashCode());
        result = prime * result + ((tx128To255Packets == null) ? 0 : tx128To255Packets.hashCode());
        result = prime * result + ((tx256To511Packets == null) ? 0 : tx256To511Packets.hashCode());
        result = prime * result + ((tx512To1023Packets == null) ? 0 : tx512To1023Packets.hashCode());
        result = prime * result + ((tx1024To1522Packets == null) ? 0 : tx1024To1522Packets.hashCode());
        result = prime * result + ((tx1523ToMaxPackets == null) ? 0 : tx1523ToMaxPackets.hashCode());
        result = prime * result + ((txMulticastPackets == null) ? 0 : txMulticastPackets.hashCode());
        result = prime * result + ((rxBroadcastPackets == null) ? 0 : rxBroadcastPackets.hashCode());
        result = prime * result + ((txBroadcastPackets == null) ? 0 : txBroadcastPackets.hashCode());
        result = prime * result + ((rxUndersizedErrors == null) ? 0 : rxUndersizedErrors.hashCode());
        result = prime * result + ((rxOversizeErrors == null) ? 0 : rxOversizeErrors.hashCode());
        result = prime * result + ((rxFragmentedErrors == null) ? 0 : rxFragmentedErrors.hashCode());
        result = prime * result + ((rxJabberErrors == null) ? 0 : rxJabberErrors.hashCode());
        return result;
    }

}
