/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowAdd;
import org.projectfloodlight.openflow.protocol.OFFlowModFlags;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowAddVer10;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;

public class OFFlowAddVer10Test {
    OFFactory factory;
    static final byte[] FLOW_ADD_SERIALIZED = new byte[]{1, 14, 0, 112, 18, 52, 86, 120, 0, 48, 0, -30, 0, 3, 1, 35, 69, 103, -119, -85, -51, -17, 1, 35, 69, 103, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, -64, -88, 3, 127, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 8, -1, -5, 0, 0, -1, -1, 0, 16, 0, 0, 35, 32, 0, 18, 0, 0, 0, 0, 0, 0, -1, -1, 0, 16, 0, 92, 22, -57, 0, 0, 0, 2, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer10.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFFlowAdd.Builder builder = this.factory.buildFlowAdd();
        builder.setXid(305419896L).setMatch(this.factory.buildMatch().setExact(MatchField.IN_PORT, (OFValueType)OFPort.of((int)3)).setExact(MatchField.ETH_TYPE, (OFValueType)EthType.IPv4).setExact(MatchField.IPV4_SRC, (OFValueType)IPv4Address.of((int)-1062730881)).setExact(MatchField.IPV4_DST, (OFValueType)IPv4Address.of((int)-1)).setExact(MatchField.ETH_SRC, (OFValueType)MacAddress.of((String)"01:23:45:67:89:ab")).setExact(MatchField.ETH_DST, (OFValueType)MacAddress.of((String)"cd:ef:01:23:45:67")).build()).setIdleTimeout(5).setFlags((Set)Sets.immutableEnumSet((Enum)OFFlowModFlags.CHECK_OVERLAP, (Enum[])new OFFlowModFlags[0])).setBufferId(OFBufferId.of((int)0)).setOutPort(OFPort.of((int)0)).setActions((List)ImmutableList.of((Object)this.factory.actions().output(OFPort.FLOOD, 0), (Object)this.factory.actions().niciraDecTtl(), (Object)this.factory.actions().bsnSetTunnelDst(0L)));
        OFFlowAdd flowAdd = builder.build();
        ByteBuf bb = Unpooled.buffer();
        flowAdd.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_ADD_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFFlowAdd.Builder builder = this.factory.buildFlowAdd();
        builder.setXid(305419896L).setMatch(this.factory.buildMatch().setExact(MatchField.IN_PORT, (OFValueType)OFPort.of((int)3)).setExact(MatchField.ETH_TYPE, (OFValueType)EthType.IPv4).setExact(MatchField.IPV4_SRC, (OFValueType)IPv4Address.of((int)-1062730881)).setExact(MatchField.IPV4_DST, (OFValueType)IPv4Address.of((int)-1)).setExact(MatchField.ETH_SRC, (OFValueType)MacAddress.of((String)"01:23:45:67:89:ab")).setExact(MatchField.ETH_DST, (OFValueType)MacAddress.of((String)"cd:ef:01:23:45:67")).build()).setIdleTimeout(5).setFlags((Set)Sets.immutableEnumSet((Enum)OFFlowModFlags.CHECK_OVERLAP, (Enum[])new OFFlowModFlags[0])).setBufferId(OFBufferId.of((int)0)).setOutPort(OFPort.of((int)0)).setActions((List)ImmutableList.of((Object)this.factory.actions().output(OFPort.FLOOD, 0), (Object)this.factory.actions().niciraDecTtl(), (Object)this.factory.actions().bsnSetTunnelDst(0L)));
        OFFlowAdd flowAddBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_ADD_SERIALIZED);
        OFFlowAdd flowAddRead = OFFlowAddVer10.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_ADD_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)flowAddBuilt, (Object)flowAddRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_ADD_SERIALIZED);
        OFFlowAdd flowAdd = OFFlowAddVer10.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_ADD_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        flowAdd.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_ADD_SERIALIZED));
    }
}

