/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPortMod;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPortModVer10;

public class OFPortModVer10Test {
    OFFactory factory;
    static final byte[] PORT_MOD_SERIALIZED = new byte[]{1, 15, 0, 32, 0, 0, 0, 2, -1, -3, 1, 2, 3, 4, 5, 6, -128, 0, 0, 111, -128, 0, 0, 17, -54, -2, 103, -119, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer10.INSTANCE;
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_MOD_SERIALIZED);
        OFPortMod portMod = OFPortModVer10.READER.readFrom(input);
        Assert.assertEquals((long)PORT_MOD_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        portMod.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_MOD_SERIALIZED));
    }
}

