/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetField;
import org.projectfloodlight.openflow.protocol.action.OFActions;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxms;
import org.projectfloodlight.openflow.protocol.ver13.OFActionSetFieldVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFActionsVer13;
import org.projectfloodlight.openflow.types.LagId;

public class OFActionSetFieldVer13BsnLagIdTest {
    OFActions factory;
    static final byte[] ACTION_SET_FIELD_SERIALIZED = new byte[]{0, 25, 0, 16, 0, 3, 2, 4, 18, 52, 86, 120, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFActionsVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFActionSetField.Builder builder = this.factory.buildSetField();
        OFOxms oxms = OFFactories.getFactory((OFVersion)OFVersion.OF_13).oxms();
        builder.setField((OFOxm)oxms.bsnLagId(LagId.of((int)305419896)));
        OFActionSetField actionSetField = builder.build();
        ByteBuf bb = Unpooled.buffer();
        actionSetField.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ACTION_SET_FIELD_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFActionSetField.Builder builder = this.factory.buildSetField();
        OFOxms oxms = OFFactories.getFactory((OFVersion)OFVersion.OF_13).oxms();
        builder.setField((OFOxm)oxms.bsnLagId(LagId.of((int)305419896)));
        OFActionSetField actionSetFieldBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])ACTION_SET_FIELD_SERIALIZED);
        OFActionSetField actionSetFieldRead = OFActionSetFieldVer13.READER.readFrom(input);
        Assert.assertEquals((long)ACTION_SET_FIELD_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)actionSetFieldBuilt, (Object)actionSetFieldRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])ACTION_SET_FIELD_SERIALIZED);
        OFActionSetField actionSetField = OFActionSetFieldVer13.READER.readFrom(input);
        Assert.assertEquals((long)ACTION_SET_FIELD_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        actionSetField.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ACTION_SET_FIELD_SERIALIZED));
    }
}

