/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFEchoRequest;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFEchoRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;

public class OFEchoRequestVer13Test {
    OFFactory factory;
    static final byte[] ECHO_REQUEST_SERIALIZED = new byte[]{4, 2, 0, 11, 18, 52, 86, 120, 97, 98, 99};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])ECHO_REQUEST_SERIALIZED);
        OFEchoRequest echoRequest = OFEchoRequestVer13.READER.readFrom(input);
        Assert.assertEquals((long)ECHO_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        echoRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ECHO_REQUEST_SERIALIZED));
    }
}

