/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMatchV3;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFMatchV3Ver13;
import org.projectfloodlight.openflow.types.CircuitSignalID;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFMetadata;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.OduSignalID;
import org.projectfloodlight.openflow.types.TransportPort;
import org.projectfloodlight.openflow.types.U8;

public class OFMatchV3Ver13Test {
    OFFactory factory;
    static final byte[] MATCH_V3_SERIALIZED = new byte[]{0, 1, 0, 116, -128, 0, 5, 16, -2, -36, -70, -104, 18, 20, 18, 16, -1, -1, -1, -1, 18, 52, 86, 120, -128, 0, 8, 6, 1, 2, 3, 4, 5, 6, -128, 0, 32, 2, 0, 53, -128, 0, 54, 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, -1, -1, 6, 16, -1, 0, 0, 7, 85, 85, 0, 80, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, -1, -1, 4, 1, -1, 0, 0, 7, 8, -1, -1, 10, 6, -1, 0, 0, 7, 2, 1, 0, 4, 0, 1, -1, -1, 8, 1, -1, 0, 0, 7, 22, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFMatchV3.Builder builder = this.factory.buildMatchV3();
        builder.setMasked(MatchField.METADATA, (OFValueType)OFMetadata.ofRaw((long)-81985530898410992L), (OFValueType)OFMetadata.ofRaw((long)-3989547400L)).setExact(MatchField.ETH_SRC, (OFValueType)MacAddress.of((byte[])new byte[]{1, 2, 3, 4, 5, 6})).setExact(MatchField.UDP_DST, (OFValueType)TransportPort.of((int)53)).setExact(MatchField.IPV6_DST, (OFValueType)IPv6Address.of((byte[])new byte[]{18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18})).setExact(MatchField.EXP_ODU_SIG_ID, (OFValueType)new OduSignalID(21845, 80, new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1})).setExact(MatchField.EXP_ODU_SIGTYPE, (OFValueType)U8.of((short)8)).setExact(MatchField.EXP_OCH_SIG_ID, (OFValueType)new CircuitSignalID(2, 1, 4, 1)).setExact(MatchField.EXP_OCH_SIGTYPE, (OFValueType)U8.of((short)22));
        OFMatchV3 matchV3 = builder.build();
        ByteBuf bb = Unpooled.buffer();
        matchV3.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)MATCH_V3_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFMatchV3.Builder builder = this.factory.buildMatchV3();
        builder.setMasked(MatchField.METADATA, (OFValueType)OFMetadata.ofRaw((long)-81985530898410992L), (OFValueType)OFMetadata.ofRaw((long)-3989547400L)).setExact(MatchField.ETH_SRC, (OFValueType)MacAddress.of((byte[])new byte[]{1, 2, 3, 4, 5, 6})).setExact(MatchField.UDP_DST, (OFValueType)TransportPort.of((int)53)).setExact(MatchField.IPV6_DST, (OFValueType)IPv6Address.of((byte[])new byte[]{18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18})).setExact(MatchField.EXP_ODU_SIG_ID, (OFValueType)new OduSignalID(21845, 80, new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1})).setExact(MatchField.EXP_ODU_SIGTYPE, (OFValueType)U8.of((short)8)).setExact(MatchField.EXP_OCH_SIG_ID, (OFValueType)new CircuitSignalID(2, 1, 4, 1)).setExact(MatchField.EXP_OCH_SIGTYPE, (OFValueType)U8.of((short)22));
        OFMatchV3 matchV3Built = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])MATCH_V3_SERIALIZED);
        OFMatchV3 matchV3Read = OFMatchV3Ver13.READER.readFrom(input);
        Assert.assertEquals((long)MATCH_V3_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)matchV3Built, (Object)matchV3Read);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])MATCH_V3_SERIALIZED);
        OFMatchV3 matchV3 = OFMatchV3Ver13.READER.readFrom(input);
        Assert.assertEquals((long)MATCH_V3_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        matchV3.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)MATCH_V3_SERIALIZED));
    }
}

