/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.protocol.action.OFActions;
import org.projectfloodlight.openflow.protocol.ver15.OFActionOutputVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFActionsVer15;
import org.projectfloodlight.openflow.types.OFPort;

public class OFActionOutputVer15Test {
    OFActions factory;
    static final byte[] ACTION_OUTPUT_SERIALIZED = new byte[]{0, 0, 0, 16, 0, 0, 0, 50, -1, -1, 0, 0, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFActionsVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFActionOutput.Builder builder = this.factory.buildOutput();
        builder.setPort(OFPort.of((int)50)).setMaxLen(65535);
        OFActionOutput actionOutput = builder.build();
        ByteBuf bb = Unpooled.buffer();
        actionOutput.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ACTION_OUTPUT_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFActionOutput.Builder builder = this.factory.buildOutput();
        builder.setPort(OFPort.of((int)50)).setMaxLen(65535);
        OFActionOutput actionOutputBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])ACTION_OUTPUT_SERIALIZED);
        OFActionOutput actionOutputRead = OFActionOutputVer15.READER.readFrom(input);
        Assert.assertEquals((long)ACTION_OUTPUT_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)actionOutputBuilt, (Object)actionOutputRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])ACTION_OUTPUT_SERIALIZED);
        OFActionOutput actionOutput = OFActionOutputVer15.READER.readFrom(input);
        Assert.assertEquals((long)ACTION_OUTPUT_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        actionOutput.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ACTION_OUTPUT_SERIALIZED));
    }
}

