/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFAsyncGetRequest;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver15.OFAsyncGetRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;

public class OFAsyncGetRequestVer15Test {
    OFFactory factory;
    static final byte[] ASYNC_GET_REQUEST_SERIALIZED = new byte[]{6, 26, 0, 8, 18, 52, 86, 120};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFAsyncGetRequest.Builder builder = this.factory.buildAsyncGetRequest();
        builder.setXid(305419896L).build();
        OFAsyncGetRequest asyncGetRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        asyncGetRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ASYNC_GET_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFAsyncGetRequest.Builder builder = this.factory.buildAsyncGetRequest();
        builder.setXid(305419896L).build();
        OFAsyncGetRequest asyncGetRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])ASYNC_GET_REQUEST_SERIALIZED);
        OFAsyncGetRequest asyncGetRequestRead = OFAsyncGetRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)ASYNC_GET_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)asyncGetRequestBuilt, (Object)asyncGetRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])ASYNC_GET_REQUEST_SERIALIZED);
        OFAsyncGetRequest asyncGetRequest = OFAsyncGetRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)ASYNC_GET_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        asyncGetRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ASYNC_GET_REQUEST_SERIALIZED));
    }
}

