/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBarrierReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver15.OFBarrierReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;

public class OFBarrierReplyVer15Test {
    OFFactory factory;
    static final byte[] BARRIER_REPLY_SERIALIZED = new byte[]{6, 21, 0, 8, 18, 52, 86, 120};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBarrierReply.Builder builder = this.factory.buildBarrierReply();
        builder.setXid(305419896L).build();
        OFBarrierReply barrierReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        barrierReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BARRIER_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBarrierReply.Builder builder = this.factory.buildBarrierReply();
        builder.setXid(305419896L).build();
        OFBarrierReply barrierReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])BARRIER_REPLY_SERIALIZED);
        OFBarrierReply barrierReplyRead = OFBarrierReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)BARRIER_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)barrierReplyBuilt, (Object)barrierReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])BARRIER_REPLY_SERIALIZED);
        OFBarrierReply barrierReply = OFBarrierReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)BARRIER_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        barrierReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BARRIER_REPLY_SERIALIZED));
    }
}

