/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFControllerStatusStatsRequest;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerStatusStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;

public class OFControllerStatusStatsRequestVer15Test {
    OFFactory factory;
    static final byte[] CONTROLLER_STATUS_STATS_REQUEST_SERIALIZED = new byte[]{6, 18, 0, 16, 18, 52, 86, 120, 0, 18, 0, 1, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFControllerStatusStatsRequest.Builder builder = this.factory.buildControllerStatusStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).build();
        OFControllerStatusStatsRequest controllerStatusStatsRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        controllerStatusStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)CONTROLLER_STATUS_STATS_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFControllerStatusStatsRequest.Builder builder = this.factory.buildControllerStatusStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).build();
        OFControllerStatusStatsRequest controllerStatusStatsRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])CONTROLLER_STATUS_STATS_REQUEST_SERIALIZED);
        OFControllerStatusStatsRequest controllerStatusStatsRequestRead = OFControllerStatusStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)CONTROLLER_STATUS_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)controllerStatusStatsRequestBuilt, (Object)controllerStatusStatsRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])CONTROLLER_STATUS_STATS_REQUEST_SERIALIZED);
        OFControllerStatusStatsRequest controllerStatusStatsRequest = OFControllerStatusStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)CONTROLLER_STATUS_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        controllerStatusStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)CONTROLLER_STATUS_STATS_REQUEST_SERIALIZED));
    }
}

