/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFCapabilities;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFeaturesReply;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFeaturesReplyVer15;
import org.projectfloodlight.openflow.types.DatapathId;
import org.projectfloodlight.openflow.types.OFAuxId;

public class OFFeaturesReplyVer15Test {
    OFFactory factory;
    static final byte[] FEATURES_REPLY_SERIALIZED = new byte[]{6, 6, 0, 32, 18, 52, 86, 120, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 64, -56, 5, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFFeaturesReply.Builder builder = this.factory.buildFeaturesReply();
        builder.setXid(305419896L).setDatapathId(DatapathId.of((byte[])new byte[]{16, 16, 16, 16, 16, 16, 16, 16})).setNBuffers(64L).setNTables((short)200).setAuxiliaryId(OFAuxId.of((int)5)).setCapabilities((Set)Sets.immutableEnumSet((Enum)OFCapabilities.FLOW_STATS, (Enum[])new OFCapabilities[]{OFCapabilities.PORT_BLOCKED})).setReserved(0L).build();
        OFFeaturesReply featuresReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        featuresReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FEATURES_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFFeaturesReply.Builder builder = this.factory.buildFeaturesReply();
        builder.setXid(305419896L).setDatapathId(DatapathId.of((byte[])new byte[]{16, 16, 16, 16, 16, 16, 16, 16})).setNBuffers(64L).setNTables((short)200).setAuxiliaryId(OFAuxId.of((int)5)).setCapabilities((Set)Sets.immutableEnumSet((Enum)OFCapabilities.FLOW_STATS, (Enum[])new OFCapabilities[]{OFCapabilities.PORT_BLOCKED})).setReserved(0L).build();
        OFFeaturesReply featuresReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])FEATURES_REPLY_SERIALIZED);
        OFFeaturesReply featuresReplyRead = OFFeaturesReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)FEATURES_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)featuresReplyBuilt, (Object)featuresReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])FEATURES_REPLY_SERIALIZED);
        OFFeaturesReply featuresReply = OFFeaturesReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)FEATURES_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        featuresReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FEATURES_REPLY_SERIALIZED));
    }
}

