/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFeaturesRequest;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFeaturesRequestVer15;

public class OFFeaturesRequestVer15Test {
    OFFactory factory;
    static final byte[] FEATURES_REQUEST_SERIALIZED = new byte[]{6, 5, 0, 8, 18, 52, 86, 120};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFFeaturesRequest.Builder builder = this.factory.buildFeaturesRequest();
        builder.setXid(305419896L).build();
        OFFeaturesRequest featuresRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        featuresRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FEATURES_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFFeaturesRequest.Builder builder = this.factory.buildFeaturesRequest();
        builder.setXid(305419896L).build();
        OFFeaturesRequest featuresRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])FEATURES_REQUEST_SERIALIZED);
        OFFeaturesRequest featuresRequestRead = OFFeaturesRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)FEATURES_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)featuresRequestBuilt, (Object)featuresRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])FEATURES_REQUEST_SERIALIZED);
        OFFeaturesRequest featuresRequest = OFFeaturesRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)FEATURES_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        featuresRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FEATURES_REQUEST_SERIALIZED));
    }
}

