/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowModFlags;
import org.projectfloodlight.openflow.protocol.OFFlowStatsReply;
import org.projectfloodlight.openflow.protocol.OFOxsList;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxs.OFOxs;
import org.projectfloodlight.openflow.protocol.stat.Stat;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowStatsReplyVer15;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;

public class OFFlowStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] FLOW_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 104, 18, 52, 86, 120, 0, 1, 0, 1, 0, 0, 0, 0, 0, 88, 0, 0, 1, 0, 0, 1, 0, 16, 0, 96, 0, 1, 0, 1, -2, -36, -70, -104, 118, 84, 50, 16, 0, 1, 0, 16, -128, 0, 1, 8, 0, 0, 0, 4, 0, 0, 0, 5, 0, 0, 0, 28, -128, 2, 0, 8, 0, 0, 0, 0, 0, 0, 0, 4, -128, 2, 2, 8, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 1, 0, 8, 4, 0, 0, 0, 0, 1, 0, 8, 7, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFFlowStatsReply.Builder builder = this.factory.buildFlowStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildFlowStatsEntry().setTableId(TableId.of((int)1)).setPriority(1).setIdleTimeout(16).setHardTimeout(96).setFlags((Set)ImmutableSet.of((Object)OFFlowModFlags.SEND_FLOW_REM)).setImportance(1).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).build()).setStats((Stat)this.factory.buildStatV6().setOxsFields(OFOxsList.of((OFOxs[])new OFOxs[]{this.factory.oxss().buildDuration().setValue(U64.of((long)4L)).build(), this.factory.oxss().buildIdleTime().setValue(U64.of((long)6L)).build()})).build()).setInstructions((List)ImmutableList.of((Object)this.factory.instructions().gotoTable(TableId.of((int)4)), (Object)this.factory.instructions().gotoTable(TableId.of((int)7)))).build())).build();
        OFFlowStatsReply flowStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        flowStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFFlowStatsReply.Builder builder = this.factory.buildFlowStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildFlowStatsEntry().setTableId(TableId.of((int)1)).setPriority(1).setIdleTimeout(16).setHardTimeout(96).setFlags((Set)ImmutableSet.of((Object)OFFlowModFlags.SEND_FLOW_REM)).setImportance(1).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).build()).setStats((Stat)this.factory.buildStatV6().setOxsFields(OFOxsList.of((OFOxs[])new OFOxs[]{this.factory.oxss().buildDuration().setValue(U64.of((long)4L)).build(), this.factory.oxss().buildIdleTime().setValue(U64.of((long)6L)).build()})).build()).setInstructions((List)ImmutableList.of((Object)this.factory.instructions().gotoTable(TableId.of((int)4)), (Object)this.factory.instructions().gotoTable(TableId.of((int)7)))).build())).build();
        OFFlowStatsReply flowStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_STATS_REPLY_SERIALIZED);
        OFFlowStatsReply flowStatsReplyRead = OFFlowStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)flowStatsReplyBuilt, (Object)flowStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_STATS_REPLY_SERIALIZED);
        OFFlowStatsReply flowStatsReply = OFFlowStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        flowStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_STATS_REPLY_SERIALIZED));
    }
}

