/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFGetConfigRequest;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGetConfigRequestVer15;

public class OFGetConfigRequestVer15Test {
    OFFactory factory;
    static final byte[] GET_CONFIG_REQUEST_SERIALIZED = new byte[]{6, 7, 0, 8, 18, 52, 86, 120};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFGetConfigRequest.Builder builder = this.factory.buildGetConfigRequest();
        builder.setXid(305419896L).build();
        OFGetConfigRequest getConfigRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        getConfigRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GET_CONFIG_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFGetConfigRequest.Builder builder = this.factory.buildGetConfigRequest();
        builder.setXid(305419896L).build();
        OFGetConfigRequest getConfigRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])GET_CONFIG_REQUEST_SERIALIZED);
        OFGetConfigRequest getConfigRequestRead = OFGetConfigRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)GET_CONFIG_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)getConfigRequestBuilt, (Object)getConfigRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])GET_CONFIG_REQUEST_SERIALIZED);
        OFGetConfigRequest getConfigRequest = OFGetConfigRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)GET_CONFIG_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        getConfigRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GET_CONFIG_REQUEST_SERIALIZED));
    }
}

