/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFGroupBucket;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupDescStatsReplyVer15;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;

public class OFGroupDescStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] GROUP_DESC_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 64, 18, 52, 86, 120, 0, 7, 0, 1, 0, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 1, 0, 32, 0, 0, 0, 0, 0, 0, 0, 32, 0, 24, -1, -1, -1, -3, 0, 0, 0, 16, 0, 0, 0, 1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 22, 0, 8, 0, 0, 0, 1};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFGroupDescStatsReply.Builder builder = this.factory.buildGroupDescStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildGroupDescStatsEntry().setGroupType(OFGroupType.ALL).setGroup(OFGroup.of((int)1)).setBuckets((List)ImmutableList.of((Object)this.factory.buildBucket().setBucketId(OFGroupBucket.BUCKET_FIRST).setActions((List)ImmutableList.of((Object)this.factory.actions().output(OFPort.of((int)1), 3), (Object)this.factory.actions().group(OFGroup.of((int)1)))).build())).build()));
        OFGroupDescStatsReply groupDescStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        groupDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_DESC_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFGroupDescStatsReply.Builder builder = this.factory.buildGroupDescStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildGroupDescStatsEntry().setGroupType(OFGroupType.ALL).setGroup(OFGroup.of((int)1)).setBuckets((List)ImmutableList.of((Object)this.factory.buildBucket().setBucketId(OFGroupBucket.BUCKET_FIRST).setActions((List)ImmutableList.of((Object)this.factory.actions().output(OFPort.of((int)1), 3), (Object)this.factory.actions().group(OFGroup.of((int)1)))).build())).build()));
        OFGroupDescStatsReply groupDescStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_DESC_STATS_REPLY_SERIALIZED);
        OFGroupDescStatsReply groupDescStatsReplyRead = OFGroupDescStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)groupDescStatsReplyBuilt, (Object)groupDescStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_DESC_STATS_REPLY_SERIALIZED);
        OFGroupDescStatsReply groupDescStatsReply = OFGroupDescStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        groupDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_DESC_STATS_REPLY_SERIALIZED));
    }
}

