/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFGroupFeaturesStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupFeaturesStatsRequestVer15;

public class OFGroupFeaturesStatsRequestVer15Test {
    OFFactory factory;
    static final byte[] GROUP_FEATURES_STATS_REQUEST_SERIALIZED = new byte[]{6, 18, 0, 16, 18, 52, 86, 120, 0, 8, 0, 1, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFGroupFeaturesStatsRequest.Builder builder = this.factory.buildGroupFeaturesStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).build();
        OFGroupFeaturesStatsRequest groupFeaturesStatsRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        groupFeaturesStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_FEATURES_STATS_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFGroupFeaturesStatsRequest.Builder builder = this.factory.buildGroupFeaturesStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).build();
        OFGroupFeaturesStatsRequest groupFeaturesStatsRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_FEATURES_STATS_REQUEST_SERIALIZED);
        OFGroupFeaturesStatsRequest groupFeaturesStatsRequestRead = OFGroupFeaturesStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_FEATURES_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)groupFeaturesStatsRequestBuilt, (Object)groupFeaturesStatsRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_FEATURES_STATS_REQUEST_SERIALIZED);
        OFGroupFeaturesStatsRequest groupFeaturesStatsRequest = OFGroupFeaturesStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_FEATURES_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        groupFeaturesStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_FEATURES_STATS_REQUEST_SERIALIZED));
    }
}

