/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFHello;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFHelloVer15;
import org.projectfloodlight.openflow.types.U32;

public class OFHelloVer15Test {
    OFFactory factory;
    static final byte[] HELLO_SERIALIZED = new byte[]{6, 0, 0, 32, 18, 52, 86, 120, 0, 1, 0, 12, 0, 0, 0, 1, 0, 0, 0, 2, 0, 1, 0, 12, 0, 0, 0, 3, 0, 0, 0, 4};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFHello.Builder builder = this.factory.buildHello();
        builder.setXid(305419896L).setElements((List)ImmutableList.of((Object)this.factory.buildHelloElemVersionbitmap().setBitmaps((List)ImmutableList.of((Object)U32.of((long)1L), (Object)U32.of((long)2L))).build(), (Object)this.factory.buildHelloElemVersionbitmap().setBitmaps((List)ImmutableList.of((Object)U32.of((long)3L), (Object)U32.of((long)4L))).build())).build();
        OFHello hello = builder.build();
        ByteBuf bb = Unpooled.buffer();
        hello.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)HELLO_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFHello.Builder builder = this.factory.buildHello();
        builder.setXid(305419896L).setElements((List)ImmutableList.of((Object)this.factory.buildHelloElemVersionbitmap().setBitmaps((List)ImmutableList.of((Object)U32.of((long)1L), (Object)U32.of((long)2L))).build(), (Object)this.factory.buildHelloElemVersionbitmap().setBitmaps((List)ImmutableList.of((Object)U32.of((long)3L), (Object)U32.of((long)4L))).build())).build();
        OFHello helloBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])HELLO_SERIALIZED);
        OFHello helloRead = OFHelloVer15.READER.readFrom(input);
        Assert.assertEquals((long)HELLO_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)helloBuilt, (Object)helloRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])HELLO_SERIALIZED);
        OFHello hello = OFHelloVer15.READER.readFrom(input);
        Assert.assertEquals((long)HELLO_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        hello.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)HELLO_SERIALIZED));
    }
}

