/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFOxsList;
import org.projectfloodlight.openflow.protocol.OFStatTriggerFlags;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionStatTrigger;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructions;
import org.projectfloodlight.openflow.protocol.oxs.OFOxs;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionStatTriggerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionsVer15;
import org.projectfloodlight.openflow.types.U64;

public class OFInstructionStatTriggerVer15Test {
    OFInstructions factory;
    static final byte[] INSTRUCTION_STAT_TRIGGER_SERIALIZED = new byte[]{0, 7, 0, 32, 0, 0, 0, 1, -128, 2, 0, 8, 0, 0, 0, 0, 0, 0, 0, 4, -128, 2, 2, 8, 0, 0, 0, 0, 0, 0, 0, 6};

    @Before
    public void setup() {
        this.factory = OFInstructionsVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFInstructionStatTrigger.Builder builder = this.factory.buildStatTrigger();
        builder.setFlags((Set)ImmutableSet.of((Object)OFStatTriggerFlags.PERIODIC)).setThresholds(OFOxsList.of((OFOxs[])new OFOxs[]{OFFactories.getFactory((OFVersion)OFVersion.OF_15).oxss().buildDuration().setValue(U64.of((long)4L)).build(), OFFactories.getFactory((OFVersion)OFVersion.OF_15).oxss().buildIdleTime().setValue(U64.of((long)6L)).build()}));
        OFInstructionStatTrigger instructionStatTrigger = builder.build();
        ByteBuf bb = Unpooled.buffer();
        instructionStatTrigger.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_STAT_TRIGGER_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFInstructionStatTrigger.Builder builder = this.factory.buildStatTrigger();
        builder.setFlags((Set)ImmutableSet.of((Object)OFStatTriggerFlags.PERIODIC)).setThresholds(OFOxsList.of((OFOxs[])new OFOxs[]{OFFactories.getFactory((OFVersion)OFVersion.OF_15).oxss().buildDuration().setValue(U64.of((long)4L)).build(), OFFactories.getFactory((OFVersion)OFVersion.OF_15).oxss().buildIdleTime().setValue(U64.of((long)6L)).build()}));
        OFInstructionStatTrigger instructionStatTriggerBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])INSTRUCTION_STAT_TRIGGER_SERIALIZED);
        OFInstructionStatTrigger instructionStatTriggerRead = OFInstructionStatTriggerVer15.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_STAT_TRIGGER_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)instructionStatTriggerBuilt, (Object)instructionStatTriggerRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])INSTRUCTION_STAT_TRIGGER_SERIALIZED);
        OFInstructionStatTrigger instructionStatTrigger = OFInstructionStatTriggerVer15.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_STAT_TRIGGER_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        instructionStatTrigger.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_STAT_TRIGGER_SERIALIZED));
    }
}

