/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPortDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescStatsRequestVer15;
import org.projectfloodlight.openflow.types.OFPort;

public class OFPortDescStatsRequestVer15Test {
    OFFactory factory;
    static final byte[] PORT_DESC_STATS_REQUEST_SERIALIZED = new byte[]{6, 18, 0, 24, 18, 52, 86, 120, 0, 13, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFPortDescStatsRequest.Builder builder = this.factory.buildPortDescStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setPortNo(OFPort.of((int)1)).build();
        OFPortDescStatsRequest portDescStatsRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        portDescStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_DESC_STATS_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFPortDescStatsRequest.Builder builder = this.factory.buildPortDescStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setPortNo(OFPort.of((int)1)).build();
        OFPortDescStatsRequest portDescStatsRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_DESC_STATS_REQUEST_SERIALIZED);
        OFPortDescStatsRequest portDescStatsRequestRead = OFPortDescStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)PORT_DESC_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)portDescStatsRequestBuilt, (Object)portDescStatsRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_DESC_STATS_REQUEST_SERIALIZED);
        OFPortDescStatsRequest portDescStatsRequest = OFPortDescStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)PORT_DESC_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        portDescStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_DESC_STATS_REQUEST_SERIALIZED));
    }
}

