/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPortStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortStatsRequestVer15;
import org.projectfloodlight.openflow.types.OFPort;

public class OFPortStatsRequestVer15Test {
    OFFactory factory;
    static final byte[] PORT_STATS_REQUEST_SERIALIZED = new byte[]{6, 18, 0, 24, 18, 52, 86, 120, 0, 4, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFPortStatsRequest.Builder builder = this.factory.buildPortStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setPortNo(OFPort.of((int)1)).build();
        OFPortStatsRequest portStatsRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        portStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_STATS_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFPortStatsRequest.Builder builder = this.factory.buildPortStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setPortNo(OFPort.of((int)1)).build();
        OFPortStatsRequest portStatsRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_STATS_REQUEST_SERIALIZED);
        OFPortStatsRequest portStatsRequestRead = OFPortStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)PORT_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)portStatsRequestBuilt, (Object)portStatsRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_STATS_REQUEST_SERIALIZED);
        OFPortStatsRequest portStatsRequest = OFPortStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)PORT_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        portStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_STATS_REQUEST_SERIALIZED));
    }
}

