/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFQueueDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFQueueDescStatsRequestVer15;
import org.projectfloodlight.openflow.types.OFPort;

public class OFQueueDescStatsRequestVer15Test {
    OFFactory factory;
    static final byte[] QUEUE_DESC_STATS_REQUEST_SERIALIZED = new byte[]{6, 18, 0, 24, 18, 52, 86, 120, 0, 15, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFQueueDescStatsRequest.Builder builder = this.factory.buildQueueDescStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setPortNo(OFPort.of((int)1)).setQueueId(1L).build();
        OFQueueDescStatsRequest queueDescStatsRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        queueDescStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)QUEUE_DESC_STATS_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFQueueDescStatsRequest.Builder builder = this.factory.buildQueueDescStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setPortNo(OFPort.of((int)1)).setQueueId(1L).build();
        OFQueueDescStatsRequest queueDescStatsRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])QUEUE_DESC_STATS_REQUEST_SERIALIZED);
        OFQueueDescStatsRequest queueDescStatsRequestRead = OFQueueDescStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)QUEUE_DESC_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)queueDescStatsRequestBuilt, (Object)queueDescStatsRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])QUEUE_DESC_STATS_REQUEST_SERIALIZED);
        OFQueueDescStatsRequest queueDescStatsRequest = OFQueueDescStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)QUEUE_DESC_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        queueDescStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)QUEUE_DESC_STATS_REQUEST_SERIALIZED));
    }
}

