/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMeterFlags;
import org.projectfloodlight.openflow.protocol.OFMeterModCommand;
import org.projectfloodlight.openflow.protocol.OFRequestforward;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFRequestforwardVer15;

public class OFRequestforwardVer15Test {
    OFFactory factory;
    static final byte[] REQUESTFORWARD_SERIALIZED = new byte[]{6, 32, 0, 40, 18, 52, 86, 120, 6, 29, 0, 32, 17, 17, 17, 17, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 16, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFRequestforward.Builder builder = this.factory.buildRequestforward();
        builder.setXid(305419896L).setRequest((OFMessage)this.factory.buildMeterMod().setXid(0x11111111L).setCommand(OFMeterModCommand.ADD).setFlags((Set)ImmutableSet.of((Object)OFMeterFlags.KBPS)).setMeterId(1L).setBands((List)ImmutableList.of((Object)this.factory.meterBands().buildDrop().setRate(1L).setBurstSize(2L).build())).build()).build();
        OFRequestforward requestforward = builder.build();
        ByteBuf bb = Unpooled.buffer();
        requestforward.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)REQUESTFORWARD_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFRequestforward.Builder builder = this.factory.buildRequestforward();
        builder.setXid(305419896L).setRequest((OFMessage)this.factory.buildMeterMod().setXid(0x11111111L).setCommand(OFMeterModCommand.ADD).setFlags((Set)ImmutableSet.of((Object)OFMeterFlags.KBPS)).setMeterId(1L).setBands((List)ImmutableList.of((Object)this.factory.meterBands().buildDrop().setRate(1L).setBurstSize(2L).build())).build()).build();
        OFRequestforward requestforwardBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])REQUESTFORWARD_SERIALIZED);
        OFRequestforward requestforwardRead = OFRequestforwardVer15.READER.readFrom(input);
        Assert.assertEquals((long)REQUESTFORWARD_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)requestforwardBuilt, (Object)requestforwardRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])REQUESTFORWARD_SERIALIZED);
        OFRequestforward requestforward = OFRequestforwardVer15.READER.readFrom(input);
        Assert.assertEquals((long)REQUESTFORWARD_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        requestforward.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)REQUESTFORWARD_SERIALIZED));
    }
}

