/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFControllerRole;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFRoleRequest;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFRoleRequestVer15;
import org.projectfloodlight.openflow.types.U64;

public class OFRoleRequestVer15Test {
    OFFactory factory;
    static final byte[] ROLE_REQUEST_SERIALIZED = new byte[]{6, 24, 0, 24, 18, 52, 86, 120, 0, 0, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFRoleRequest.Builder builder = this.factory.buildRoleRequest();
        builder.setXid(305419896L).setRole(OFControllerRole.ROLE_MASTER).setShortId(1).setGenerationId(U64.of((long)1L)).build();
        OFRoleRequest roleRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        roleRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ROLE_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFRoleRequest.Builder builder = this.factory.buildRoleRequest();
        builder.setXid(305419896L).setRole(OFControllerRole.ROLE_MASTER).setShortId(1).setGenerationId(U64.of((long)1L)).build();
        OFRoleRequest roleRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])ROLE_REQUEST_SERIALIZED);
        OFRoleRequest roleRequestRead = OFRoleRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)ROLE_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)roleRequestBuilt, (Object)roleRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])ROLE_REQUEST_SERIALIZED);
        OFRoleRequest roleRequest = OFRoleRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)ROLE_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        roleRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ROLE_REQUEST_SERIALIZED));
    }
}

