/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFControllerRole;
import org.projectfloodlight.openflow.protocol.OFControllerRoleReason;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFRoleStatus;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFRoleStatusVer15;
import org.projectfloodlight.openflow.types.U64;

public class OFRoleStatusVer15Test {
    OFFactory factory;
    static final byte[] ROLE_STATUS_SERIALIZED = new byte[]{6, 30, 0, 40, 18, 52, 86, 120, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 16, 0, 92, 22, -57, 0, 0, 0, 55, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFRoleStatus.Builder builder = this.factory.buildRoleStatus();
        builder.setXid(305419896L).setRole(OFControllerRole.ROLE_SLAVE).setReason(OFControllerRoleReason.MASTER_REQUEST).setGenerationId(U64.of((long)1L)).setProperties((List)ImmutableList.of((Object)this.factory.buildRolePropBsn().setExperimenterData(new byte[]{0, 0, 0, 0}).build())).build();
        OFRoleStatus roleStatus = builder.build();
        ByteBuf bb = Unpooled.buffer();
        roleStatus.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ROLE_STATUS_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFRoleStatus.Builder builder = this.factory.buildRoleStatus();
        builder.setXid(305419896L).setRole(OFControllerRole.ROLE_SLAVE).setReason(OFControllerRoleReason.MASTER_REQUEST).setGenerationId(U64.of((long)1L)).setProperties((List)ImmutableList.of((Object)this.factory.buildRolePropBsn().setExperimenterData(new byte[]{0, 0, 0, 0}).build())).build();
        OFRoleStatus roleStatusBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])ROLE_STATUS_SERIALIZED);
        OFRoleStatus roleStatusRead = OFRoleStatusVer15.READER.readFrom(input);
        Assert.assertEquals((long)ROLE_STATUS_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)roleStatusBuilt, (Object)roleStatusRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])ROLE_STATUS_SERIALIZED);
        OFRoleStatus roleStatus = OFRoleStatusVer15.READER.readFrom(input);
        Assert.assertEquals((long)ROLE_STATUS_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        roleStatus.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ROLE_STATUS_SERIALIZED));
    }
}

