/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFTableConfig;
import org.projectfloodlight.openflow.protocol.OFTableDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFTableModPropEvictionFlag;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableDescStatsReplyVer15;
import org.projectfloodlight.openflow.types.TableId;

public class OFTableDescStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] TABLE_DESC_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 32, 18, 52, 86, 120, 0, 14, 0, 1, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 4, 0, 2, 0, 8, 0, 0, 0, 2};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFTableDescStatsReply.Builder builder = this.factory.buildTableDescStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildTableDesc().setTableId(TableId.of((int)0)).setConfig((Set)ImmutableSet.of((Object)OFTableConfig.EVICTION)).setProperties((List)ImmutableList.of((Object)this.factory.buildTableModPropEviction().setFlags((Set)ImmutableSet.of((Object)OFTableModPropEvictionFlag.IMPORTANCE)).build())).build())).build();
        OFTableDescStatsReply tableDescStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        tableDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)TABLE_DESC_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFTableDescStatsReply.Builder builder = this.factory.buildTableDescStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildTableDesc().setTableId(TableId.of((int)0)).setConfig((Set)ImmutableSet.of((Object)OFTableConfig.EVICTION)).setProperties((List)ImmutableList.of((Object)this.factory.buildTableModPropEviction().setFlags((Set)ImmutableSet.of((Object)OFTableModPropEvictionFlag.IMPORTANCE)).build())).build())).build();
        OFTableDescStatsReply tableDescStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])TABLE_DESC_STATS_REPLY_SERIALIZED);
        OFTableDescStatsReply tableDescStatsReplyRead = OFTableDescStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)TABLE_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)tableDescStatsReplyBuilt, (Object)tableDescStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])TABLE_DESC_STATS_REPLY_SERIALIZED);
        OFTableDescStatsReply tableDescStatsReply = OFTableDescStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)TABLE_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        tableDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)TABLE_DESC_STATS_REPLY_SERIALIZED));
    }
}

