/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFTableMod;
import org.projectfloodlight.openflow.protocol.OFTableModPropEvictionFlag;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableModVer15;
import org.projectfloodlight.openflow.types.TableId;

public class OFTableModVer15Test {
    OFFactory factory;
    static final byte[] TABLE_MOD_SERIALIZED = new byte[]{6, 17, 0, 24, 18, 52, 86, 120, 1, 0, 0, 0, 0, 0, 0, 4, 0, 2, 0, 8, 0, 0, 0, 2};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFTableMod.Builder builder = this.factory.buildTableMod();
        builder.setXid(305419896L).setTableId(TableId.of((int)1)).setConfig(4L).setProperties((List)ImmutableList.of((Object)this.factory.buildTableModPropEviction().setFlags((Set)ImmutableSet.of((Object)OFTableModPropEvictionFlag.IMPORTANCE)).build())).build();
        OFTableMod tableMod = builder.build();
        ByteBuf bb = Unpooled.buffer();
        tableMod.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)TABLE_MOD_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFTableMod.Builder builder = this.factory.buildTableMod();
        builder.setXid(305419896L).setTableId(TableId.of((int)1)).setConfig(4L).setProperties((List)ImmutableList.of((Object)this.factory.buildTableModPropEviction().setFlags((Set)ImmutableSet.of((Object)OFTableModPropEvictionFlag.IMPORTANCE)).build())).build();
        OFTableMod tableModBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])TABLE_MOD_SERIALIZED);
        OFTableMod tableModRead = OFTableModVer15.READER.readFrom(input);
        Assert.assertEquals((long)TABLE_MOD_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)tableModBuilt, (Object)tableModRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])TABLE_MOD_SERIALIZED);
        OFTableMod tableMod = OFTableModVer15.READER.readFrom(input);
        Assert.assertEquals((long)TABLE_MOD_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        tableMod.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)TABLE_MOD_SERIALIZED));
    }
}

