/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.types.VxlanNI;

public class VxlanNITest {
    @Test
    public void testValidMaxVni() {
        VxlanNI.ofVni((int)0xFFFFFF);
    }

    @Test
    public void testValidMinVni() {
        VxlanNI.ofVni((int)1);
    }

    @Test
    public void testVniEquals() {
        Assert.assertEquals((long)VxlanNI.ofVni((int)1).getVni(), (long)1L);
        Assert.assertEquals((long)VxlanNI.ofVni((int)0xFFFFFF).getVni(), (long)0xFFFFFFL);
    }

    @Test
    public void testVniObjects() {
        VxlanNI o = VxlanNI.ofVni((int)0xFFFFFF);
        VxlanNI m = VxlanNI.ofVni((int)0xFFFFFF);
        Assert.assertEquals((long)o.compareTo(m), (long)0L);
        Assert.assertEquals((long)o.getVni(), (long)m.getVni());
        Assert.assertFalse((!o.equals((Object)m) ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidVni1() {
        VxlanNI.ofVni((int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidVni2() {
        VxlanNI.ofVni((int)0xFFFFFFF);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidVni3() {
        VxlanNI.ofVni((int)0x1FFFFFFF);
    }
}

