// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFActionOnfCopyFieldVer13 implements OFActionOnfCopyField {
    private static final Logger logger = LoggerFactory.getLogger(OFActionOnfCopyFieldVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 24;

        private final static int DEFAULT_N_BITS = 0x0;
        private final static int DEFAULT_SRC_OFFSET = 0x0;
        private final static int DEFAULT_DST_OFFSET = 0x0;
        private final static long DEFAULT_SRC = 0x0L;
        private final static long DEFAULT_DST = 0x0L;

    // OF message fields
    private final int nBits;
    private final int srcOffset;
    private final int dstOffset;
    private final long src;
    private final long dst;
//
    // Immutable default instance
    final static OFActionOnfCopyFieldVer13 DEFAULT = new OFActionOnfCopyFieldVer13(
        DEFAULT_N_BITS, DEFAULT_SRC_OFFSET, DEFAULT_DST_OFFSET, DEFAULT_SRC, DEFAULT_DST
    );

    // package private constructor - used by readers, builders, and factory
    OFActionOnfCopyFieldVer13(int nBits, int srcOffset, int dstOffset, long src, long dst) {
        this.nBits = nBits;
        this.srcOffset = srcOffset;
        this.dstOffset = dstOffset;
        this.src = src;
        this.dst = dst;
    }

    // Accessors for OF message fields
    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x4f4e4600L;
    }

    @Override
    public int getExpType() {
        return 0xc80;
    }

    @Override
    public int getNBits() {
        return nBits;
    }

    @Override
    public int getSrcOffset() {
        return srcOffset;
    }

    @Override
    public int getDstOffset() {
        return dstOffset;
    }

    @Override
    public long getSrc() {
        return src;
    }

    @Override
    public long getDst() {
        return dst;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFActionOnfCopyField.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFActionOnfCopyField.Builder {
        final OFActionOnfCopyFieldVer13 parentMessage;

        // OF message fields
        private boolean nBitsSet;
        private int nBits;
        private boolean srcOffsetSet;
        private int srcOffset;
        private boolean dstOffsetSet;
        private int dstOffset;
        private boolean srcSet;
        private long src;
        private boolean dstSet;
        private long dst;

        BuilderWithParent(OFActionOnfCopyFieldVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x4f4e4600L;
    }

    @Override
    public int getExpType() {
        return 0xc80;
    }

    @Override
    public int getNBits() {
        return nBits;
    }

    @Override
    public OFActionOnfCopyField.Builder setNBits(int nBits) {
        this.nBits = nBits;
        this.nBitsSet = true;
        return this;
    }
    @Override
    public int getSrcOffset() {
        return srcOffset;
    }

    @Override
    public OFActionOnfCopyField.Builder setSrcOffset(int srcOffset) {
        this.srcOffset = srcOffset;
        this.srcOffsetSet = true;
        return this;
    }
    @Override
    public int getDstOffset() {
        return dstOffset;
    }

    @Override
    public OFActionOnfCopyField.Builder setDstOffset(int dstOffset) {
        this.dstOffset = dstOffset;
        this.dstOffsetSet = true;
        return this;
    }
    @Override
    public long getSrc() {
        return src;
    }

    @Override
    public OFActionOnfCopyField.Builder setSrc(long src) {
        this.src = src;
        this.srcSet = true;
        return this;
    }
    @Override
    public long getDst() {
        return dst;
    }

    @Override
    public OFActionOnfCopyField.Builder setDst(long dst) {
        this.dst = dst;
        this.dstSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFActionOnfCopyField build() {
                int nBits = this.nBitsSet ? this.nBits : parentMessage.nBits;
                int srcOffset = this.srcOffsetSet ? this.srcOffset : parentMessage.srcOffset;
                int dstOffset = this.dstOffsetSet ? this.dstOffset : parentMessage.dstOffset;
                long src = this.srcSet ? this.src : parentMessage.src;
                long dst = this.dstSet ? this.dst : parentMessage.dst;

                //
                return new OFActionOnfCopyFieldVer13(
                    nBits,
                    srcOffset,
                    dstOffset,
                    src,
                    dst
                );
        }

    }

    static class Builder implements OFActionOnfCopyField.Builder {
        // OF message fields
        private boolean nBitsSet;
        private int nBits;
        private boolean srcOffsetSet;
        private int srcOffset;
        private boolean dstOffsetSet;
        private int dstOffset;
        private boolean srcSet;
        private long src;
        private boolean dstSet;
        private long dst;

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 0x4f4e4600L;
    }

    @Override
    public int getExpType() {
        return 0xc80;
    }

    @Override
    public int getNBits() {
        return nBits;
    }

    @Override
    public OFActionOnfCopyField.Builder setNBits(int nBits) {
        this.nBits = nBits;
        this.nBitsSet = true;
        return this;
    }
    @Override
    public int getSrcOffset() {
        return srcOffset;
    }

    @Override
    public OFActionOnfCopyField.Builder setSrcOffset(int srcOffset) {
        this.srcOffset = srcOffset;
        this.srcOffsetSet = true;
        return this;
    }
    @Override
    public int getDstOffset() {
        return dstOffset;
    }

    @Override
    public OFActionOnfCopyField.Builder setDstOffset(int dstOffset) {
        this.dstOffset = dstOffset;
        this.dstOffsetSet = true;
        return this;
    }
    @Override
    public long getSrc() {
        return src;
    }

    @Override
    public OFActionOnfCopyField.Builder setSrc(long src) {
        this.src = src;
        this.srcSet = true;
        return this;
    }
    @Override
    public long getDst() {
        return dst;
    }

    @Override
    public OFActionOnfCopyField.Builder setDst(long dst) {
        this.dst = dst;
        this.dstSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFActionOnfCopyField build() {
            int nBits = this.nBitsSet ? this.nBits : DEFAULT_N_BITS;
            int srcOffset = this.srcOffsetSet ? this.srcOffset : DEFAULT_SRC_OFFSET;
            int dstOffset = this.dstOffsetSet ? this.dstOffset : DEFAULT_DST_OFFSET;
            long src = this.srcSet ? this.src : DEFAULT_SRC;
            long dst = this.dstSet ? this.dst : DEFAULT_DST;


            return new OFActionOnfCopyFieldVer13(
                    nBits,
                    srcOffset,
                    dstOffset,
                    src,
                    dst
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFActionOnfCopyField> {
        @Override
        public OFActionOnfCopyField readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 65535
            short type = bb.readShort();
            if(type != (short) 0xffff)
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 24)
                throw new OFParseError("Wrong length: Expected=24(24), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // fixed value property experimenter == 0x4f4e4600L
            int experimenter = bb.readInt();
            if(experimenter != 0x4f4e4600)
                throw new OFParseError("Wrong experimenter: Expected=0x4f4e4600L(0x4f4e4600L), got="+experimenter);
            // fixed value property expType == 0xc80
            short expType = bb.readShort();
            if(expType != (short) 0xc80)
                throw new OFParseError("Wrong expType: Expected=0xc80(0xc80), got="+expType);
            int nBits = U16.f(bb.readShort());
            int srcOffset = U16.f(bb.readShort());
            int dstOffset = U16.f(bb.readShort());
            long src = U32.f(bb.readInt());
            long dst = U32.f(bb.readInt());

            OFActionOnfCopyFieldVer13 actionOnfCopyFieldVer13 = new OFActionOnfCopyFieldVer13(
                    nBits,
                      srcOffset,
                      dstOffset,
                      src,
                      dst
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", actionOnfCopyFieldVer13);
            return actionOnfCopyFieldVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFActionOnfCopyFieldVer13Funnel FUNNEL = new OFActionOnfCopyFieldVer13Funnel();
    static class OFActionOnfCopyFieldVer13Funnel implements Funnel<OFActionOnfCopyFieldVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFActionOnfCopyFieldVer13 message, PrimitiveSink sink) {
            // fixed value property type = 65535
            sink.putShort((short) 0xffff);
            // fixed value property length = 24
            sink.putShort((short) 0x18);
            // fixed value property experimenter = 0x4f4e4600L
            sink.putInt(0x4f4e4600);
            // fixed value property expType = 0xc80
            sink.putShort((short) 0xc80);
            sink.putInt(message.nBits);
            sink.putInt(message.srcOffset);
            sink.putInt(message.dstOffset);
            sink.putLong(message.src);
            sink.putLong(message.dst);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFActionOnfCopyFieldVer13> {
        @Override
        public void write(ByteBuf bb, OFActionOnfCopyFieldVer13 message) {
            // fixed value property type = 65535
            bb.writeShort((short) 0xffff);
            // fixed value property length = 24
            bb.writeShort((short) 0x18);
            // fixed value property experimenter = 0x4f4e4600L
            bb.writeInt(0x4f4e4600);
            // fixed value property expType = 0xc80
            bb.writeShort((short) 0xc80);
            bb.writeShort(U16.t(message.nBits));
            bb.writeShort(U16.t(message.srcOffset));
            bb.writeShort(U16.t(message.dstOffset));
            bb.writeInt(U32.t(message.src));
            bb.writeInt(U32.t(message.dst));


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFActionOnfCopyFieldVer13(");
        b.append("nBits=").append(nBits);
        b.append(", ");
        b.append("srcOffset=").append(srcOffset);
        b.append(", ");
        b.append("dstOffset=").append(dstOffset);
        b.append(", ");
        b.append("src=").append(src);
        b.append(", ");
        b.append("dst=").append(dst);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFActionOnfCopyFieldVer13 other = (OFActionOnfCopyFieldVer13) obj;

        if( nBits != other.nBits)
            return false;
        if( srcOffset != other.srcOffset)
            return false;
        if( dstOffset != other.dstOffset)
            return false;
        if( src != other.src)
            return false;
        if( dst != other.dst)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + nBits;
        result = prime * result + srcOffset;
        result = prime * result + dstOffset;
        result = prime *  (int) (src ^ (src >>> 32));
        result = prime *  (int) (dst ^ (dst >>> 32));
        return result;
    }

}
