// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFCalientPortDescPropOpticalVer13 implements OFCalientPortDescPropOptical {
    private static final Logger logger = LoggerFactory.getLogger(OFCalientPortDescPropOpticalVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 240;

        private final static Set<OFCalientOpticalPortAdminState> DEFAULT_IN_ADMIN_STATUS = ImmutableSet.<OFCalientOpticalPortAdminState>of();
        private final static Set<OFCalientOpticalPortOperState> DEFAULT_IN_OPER_STATUS = ImmutableSet.<OFCalientOpticalPortOperState>of();
        private final static Set<OFCalientOpticalPortOperCapability> DEFAULT_IN_OPER_CAPABILITY = ImmutableSet.<OFCalientOpticalPortOperCapability>of();
        private final static Set<OFCalientOpticalPortAdminState> DEFAULT_OUT_ADMIN_STATUS = ImmutableSet.<OFCalientOpticalPortAdminState>of();
        private final static Set<OFCalientOpticalPortOperState> DEFAULT_OUT_OPER_STATUS = ImmutableSet.<OFCalientOpticalPortOperState>of();
        private final static Set<OFCalientOpticalPortOperCapability> DEFAULT_OUT_OPER_CAPABILITY = ImmutableSet.<OFCalientOpticalPortOperCapability>of();
        private final static String DEFAULT_INPORT_POWER = "";
        private final static String DEFAULT_OUTPORT_POWER = "";
        private final static U64 DEFAULT_IN_PEER_NODE = U64.ZERO;
        private final static U64 DEFAULT_OUT_PEER_NODE = U64.ZERO;
        private final static int DEFAULT_IN_PEER_PORT = 0x0;
        private final static int DEFAULT_OUT_PEER_PORT = 0x0;
        private final static String DEFAULT_IN_CIRCUIT_ID = "";
        private final static String DEFAULT_OUT_CIRCUIT_ID = "";
        private final static String DEFAULT_IN_ALIAS = "";
        private final static String DEFAULT_OUT_ALIAS = "";

    // OF message fields
    private final Set<OFCalientOpticalPortAdminState> inAdminStatus;
    private final Set<OFCalientOpticalPortOperState> inOperStatus;
    private final Set<OFCalientOpticalPortOperCapability> inOperCapability;
    private final Set<OFCalientOpticalPortAdminState> outAdminStatus;
    private final Set<OFCalientOpticalPortOperState> outOperStatus;
    private final Set<OFCalientOpticalPortOperCapability> outOperCapability;
    private final String inportPower;
    private final String outportPower;
    private final U64 inPeerNode;
    private final U64 outPeerNode;
    private final int inPeerPort;
    private final int outPeerPort;
    private final String inCircuitId;
    private final String outCircuitId;
    private final String inAlias;
    private final String outAlias;
//
    // Immutable default instance
    final static OFCalientPortDescPropOpticalVer13 DEFAULT = new OFCalientPortDescPropOpticalVer13(
        DEFAULT_IN_ADMIN_STATUS, DEFAULT_IN_OPER_STATUS, DEFAULT_IN_OPER_CAPABILITY, DEFAULT_OUT_ADMIN_STATUS, DEFAULT_OUT_OPER_STATUS, DEFAULT_OUT_OPER_CAPABILITY, DEFAULT_INPORT_POWER, DEFAULT_OUTPORT_POWER, DEFAULT_IN_PEER_NODE, DEFAULT_OUT_PEER_NODE, DEFAULT_IN_PEER_PORT, DEFAULT_OUT_PEER_PORT, DEFAULT_IN_CIRCUIT_ID, DEFAULT_OUT_CIRCUIT_ID, DEFAULT_IN_ALIAS, DEFAULT_OUT_ALIAS
    );

    // package private constructor - used by readers, builders, and factory
    OFCalientPortDescPropOpticalVer13(Set<OFCalientOpticalPortAdminState> inAdminStatus, Set<OFCalientOpticalPortOperState> inOperStatus, Set<OFCalientOpticalPortOperCapability> inOperCapability, Set<OFCalientOpticalPortAdminState> outAdminStatus, Set<OFCalientOpticalPortOperState> outOperStatus, Set<OFCalientOpticalPortOperCapability> outOperCapability, String inportPower, String outportPower, U64 inPeerNode, U64 outPeerNode, int inPeerPort, int outPeerPort, String inCircuitId, String outCircuitId, String inAlias, String outAlias) {
        if(inAdminStatus == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property inAdminStatus cannot be null");
        }
        if(inOperStatus == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property inOperStatus cannot be null");
        }
        if(inOperCapability == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property inOperCapability cannot be null");
        }
        if(outAdminStatus == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property outAdminStatus cannot be null");
        }
        if(outOperStatus == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property outOperStatus cannot be null");
        }
        if(outOperCapability == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property outOperCapability cannot be null");
        }
        if(inportPower == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property inportPower cannot be null");
        }
        if(outportPower == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property outportPower cannot be null");
        }
        if(inPeerNode == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property inPeerNode cannot be null");
        }
        if(outPeerNode == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property outPeerNode cannot be null");
        }
        if(inCircuitId == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property inCircuitId cannot be null");
        }
        if(outCircuitId == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property outCircuitId cannot be null");
        }
        if(inAlias == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property inAlias cannot be null");
        }
        if(outAlias == null) {
            throw new NullPointerException("OFCalientPortDescPropOpticalVer13: property outAlias cannot be null");
        }
        this.inAdminStatus = inAdminStatus;
        this.inOperStatus = inOperStatus;
        this.inOperCapability = inOperCapability;
        this.outAdminStatus = outAdminStatus;
        this.outOperStatus = outOperStatus;
        this.outOperCapability = outOperCapability;
        this.inportPower = inportPower;
        this.outportPower = outportPower;
        this.inPeerNode = inPeerNode;
        this.outPeerNode = outPeerNode;
        this.inPeerPort = inPeerPort;
        this.outPeerPort = outPeerPort;
        this.inCircuitId = inCircuitId;
        this.outCircuitId = outCircuitId;
        this.inAlias = inAlias;
        this.outAlias = outAlias;
    }

    // Accessors for OF message fields
    @Override
    public int getType() {
        return 0x2;
    }

    @Override
    public Set<OFCalientOpticalPortAdminState> getInAdminStatus() {
        return inAdminStatus;
    }

    @Override
    public Set<OFCalientOpticalPortOperState> getInOperStatus() {
        return inOperStatus;
    }

    @Override
    public Set<OFCalientOpticalPortOperCapability> getInOperCapability() {
        return inOperCapability;
    }

    @Override
    public Set<OFCalientOpticalPortAdminState> getOutAdminStatus() {
        return outAdminStatus;
    }

    @Override
    public Set<OFCalientOpticalPortOperState> getOutOperStatus() {
        return outOperStatus;
    }

    @Override
    public Set<OFCalientOpticalPortOperCapability> getOutOperCapability() {
        return outOperCapability;
    }

    @Override
    public String getInportPower() {
        return inportPower;
    }

    @Override
    public String getOutportPower() {
        return outportPower;
    }

    @Override
    public U64 getInPeerNode() {
        return inPeerNode;
    }

    @Override
    public U64 getOutPeerNode() {
        return outPeerNode;
    }

    @Override
    public int getInPeerPort() {
        return inPeerPort;
    }

    @Override
    public int getOutPeerPort() {
        return outPeerPort;
    }

    @Override
    public String getInCircuitId() {
        return inCircuitId;
    }

    @Override
    public String getOutCircuitId() {
        return outCircuitId;
    }

    @Override
    public String getInAlias() {
        return inAlias;
    }

    @Override
    public String getOutAlias() {
        return outAlias;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFCalientPortDescPropOptical.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFCalientPortDescPropOptical.Builder {
        final OFCalientPortDescPropOpticalVer13 parentMessage;

        // OF message fields
        private boolean inAdminStatusSet;
        private Set<OFCalientOpticalPortAdminState> inAdminStatus;
        private boolean inOperStatusSet;
        private Set<OFCalientOpticalPortOperState> inOperStatus;
        private boolean inOperCapabilitySet;
        private Set<OFCalientOpticalPortOperCapability> inOperCapability;
        private boolean outAdminStatusSet;
        private Set<OFCalientOpticalPortAdminState> outAdminStatus;
        private boolean outOperStatusSet;
        private Set<OFCalientOpticalPortOperState> outOperStatus;
        private boolean outOperCapabilitySet;
        private Set<OFCalientOpticalPortOperCapability> outOperCapability;
        private boolean inportPowerSet;
        private String inportPower;
        private boolean outportPowerSet;
        private String outportPower;
        private boolean inPeerNodeSet;
        private U64 inPeerNode;
        private boolean outPeerNodeSet;
        private U64 outPeerNode;
        private boolean inPeerPortSet;
        private int inPeerPort;
        private boolean outPeerPortSet;
        private int outPeerPort;
        private boolean inCircuitIdSet;
        private String inCircuitId;
        private boolean outCircuitIdSet;
        private String outCircuitId;
        private boolean inAliasSet;
        private String inAlias;
        private boolean outAliasSet;
        private String outAlias;

        BuilderWithParent(OFCalientPortDescPropOpticalVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getType() {
        return 0x2;
    }

    @Override
    public Set<OFCalientOpticalPortAdminState> getInAdminStatus() {
        return inAdminStatus;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInAdminStatus(Set<OFCalientOpticalPortAdminState> inAdminStatus) {
        this.inAdminStatus = inAdminStatus;
        this.inAdminStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperState> getInOperStatus() {
        return inOperStatus;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInOperStatus(Set<OFCalientOpticalPortOperState> inOperStatus) {
        this.inOperStatus = inOperStatus;
        this.inOperStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperCapability> getInOperCapability() {
        return inOperCapability;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInOperCapability(Set<OFCalientOpticalPortOperCapability> inOperCapability) {
        this.inOperCapability = inOperCapability;
        this.inOperCapabilitySet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortAdminState> getOutAdminStatus() {
        return outAdminStatus;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutAdminStatus(Set<OFCalientOpticalPortAdminState> outAdminStatus) {
        this.outAdminStatus = outAdminStatus;
        this.outAdminStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperState> getOutOperStatus() {
        return outOperStatus;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutOperStatus(Set<OFCalientOpticalPortOperState> outOperStatus) {
        this.outOperStatus = outOperStatus;
        this.outOperStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperCapability> getOutOperCapability() {
        return outOperCapability;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutOperCapability(Set<OFCalientOpticalPortOperCapability> outOperCapability) {
        this.outOperCapability = outOperCapability;
        this.outOperCapabilitySet = true;
        return this;
    }
    @Override
    public String getInportPower() {
        return inportPower;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInportPower(String inportPower) {
        this.inportPower = inportPower;
        this.inportPowerSet = true;
        return this;
    }
    @Override
    public String getOutportPower() {
        return outportPower;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutportPower(String outportPower) {
        this.outportPower = outportPower;
        this.outportPowerSet = true;
        return this;
    }
    @Override
    public U64 getInPeerNode() {
        return inPeerNode;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInPeerNode(U64 inPeerNode) {
        this.inPeerNode = inPeerNode;
        this.inPeerNodeSet = true;
        return this;
    }
    @Override
    public U64 getOutPeerNode() {
        return outPeerNode;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutPeerNode(U64 outPeerNode) {
        this.outPeerNode = outPeerNode;
        this.outPeerNodeSet = true;
        return this;
    }
    @Override
    public int getInPeerPort() {
        return inPeerPort;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInPeerPort(int inPeerPort) {
        this.inPeerPort = inPeerPort;
        this.inPeerPortSet = true;
        return this;
    }
    @Override
    public int getOutPeerPort() {
        return outPeerPort;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutPeerPort(int outPeerPort) {
        this.outPeerPort = outPeerPort;
        this.outPeerPortSet = true;
        return this;
    }
    @Override
    public String getInCircuitId() {
        return inCircuitId;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInCircuitId(String inCircuitId) {
        this.inCircuitId = inCircuitId;
        this.inCircuitIdSet = true;
        return this;
    }
    @Override
    public String getOutCircuitId() {
        return outCircuitId;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutCircuitId(String outCircuitId) {
        this.outCircuitId = outCircuitId;
        this.outCircuitIdSet = true;
        return this;
    }
    @Override
    public String getInAlias() {
        return inAlias;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInAlias(String inAlias) {
        this.inAlias = inAlias;
        this.inAliasSet = true;
        return this;
    }
    @Override
    public String getOutAlias() {
        return outAlias;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutAlias(String outAlias) {
        this.outAlias = outAlias;
        this.outAliasSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFCalientPortDescPropOptical build() {
                Set<OFCalientOpticalPortAdminState> inAdminStatus = this.inAdminStatusSet ? this.inAdminStatus : parentMessage.inAdminStatus;
                if(inAdminStatus == null)
                    throw new NullPointerException("Property inAdminStatus must not be null");
                Set<OFCalientOpticalPortOperState> inOperStatus = this.inOperStatusSet ? this.inOperStatus : parentMessage.inOperStatus;
                if(inOperStatus == null)
                    throw new NullPointerException("Property inOperStatus must not be null");
                Set<OFCalientOpticalPortOperCapability> inOperCapability = this.inOperCapabilitySet ? this.inOperCapability : parentMessage.inOperCapability;
                if(inOperCapability == null)
                    throw new NullPointerException("Property inOperCapability must not be null");
                Set<OFCalientOpticalPortAdminState> outAdminStatus = this.outAdminStatusSet ? this.outAdminStatus : parentMessage.outAdminStatus;
                if(outAdminStatus == null)
                    throw new NullPointerException("Property outAdminStatus must not be null");
                Set<OFCalientOpticalPortOperState> outOperStatus = this.outOperStatusSet ? this.outOperStatus : parentMessage.outOperStatus;
                if(outOperStatus == null)
                    throw new NullPointerException("Property outOperStatus must not be null");
                Set<OFCalientOpticalPortOperCapability> outOperCapability = this.outOperCapabilitySet ? this.outOperCapability : parentMessage.outOperCapability;
                if(outOperCapability == null)
                    throw new NullPointerException("Property outOperCapability must not be null");
                String inportPower = this.inportPowerSet ? this.inportPower : parentMessage.inportPower;
                if(inportPower == null)
                    throw new NullPointerException("Property inportPower must not be null");
                String outportPower = this.outportPowerSet ? this.outportPower : parentMessage.outportPower;
                if(outportPower == null)
                    throw new NullPointerException("Property outportPower must not be null");
                U64 inPeerNode = this.inPeerNodeSet ? this.inPeerNode : parentMessage.inPeerNode;
                if(inPeerNode == null)
                    throw new NullPointerException("Property inPeerNode must not be null");
                U64 outPeerNode = this.outPeerNodeSet ? this.outPeerNode : parentMessage.outPeerNode;
                if(outPeerNode == null)
                    throw new NullPointerException("Property outPeerNode must not be null");
                int inPeerPort = this.inPeerPortSet ? this.inPeerPort : parentMessage.inPeerPort;
                int outPeerPort = this.outPeerPortSet ? this.outPeerPort : parentMessage.outPeerPort;
                String inCircuitId = this.inCircuitIdSet ? this.inCircuitId : parentMessage.inCircuitId;
                if(inCircuitId == null)
                    throw new NullPointerException("Property inCircuitId must not be null");
                String outCircuitId = this.outCircuitIdSet ? this.outCircuitId : parentMessage.outCircuitId;
                if(outCircuitId == null)
                    throw new NullPointerException("Property outCircuitId must not be null");
                String inAlias = this.inAliasSet ? this.inAlias : parentMessage.inAlias;
                if(inAlias == null)
                    throw new NullPointerException("Property inAlias must not be null");
                String outAlias = this.outAliasSet ? this.outAlias : parentMessage.outAlias;
                if(outAlias == null)
                    throw new NullPointerException("Property outAlias must not be null");

                //
                return new OFCalientPortDescPropOpticalVer13(
                    inAdminStatus,
                    inOperStatus,
                    inOperCapability,
                    outAdminStatus,
                    outOperStatus,
                    outOperCapability,
                    inportPower,
                    outportPower,
                    inPeerNode,
                    outPeerNode,
                    inPeerPort,
                    outPeerPort,
                    inCircuitId,
                    outCircuitId,
                    inAlias,
                    outAlias
                );
        }

    }

    static class Builder implements OFCalientPortDescPropOptical.Builder {
        // OF message fields
        private boolean inAdminStatusSet;
        private Set<OFCalientOpticalPortAdminState> inAdminStatus;
        private boolean inOperStatusSet;
        private Set<OFCalientOpticalPortOperState> inOperStatus;
        private boolean inOperCapabilitySet;
        private Set<OFCalientOpticalPortOperCapability> inOperCapability;
        private boolean outAdminStatusSet;
        private Set<OFCalientOpticalPortAdminState> outAdminStatus;
        private boolean outOperStatusSet;
        private Set<OFCalientOpticalPortOperState> outOperStatus;
        private boolean outOperCapabilitySet;
        private Set<OFCalientOpticalPortOperCapability> outOperCapability;
        private boolean inportPowerSet;
        private String inportPower;
        private boolean outportPowerSet;
        private String outportPower;
        private boolean inPeerNodeSet;
        private U64 inPeerNode;
        private boolean outPeerNodeSet;
        private U64 outPeerNode;
        private boolean inPeerPortSet;
        private int inPeerPort;
        private boolean outPeerPortSet;
        private int outPeerPort;
        private boolean inCircuitIdSet;
        private String inCircuitId;
        private boolean outCircuitIdSet;
        private String outCircuitId;
        private boolean inAliasSet;
        private String inAlias;
        private boolean outAliasSet;
        private String outAlias;

    @Override
    public int getType() {
        return 0x2;
    }

    @Override
    public Set<OFCalientOpticalPortAdminState> getInAdminStatus() {
        return inAdminStatus;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInAdminStatus(Set<OFCalientOpticalPortAdminState> inAdminStatus) {
        this.inAdminStatus = inAdminStatus;
        this.inAdminStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperState> getInOperStatus() {
        return inOperStatus;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInOperStatus(Set<OFCalientOpticalPortOperState> inOperStatus) {
        this.inOperStatus = inOperStatus;
        this.inOperStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperCapability> getInOperCapability() {
        return inOperCapability;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInOperCapability(Set<OFCalientOpticalPortOperCapability> inOperCapability) {
        this.inOperCapability = inOperCapability;
        this.inOperCapabilitySet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortAdminState> getOutAdminStatus() {
        return outAdminStatus;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutAdminStatus(Set<OFCalientOpticalPortAdminState> outAdminStatus) {
        this.outAdminStatus = outAdminStatus;
        this.outAdminStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperState> getOutOperStatus() {
        return outOperStatus;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutOperStatus(Set<OFCalientOpticalPortOperState> outOperStatus) {
        this.outOperStatus = outOperStatus;
        this.outOperStatusSet = true;
        return this;
    }
    @Override
    public Set<OFCalientOpticalPortOperCapability> getOutOperCapability() {
        return outOperCapability;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutOperCapability(Set<OFCalientOpticalPortOperCapability> outOperCapability) {
        this.outOperCapability = outOperCapability;
        this.outOperCapabilitySet = true;
        return this;
    }
    @Override
    public String getInportPower() {
        return inportPower;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInportPower(String inportPower) {
        this.inportPower = inportPower;
        this.inportPowerSet = true;
        return this;
    }
    @Override
    public String getOutportPower() {
        return outportPower;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutportPower(String outportPower) {
        this.outportPower = outportPower;
        this.outportPowerSet = true;
        return this;
    }
    @Override
    public U64 getInPeerNode() {
        return inPeerNode;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInPeerNode(U64 inPeerNode) {
        this.inPeerNode = inPeerNode;
        this.inPeerNodeSet = true;
        return this;
    }
    @Override
    public U64 getOutPeerNode() {
        return outPeerNode;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutPeerNode(U64 outPeerNode) {
        this.outPeerNode = outPeerNode;
        this.outPeerNodeSet = true;
        return this;
    }
    @Override
    public int getInPeerPort() {
        return inPeerPort;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInPeerPort(int inPeerPort) {
        this.inPeerPort = inPeerPort;
        this.inPeerPortSet = true;
        return this;
    }
    @Override
    public int getOutPeerPort() {
        return outPeerPort;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutPeerPort(int outPeerPort) {
        this.outPeerPort = outPeerPort;
        this.outPeerPortSet = true;
        return this;
    }
    @Override
    public String getInCircuitId() {
        return inCircuitId;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInCircuitId(String inCircuitId) {
        this.inCircuitId = inCircuitId;
        this.inCircuitIdSet = true;
        return this;
    }
    @Override
    public String getOutCircuitId() {
        return outCircuitId;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutCircuitId(String outCircuitId) {
        this.outCircuitId = outCircuitId;
        this.outCircuitIdSet = true;
        return this;
    }
    @Override
    public String getInAlias() {
        return inAlias;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setInAlias(String inAlias) {
        this.inAlias = inAlias;
        this.inAliasSet = true;
        return this;
    }
    @Override
    public String getOutAlias() {
        return outAlias;
    }

    @Override
    public OFCalientPortDescPropOptical.Builder setOutAlias(String outAlias) {
        this.outAlias = outAlias;
        this.outAliasSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFCalientPortDescPropOptical build() {
            Set<OFCalientOpticalPortAdminState> inAdminStatus = this.inAdminStatusSet ? this.inAdminStatus : DEFAULT_IN_ADMIN_STATUS;
            if(inAdminStatus == null)
                throw new NullPointerException("Property inAdminStatus must not be null");
            Set<OFCalientOpticalPortOperState> inOperStatus = this.inOperStatusSet ? this.inOperStatus : DEFAULT_IN_OPER_STATUS;
            if(inOperStatus == null)
                throw new NullPointerException("Property inOperStatus must not be null");
            Set<OFCalientOpticalPortOperCapability> inOperCapability = this.inOperCapabilitySet ? this.inOperCapability : DEFAULT_IN_OPER_CAPABILITY;
            if(inOperCapability == null)
                throw new NullPointerException("Property inOperCapability must not be null");
            Set<OFCalientOpticalPortAdminState> outAdminStatus = this.outAdminStatusSet ? this.outAdminStatus : DEFAULT_OUT_ADMIN_STATUS;
            if(outAdminStatus == null)
                throw new NullPointerException("Property outAdminStatus must not be null");
            Set<OFCalientOpticalPortOperState> outOperStatus = this.outOperStatusSet ? this.outOperStatus : DEFAULT_OUT_OPER_STATUS;
            if(outOperStatus == null)
                throw new NullPointerException("Property outOperStatus must not be null");
            Set<OFCalientOpticalPortOperCapability> outOperCapability = this.outOperCapabilitySet ? this.outOperCapability : DEFAULT_OUT_OPER_CAPABILITY;
            if(outOperCapability == null)
                throw new NullPointerException("Property outOperCapability must not be null");
            String inportPower = this.inportPowerSet ? this.inportPower : DEFAULT_INPORT_POWER;
            if(inportPower == null)
                throw new NullPointerException("Property inportPower must not be null");
            String outportPower = this.outportPowerSet ? this.outportPower : DEFAULT_OUTPORT_POWER;
            if(outportPower == null)
                throw new NullPointerException("Property outportPower must not be null");
            U64 inPeerNode = this.inPeerNodeSet ? this.inPeerNode : DEFAULT_IN_PEER_NODE;
            if(inPeerNode == null)
                throw new NullPointerException("Property inPeerNode must not be null");
            U64 outPeerNode = this.outPeerNodeSet ? this.outPeerNode : DEFAULT_OUT_PEER_NODE;
            if(outPeerNode == null)
                throw new NullPointerException("Property outPeerNode must not be null");
            int inPeerPort = this.inPeerPortSet ? this.inPeerPort : DEFAULT_IN_PEER_PORT;
            int outPeerPort = this.outPeerPortSet ? this.outPeerPort : DEFAULT_OUT_PEER_PORT;
            String inCircuitId = this.inCircuitIdSet ? this.inCircuitId : DEFAULT_IN_CIRCUIT_ID;
            if(inCircuitId == null)
                throw new NullPointerException("Property inCircuitId must not be null");
            String outCircuitId = this.outCircuitIdSet ? this.outCircuitId : DEFAULT_OUT_CIRCUIT_ID;
            if(outCircuitId == null)
                throw new NullPointerException("Property outCircuitId must not be null");
            String inAlias = this.inAliasSet ? this.inAlias : DEFAULT_IN_ALIAS;
            if(inAlias == null)
                throw new NullPointerException("Property inAlias must not be null");
            String outAlias = this.outAliasSet ? this.outAlias : DEFAULT_OUT_ALIAS;
            if(outAlias == null)
                throw new NullPointerException("Property outAlias must not be null");


            return new OFCalientPortDescPropOpticalVer13(
                    inAdminStatus,
                    inOperStatus,
                    inOperCapability,
                    outAdminStatus,
                    outOperStatus,
                    outOperCapability,
                    inportPower,
                    outportPower,
                    inPeerNode,
                    outPeerNode,
                    inPeerPort,
                    outPeerPort,
                    inCircuitId,
                    outCircuitId,
                    inAlias,
                    outAlias
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFCalientPortDescPropOptical> {
        @Override
        public OFCalientPortDescPropOptical readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 0x2
            short type = bb.readShort();
            if(type != (short) 0x2)
                throw new OFParseError("Wrong type: Expected=0x2(0x2), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 240)
                throw new OFParseError("Wrong length: Expected=240(240), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            Set<OFCalientOpticalPortAdminState> inAdminStatus = OFCalientOpticalPortAdminStateSerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortOperState> inOperStatus = OFCalientOpticalPortOperStateSerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortOperCapability> inOperCapability = OFCalientOpticalPortOperCapabilitySerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortAdminState> outAdminStatus = OFCalientOpticalPortAdminStateSerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortOperState> outOperStatus = OFCalientOpticalPortOperStateSerializerVer13.readFrom(bb);
            Set<OFCalientOpticalPortOperCapability> outOperCapability = OFCalientOpticalPortOperCapabilitySerializerVer13.readFrom(bb);
            String inportPower = ChannelUtils.readFixedLengthString(bb, 6);
            String outportPower = ChannelUtils.readFixedLengthString(bb, 6);
            // pad: 2 bytes
            bb.skipBytes(2);
            U64 inPeerNode = U64.ofRaw(bb.readLong());
            U64 outPeerNode = U64.ofRaw(bb.readLong());
            int inPeerPort = U16.f(bb.readShort());
            int outPeerPort = U16.f(bb.readShort());
            // pad: 4 bytes
            bb.skipBytes(4);
            String inCircuitId = ChannelUtils.readFixedLengthString(bb, 32);
            String outCircuitId = ChannelUtils.readFixedLengthString(bb, 32);
            String inAlias = ChannelUtils.readFixedLengthString(bb, 64);
            String outAlias = ChannelUtils.readFixedLengthString(bb, 64);

            OFCalientPortDescPropOpticalVer13 calientPortDescPropOpticalVer13 = new OFCalientPortDescPropOpticalVer13(
                    inAdminStatus,
                      inOperStatus,
                      inOperCapability,
                      outAdminStatus,
                      outOperStatus,
                      outOperCapability,
                      inportPower,
                      outportPower,
                      inPeerNode,
                      outPeerNode,
                      inPeerPort,
                      outPeerPort,
                      inCircuitId,
                      outCircuitId,
                      inAlias,
                      outAlias
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", calientPortDescPropOpticalVer13);
            return calientPortDescPropOpticalVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFCalientPortDescPropOpticalVer13Funnel FUNNEL = new OFCalientPortDescPropOpticalVer13Funnel();
    static class OFCalientPortDescPropOpticalVer13Funnel implements Funnel<OFCalientPortDescPropOpticalVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFCalientPortDescPropOpticalVer13 message, PrimitiveSink sink) {
            // fixed value property type = 0x2
            sink.putShort((short) 0x2);
            // fixed value property length = 240
            sink.putShort((short) 0xf0);
            OFCalientOpticalPortAdminStateSerializerVer13.putTo(message.inAdminStatus, sink);
            OFCalientOpticalPortOperStateSerializerVer13.putTo(message.inOperStatus, sink);
            OFCalientOpticalPortOperCapabilitySerializerVer13.putTo(message.inOperCapability, sink);
            OFCalientOpticalPortAdminStateSerializerVer13.putTo(message.outAdminStatus, sink);
            OFCalientOpticalPortOperStateSerializerVer13.putTo(message.outOperStatus, sink);
            OFCalientOpticalPortOperCapabilitySerializerVer13.putTo(message.outOperCapability, sink);
            sink.putUnencodedChars(message.inportPower);
            sink.putUnencodedChars(message.outportPower);
            // skip pad (2 bytes)
            message.inPeerNode.putTo(sink);
            message.outPeerNode.putTo(sink);
            sink.putInt(message.inPeerPort);
            sink.putInt(message.outPeerPort);
            // skip pad (4 bytes)
            sink.putUnencodedChars(message.inCircuitId);
            sink.putUnencodedChars(message.outCircuitId);
            sink.putUnencodedChars(message.inAlias);
            sink.putUnencodedChars(message.outAlias);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFCalientPortDescPropOpticalVer13> {
        @Override
        public void write(ByteBuf bb, OFCalientPortDescPropOpticalVer13 message) {
            // fixed value property type = 0x2
            bb.writeShort((short) 0x2);
            // fixed value property length = 240
            bb.writeShort((short) 0xf0);
            OFCalientOpticalPortAdminStateSerializerVer13.writeTo(bb, message.inAdminStatus);
            OFCalientOpticalPortOperStateSerializerVer13.writeTo(bb, message.inOperStatus);
            OFCalientOpticalPortOperCapabilitySerializerVer13.writeTo(bb, message.inOperCapability);
            OFCalientOpticalPortAdminStateSerializerVer13.writeTo(bb, message.outAdminStatus);
            OFCalientOpticalPortOperStateSerializerVer13.writeTo(bb, message.outOperStatus);
            OFCalientOpticalPortOperCapabilitySerializerVer13.writeTo(bb, message.outOperCapability);
            ChannelUtils.writeFixedLengthString(bb, message.inportPower, 6);
            ChannelUtils.writeFixedLengthString(bb, message.outportPower, 6);
            // pad: 2 bytes
            bb.writeZero(2);
            bb.writeLong(message.inPeerNode.getValue());
            bb.writeLong(message.outPeerNode.getValue());
            bb.writeShort(U16.t(message.inPeerPort));
            bb.writeShort(U16.t(message.outPeerPort));
            // pad: 4 bytes
            bb.writeZero(4);
            ChannelUtils.writeFixedLengthString(bb, message.inCircuitId, 32);
            ChannelUtils.writeFixedLengthString(bb, message.outCircuitId, 32);
            ChannelUtils.writeFixedLengthString(bb, message.inAlias, 64);
            ChannelUtils.writeFixedLengthString(bb, message.outAlias, 64);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFCalientPortDescPropOpticalVer13(");
        b.append("inAdminStatus=").append(inAdminStatus);
        b.append(", ");
        b.append("inOperStatus=").append(inOperStatus);
        b.append(", ");
        b.append("inOperCapability=").append(inOperCapability);
        b.append(", ");
        b.append("outAdminStatus=").append(outAdminStatus);
        b.append(", ");
        b.append("outOperStatus=").append(outOperStatus);
        b.append(", ");
        b.append("outOperCapability=").append(outOperCapability);
        b.append(", ");
        b.append("inportPower=").append(inportPower);
        b.append(", ");
        b.append("outportPower=").append(outportPower);
        b.append(", ");
        b.append("inPeerNode=").append(inPeerNode);
        b.append(", ");
        b.append("outPeerNode=").append(outPeerNode);
        b.append(", ");
        b.append("inPeerPort=").append(inPeerPort);
        b.append(", ");
        b.append("outPeerPort=").append(outPeerPort);
        b.append(", ");
        b.append("inCircuitId=").append(inCircuitId);
        b.append(", ");
        b.append("outCircuitId=").append(outCircuitId);
        b.append(", ");
        b.append("inAlias=").append(inAlias);
        b.append(", ");
        b.append("outAlias=").append(outAlias);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFCalientPortDescPropOpticalVer13 other = (OFCalientPortDescPropOpticalVer13) obj;

        if (inAdminStatus == null) {
            if (other.inAdminStatus != null)
                return false;
        } else if (!inAdminStatus.equals(other.inAdminStatus))
            return false;
        if (inOperStatus == null) {
            if (other.inOperStatus != null)
                return false;
        } else if (!inOperStatus.equals(other.inOperStatus))
            return false;
        if (inOperCapability == null) {
            if (other.inOperCapability != null)
                return false;
        } else if (!inOperCapability.equals(other.inOperCapability))
            return false;
        if (outAdminStatus == null) {
            if (other.outAdminStatus != null)
                return false;
        } else if (!outAdminStatus.equals(other.outAdminStatus))
            return false;
        if (outOperStatus == null) {
            if (other.outOperStatus != null)
                return false;
        } else if (!outOperStatus.equals(other.outOperStatus))
            return false;
        if (outOperCapability == null) {
            if (other.outOperCapability != null)
                return false;
        } else if (!outOperCapability.equals(other.outOperCapability))
            return false;
        if (inportPower == null) {
            if (other.inportPower != null)
                return false;
        } else if (!inportPower.equals(other.inportPower))
            return false;
        if (outportPower == null) {
            if (other.outportPower != null)
                return false;
        } else if (!outportPower.equals(other.outportPower))
            return false;
        if (inPeerNode == null) {
            if (other.inPeerNode != null)
                return false;
        } else if (!inPeerNode.equals(other.inPeerNode))
            return false;
        if (outPeerNode == null) {
            if (other.outPeerNode != null)
                return false;
        } else if (!outPeerNode.equals(other.outPeerNode))
            return false;
        if( inPeerPort != other.inPeerPort)
            return false;
        if( outPeerPort != other.outPeerPort)
            return false;
        if (inCircuitId == null) {
            if (other.inCircuitId != null)
                return false;
        } else if (!inCircuitId.equals(other.inCircuitId))
            return false;
        if (outCircuitId == null) {
            if (other.outCircuitId != null)
                return false;
        } else if (!outCircuitId.equals(other.outCircuitId))
            return false;
        if (inAlias == null) {
            if (other.inAlias != null)
                return false;
        } else if (!inAlias.equals(other.inAlias))
            return false;
        if (outAlias == null) {
            if (other.outAlias != null)
                return false;
        } else if (!outAlias.equals(other.outAlias))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((inAdminStatus == null) ? 0 : inAdminStatus.hashCode());
        result = prime * result + ((inOperStatus == null) ? 0 : inOperStatus.hashCode());
        result = prime * result + ((inOperCapability == null) ? 0 : inOperCapability.hashCode());
        result = prime * result + ((outAdminStatus == null) ? 0 : outAdminStatus.hashCode());
        result = prime * result + ((outOperStatus == null) ? 0 : outOperStatus.hashCode());
        result = prime * result + ((outOperCapability == null) ? 0 : outOperCapability.hashCode());
        result = prime * result + ((inportPower == null) ? 0 : inportPower.hashCode());
        result = prime * result + ((outportPower == null) ? 0 : outportPower.hashCode());
        result = prime * result + ((inPeerNode == null) ? 0 : inPeerNode.hashCode());
        result = prime * result + ((outPeerNode == null) ? 0 : outPeerNode.hashCode());
        result = prime * result + inPeerPort;
        result = prime * result + outPeerPort;
        result = prime * result + ((inCircuitId == null) ? 0 : inCircuitId.hashCode());
        result = prime * result + ((outCircuitId == null) ? 0 : outCircuitId.hashCode());
        result = prime * result + ((inAlias == null) ? 0 : inAlias.hashCode());
        result = prime * result + ((outAlias == null) ? 0 : outAlias.hashCode());
        return result;
    }

}
