// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFCalientPortDescStatsReplyVer13 implements OFCalientPortDescStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFCalientPortDescStatsReplyVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int MINIMUM_LENGTH = 24;

        private final static long DEFAULT_XID = 0x0L;
        private final static Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.<OFStatsReplyFlags>of();
        private final static List<OFCalientPortDescStatsEntry> DEFAULT_PORT_DESC = ImmutableList.<OFCalientPortDescStatsEntry>of();

    // OF message fields
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final List<OFCalientPortDescStatsEntry> portDesc;
//
    // Immutable default instance
    final static OFCalientPortDescStatsReplyVer13 DEFAULT = new OFCalientPortDescStatsReplyVer13(
        DEFAULT_XID, DEFAULT_FLAGS, DEFAULT_PORT_DESC
    );

    // package private constructor - used by readers, builders, and factory
    OFCalientPortDescStatsReplyVer13(long xid, Set<OFStatsReplyFlags> flags, List<OFCalientPortDescStatsEntry> portDesc) {
        if(flags == null) {
            throw new NullPointerException("OFCalientPortDescStatsReplyVer13: property flags cannot be null");
        }
        if(portDesc == null) {
            throw new NullPointerException("OFCalientPortDescStatsReplyVer13: property portDesc cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.portDesc = portDesc;
    }

    // Accessors for OF message fields
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return flags;
    }

    @Override
    public long getExperimenter() {
        return 0x80f958L;
    }

    @Override
    public long getSubtype() {
        return 0x1L;
    }

    @Override
    public List<OFCalientPortDescStatsEntry> getPortDesc() {
        return portDesc;
    }



    public OFCalientPortDescStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFCalientPortDescStatsReply.Builder {
        final OFCalientPortDescStatsReplyVer13 parentMessage;

        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean portDescSet;
        private List<OFCalientPortDescStatsEntry> portDesc;

        BuilderWithParent(OFCalientPortDescStatsReplyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFCalientPortDescStatsReply.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return flags;
    }

    @Override
    public OFCalientPortDescStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public long getExperimenter() {
        return 0x80f958L;
    }

    @Override
    public long getSubtype() {
        return 0x1L;
    }

    @Override
    public List<OFCalientPortDescStatsEntry> getPortDesc() {
        return portDesc;
    }

    @Override
    public OFCalientPortDescStatsReply.Builder setPortDesc(List<OFCalientPortDescStatsEntry> portDesc) {
        this.portDesc = portDesc;
        this.portDescSet = true;
        return this;
    }


        @Override
        public OFCalientPortDescStatsReply build() {
                long xid = this.xidSet ? this.xid : parentMessage.xid;
                Set<OFStatsReplyFlags> flags = this.flagsSet ? this.flags : parentMessage.flags;
                if(flags == null)
                    throw new NullPointerException("Property flags must not be null");
                List<OFCalientPortDescStatsEntry> portDesc = this.portDescSet ? this.portDesc : parentMessage.portDesc;
                if(portDesc == null)
                    throw new NullPointerException("Property portDesc must not be null");

                //
                return new OFCalientPortDescStatsReplyVer13(
                    xid,
                    flags,
                    portDesc
                );
        }

    }

    static class Builder implements OFCalientPortDescStatsReply.Builder {
        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean portDescSet;
        private List<OFCalientPortDescStatsEntry> portDesc;

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFCalientPortDescStatsReply.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return flags;
    }

    @Override
    public OFCalientPortDescStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public long getExperimenter() {
        return 0x80f958L;
    }

    @Override
    public long getSubtype() {
        return 0x1L;
    }

    @Override
    public List<OFCalientPortDescStatsEntry> getPortDesc() {
        return portDesc;
    }

    @Override
    public OFCalientPortDescStatsReply.Builder setPortDesc(List<OFCalientPortDescStatsEntry> portDesc) {
        this.portDesc = portDesc;
        this.portDescSet = true;
        return this;
    }
//
        @Override
        public OFCalientPortDescStatsReply build() {
            long xid = this.xidSet ? this.xid : DEFAULT_XID;
            Set<OFStatsReplyFlags> flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if(flags == null)
                throw new NullPointerException("Property flags must not be null");
            List<OFCalientPortDescStatsEntry> portDesc = this.portDescSet ? this.portDesc : DEFAULT_PORT_DESC;
            if(portDesc == null)
                throw new NullPointerException("Property portDesc must not be null");


            return new OFCalientPortDescStatsReplyVer13(
                    xid,
                    flags,
                    portDesc
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFCalientPortDescStatsReply> {
        @Override
        public OFCalientPortDescStatsReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property version == 4
            byte version = bb.readByte();
            if(version != (byte) 0x4)
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got="+version);
            // fixed value property type == 19
            byte type = bb.readByte();
            if(type != (byte) 0x13)
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            long xid = U32.f(bb.readInt());
            // fixed value property statsType == 65535
            short statsType = bb.readShort();
            if(statsType != (short) 0xffff)
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got="+statsType);
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer13.readFrom(bb);
            // pad: 4 bytes
            bb.skipBytes(4);
            // fixed value property experimenter == 0x80f958L
            int experimenter = bb.readInt();
            if(experimenter != 0x80f958)
                throw new OFParseError("Wrong experimenter: Expected=0x80f958L(0x80f958L), got="+experimenter);
            // fixed value property subtype == 0x1L
            int subtype = bb.readInt();
            if(subtype != 0x1)
                throw new OFParseError("Wrong subtype: Expected=0x1L(0x1L), got="+subtype);
            List<OFCalientPortDescStatsEntry> portDesc = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFCalientPortDescStatsEntryVer13.READER);

            OFCalientPortDescStatsReplyVer13 calientPortDescStatsReplyVer13 = new OFCalientPortDescStatsReplyVer13(
                    xid,
                      flags,
                      portDesc
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", calientPortDescStatsReplyVer13);
            return calientPortDescStatsReplyVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFCalientPortDescStatsReplyVer13Funnel FUNNEL = new OFCalientPortDescStatsReplyVer13Funnel();
    static class OFCalientPortDescStatsReplyVer13Funnel implements Funnel<OFCalientPortDescStatsReplyVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFCalientPortDescStatsReplyVer13 message, PrimitiveSink sink) {
            // fixed value property version = 4
            sink.putByte((byte) 0x4);
            // fixed value property type = 19
            sink.putByte((byte) 0x13);
            // FIXME: skip funnel of length
            sink.putLong(message.xid);
            // fixed value property statsType = 65535
            sink.putShort((short) 0xffff);
            OFStatsReplyFlagsSerializerVer13.putTo(message.flags, sink);
            // skip pad (4 bytes)
            // fixed value property experimenter = 0x80f958L
            sink.putInt(0x80f958);
            // fixed value property subtype = 0x1L
            sink.putInt(0x1);
            FunnelUtils.putList(message.portDesc, sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFCalientPortDescStatsReplyVer13> {
        @Override
        public void write(ByteBuf bb, OFCalientPortDescStatsReplyVer13 message) {
            int startIndex = bb.writerIndex();
            // fixed value property version = 4
            bb.writeByte((byte) 0x4);
            // fixed value property type = 19
            bb.writeByte((byte) 0x13);
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            bb.writeInt(U32.t(message.xid));
            // fixed value property statsType = 65535
            bb.writeShort((short) 0xffff);
            OFStatsReplyFlagsSerializerVer13.writeTo(bb, message.flags);
            // pad: 4 bytes
            bb.writeZero(4);
            // fixed value property experimenter = 0x80f958L
            bb.writeInt(0x80f958);
            // fixed value property subtype = 0x1L
            bb.writeInt(0x1);
            ChannelUtils.writeList(bb, message.portDesc);

            // update length field
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFCalientPortDescStatsReplyVer13(");
        b.append("xid=").append(xid);
        b.append(", ");
        b.append("flags=").append(flags);
        b.append(", ");
        b.append("portDesc=").append(portDesc);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFCalientPortDescStatsReplyVer13 other = (OFCalientPortDescStatsReplyVer13) obj;

        if( xid != other.xid)
            return false;
        if (flags == null) {
            if (other.flags != null)
                return false;
        } else if (!flags.equals(other.flags))
            return false;
        if (portDesc == null) {
            if (other.portDesc != null)
                return false;
        } else if (!portDesc.equals(other.portDesc))
            return false;
        return true;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFCalientPortDescStatsReplyVer13 other = (OFCalientPortDescStatsReplyVer13) obj;

        // ignore XID
        if (flags == null) {
            if (other.flags != null)
                return false;
        } else if (!flags.equals(other.flags))
            return false;
        if (portDesc == null) {
            if (other.portDesc != null)
                return false;
        } else if (!portDesc.equals(other.portDesc))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime *  (int) (xid ^ (xid >>> 32));
        result = prime * result + ((flags == null) ? 0 : flags.hashCode());
        result = prime * result + ((portDesc == null) ? 0 : portDesc.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        final int prime = 31;
        int result = 1;

        // ignore XID
        result = prime * result + ((flags == null) ? 0 : flags.hashCode());
        result = prime * result + ((portDesc == null) ? 0 : portDesc.hashCode());
        return result;
    }

}
