// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFExpPortAdidOtnVer13 implements OFExpPortAdidOtn {
    private static final Logger logger = LoggerFactory.getLogger(OFExpPortAdidOtnVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int LENGTH = 72;

        private final static int DEFAULT_TYPE = 0x0;
        private final static OFBitMask128 DEFAULT_SAPI = OFBitMask128.NONE;
        private final static OFBitMask128 DEFAULT_DAPI = OFBitMask128.NONE;
        private final static OFBitMask256 DEFAULT_OPSPEC = OFBitMask256.NONE;

    // OF message fields
    private final int type;
    private final OFBitMask128 sapi;
    private final OFBitMask128 dapi;
    private final OFBitMask256 opspec;
//
    // Immutable default instance
    final static OFExpPortAdidOtnVer13 DEFAULT = new OFExpPortAdidOtnVer13(
        DEFAULT_TYPE, DEFAULT_SAPI, DEFAULT_DAPI, DEFAULT_OPSPEC
    );

    // package private constructor - used by readers, builders, and factory
    OFExpPortAdidOtnVer13(int type, OFBitMask128 sapi, OFBitMask128 dapi, OFBitMask256 opspec) {
        if(sapi == null) {
            throw new NullPointerException("OFExpPortAdidOtnVer13: property sapi cannot be null");
        }
        if(dapi == null) {
            throw new NullPointerException("OFExpPortAdidOtnVer13: property dapi cannot be null");
        }
        if(opspec == null) {
            throw new NullPointerException("OFExpPortAdidOtnVer13: property opspec cannot be null");
        }
        this.type = type;
        this.sapi = sapi;
        this.dapi = dapi;
        this.opspec = opspec;
    }

    // Accessors for OF message fields
    @Override
    public int getType() {
        return type;
    }

    @Override
    public int getNamespace() {
        return 0x0;
    }

    @Override
    public int getNsType() {
        return 0x0;
    }

    @Override
    public OFBitMask128 getSapi() {
        return sapi;
    }

    @Override
    public OFBitMask128 getDapi() {
        return dapi;
    }

    @Override
    public OFBitMask256 getOpspec() {
        return opspec;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFExpPortAdidOtn.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFExpPortAdidOtn.Builder {
        final OFExpPortAdidOtnVer13 parentMessage;

        // OF message fields
        private boolean typeSet;
        private int type;
        private boolean sapiSet;
        private OFBitMask128 sapi;
        private boolean dapiSet;
        private OFBitMask128 dapi;
        private boolean opspecSet;
        private OFBitMask256 opspec;

        BuilderWithParent(OFExpPortAdidOtnVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getType() {
        return type;
    }

    @Override
    public OFExpPortAdidOtn.Builder setType(int type) {
        this.type = type;
        this.typeSet = true;
        return this;
    }
    @Override
    public int getNamespace() {
        return 0x0;
    }

    @Override
    public int getNsType() {
        return 0x0;
    }

    @Override
    public OFBitMask128 getSapi() {
        return sapi;
    }

    @Override
    public OFExpPortAdidOtn.Builder setSapi(OFBitMask128 sapi) {
        this.sapi = sapi;
        this.sapiSet = true;
        return this;
    }
    @Override
    public OFBitMask128 getDapi() {
        return dapi;
    }

    @Override
    public OFExpPortAdidOtn.Builder setDapi(OFBitMask128 dapi) {
        this.dapi = dapi;
        this.dapiSet = true;
        return this;
    }
    @Override
    public OFBitMask256 getOpspec() {
        return opspec;
    }

    @Override
    public OFExpPortAdidOtn.Builder setOpspec(OFBitMask256 opspec) {
        this.opspec = opspec;
        this.opspecSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFExpPortAdidOtn build() {
                int type = this.typeSet ? this.type : parentMessage.type;
                OFBitMask128 sapi = this.sapiSet ? this.sapi : parentMessage.sapi;
                if(sapi == null)
                    throw new NullPointerException("Property sapi must not be null");
                OFBitMask128 dapi = this.dapiSet ? this.dapi : parentMessage.dapi;
                if(dapi == null)
                    throw new NullPointerException("Property dapi must not be null");
                OFBitMask256 opspec = this.opspecSet ? this.opspec : parentMessage.opspec;
                if(opspec == null)
                    throw new NullPointerException("Property opspec must not be null");

                //
                return new OFExpPortAdidOtnVer13(
                    type,
                    sapi,
                    dapi,
                    opspec
                );
        }

    }

    static class Builder implements OFExpPortAdidOtn.Builder {
        // OF message fields
        private boolean typeSet;
        private int type;
        private boolean sapiSet;
        private OFBitMask128 sapi;
        private boolean dapiSet;
        private OFBitMask128 dapi;
        private boolean opspecSet;
        private OFBitMask256 opspec;

    @Override
    public int getType() {
        return type;
    }

    @Override
    public OFExpPortAdidOtn.Builder setType(int type) {
        this.type = type;
        this.typeSet = true;
        return this;
    }
    @Override
    public int getNamespace() {
        return 0x0;
    }

    @Override
    public int getNsType() {
        return 0x0;
    }

    @Override
    public OFBitMask128 getSapi() {
        return sapi;
    }

    @Override
    public OFExpPortAdidOtn.Builder setSapi(OFBitMask128 sapi) {
        this.sapi = sapi;
        this.sapiSet = true;
        return this;
    }
    @Override
    public OFBitMask128 getDapi() {
        return dapi;
    }

    @Override
    public OFExpPortAdidOtn.Builder setDapi(OFBitMask128 dapi) {
        this.dapi = dapi;
        this.dapiSet = true;
        return this;
    }
    @Override
    public OFBitMask256 getOpspec() {
        return opspec;
    }

    @Override
    public OFExpPortAdidOtn.Builder setOpspec(OFBitMask256 opspec) {
        this.opspec = opspec;
        this.opspecSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFExpPortAdidOtn build() {
            int type = this.typeSet ? this.type : DEFAULT_TYPE;
            OFBitMask128 sapi = this.sapiSet ? this.sapi : DEFAULT_SAPI;
            if(sapi == null)
                throw new NullPointerException("Property sapi must not be null");
            OFBitMask128 dapi = this.dapiSet ? this.dapi : DEFAULT_DAPI;
            if(dapi == null)
                throw new NullPointerException("Property dapi must not be null");
            OFBitMask256 opspec = this.opspecSet ? this.opspec : DEFAULT_OPSPEC;
            if(opspec == null)
                throw new NullPointerException("Property opspec must not be null");


            return new OFExpPortAdidOtnVer13(
                    type,
                    sapi,
                    dapi,
                    opspec
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFExpPortAdidOtn> {
        @Override
        public OFExpPortAdidOtn readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int type = U16.f(bb.readShort());
            int length = U16.f(bb.readShort());
            if(length != 72)
                throw new OFParseError("Wrong length: Expected=72(72), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // fixed value property namespace == 0x0
            short namespace = bb.readShort();
            if(namespace != (short) 0x0)
                throw new OFParseError("Wrong namespace: Expected=0x0(0x0), got="+namespace);
            // fixed value property nsType == 0x0
            short nsType = bb.readShort();
            if(nsType != (short) 0x0)
                throw new OFParseError("Wrong nsType: Expected=0x0(0x0), got="+nsType);
            OFBitMask128 sapi = OFBitMask128.read16Bytes(bb);
            OFBitMask128 dapi = OFBitMask128.read16Bytes(bb);
            OFBitMask256 opspec = OFBitMask256.read32Bytes(bb);

            OFExpPortAdidOtnVer13 expPortAdidOtnVer13 = new OFExpPortAdidOtnVer13(
                    type,
                      sapi,
                      dapi,
                      opspec
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", expPortAdidOtnVer13);
            return expPortAdidOtnVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFExpPortAdidOtnVer13Funnel FUNNEL = new OFExpPortAdidOtnVer13Funnel();
    static class OFExpPortAdidOtnVer13Funnel implements Funnel<OFExpPortAdidOtnVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFExpPortAdidOtnVer13 message, PrimitiveSink sink) {
            sink.putInt(message.type);
            // fixed value property length = 72
            sink.putShort((short) 0x48);
            // fixed value property namespace = 0x0
            sink.putShort((short) 0x0);
            // fixed value property nsType = 0x0
            sink.putShort((short) 0x0);
            message.sapi.putTo(sink);
            message.dapi.putTo(sink);
            message.opspec.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFExpPortAdidOtnVer13> {
        @Override
        public void write(ByteBuf bb, OFExpPortAdidOtnVer13 message) {
            bb.writeShort(U16.t(message.type));
            // fixed value property length = 72
            bb.writeShort((short) 0x48);
            // fixed value property namespace = 0x0
            bb.writeShort((short) 0x0);
            // fixed value property nsType = 0x0
            bb.writeShort((short) 0x0);
            message.sapi.write16Bytes(bb);
            message.dapi.write16Bytes(bb);
            message.opspec.write32Bytes(bb);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFExpPortAdidOtnVer13(");
        b.append("type=").append(type);
        b.append(", ");
        b.append("sapi=").append(sapi);
        b.append(", ");
        b.append("dapi=").append(dapi);
        b.append(", ");
        b.append("opspec=").append(opspec);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFExpPortAdidOtnVer13 other = (OFExpPortAdidOtnVer13) obj;

        if( type != other.type)
            return false;
        if (sapi == null) {
            if (other.sapi != null)
                return false;
        } else if (!sapi.equals(other.sapi))
            return false;
        if (dapi == null) {
            if (other.dapi != null)
                return false;
        } else if (!dapi.equals(other.dapi))
            return false;
        if (opspec == null) {
            if (other.opspec != null)
                return false;
        } else if (!opspec.equals(other.opspec))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + type;
        result = prime * result + ((sapi == null) ? 0 : sapi.hashCode());
        result = prime * result + ((dapi == null) ? 0 : dapi.hashCode());
        result = prime * result + ((opspec == null) ? 0 : opspec.hashCode());
        return result;
    }

}
