// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver13;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import com.google.common.collect.ImmutableList;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFExpPortOpticalTransportLayerStackVer13 implements OFExpPortOpticalTransportLayerStack {
    private static final Logger logger = LoggerFactory.getLogger(OFExpPortOpticalTransportLayerStackVer13.class);
    // version: 1.3
    final static byte WIRE_VERSION = 4;
    final static int MINIMUM_LENGTH = 8;

        private final static List<OFExpPortOpticalTransportLayerEntry> DEFAULT_VALUE = ImmutableList.<OFExpPortOpticalTransportLayerEntry>of();

    // OF message fields
    private final List<OFExpPortOpticalTransportLayerEntry> value;
//
    // Immutable default instance
    final static OFExpPortOpticalTransportLayerStackVer13 DEFAULT = new OFExpPortOpticalTransportLayerStackVer13(
        DEFAULT_VALUE
    );

    // package private constructor - used by readers, builders, and factory
    OFExpPortOpticalTransportLayerStackVer13(List<OFExpPortOpticalTransportLayerEntry> value) {
        if(value == null) {
            throw new NullPointerException("OFExpPortOpticalTransportLayerStackVer13: property value cannot be null");
        }
        this.value = value;
    }

    // Accessors for OF message fields
    @Override
    public int getFeatureType() {
        return 0x2;
    }

    @Override
    public List<OFExpPortOpticalTransportLayerEntry> getValue() {
        return value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



    public OFExpPortOpticalTransportLayerStack.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFExpPortOpticalTransportLayerStack.Builder {
        final OFExpPortOpticalTransportLayerStackVer13 parentMessage;

        // OF message fields
        private boolean valueSet;
        private List<OFExpPortOpticalTransportLayerEntry> value;

        BuilderWithParent(OFExpPortOpticalTransportLayerStackVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getFeatureType() {
        return 0x2;
    }

    @Override
    public List<OFExpPortOpticalTransportLayerEntry> getValue() {
        return value;
    }

    @Override
    public OFExpPortOpticalTransportLayerStack.Builder setValue(List<OFExpPortOpticalTransportLayerEntry> value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }



        @Override
        public OFExpPortOpticalTransportLayerStack build() {
                List<OFExpPortOpticalTransportLayerEntry> value = this.valueSet ? this.value : parentMessage.value;
                if(value == null)
                    throw new NullPointerException("Property value must not be null");

                //
                return new OFExpPortOpticalTransportLayerStackVer13(
                    value
                );
        }

    }

    static class Builder implements OFExpPortOpticalTransportLayerStack.Builder {
        // OF message fields
        private boolean valueSet;
        private List<OFExpPortOpticalTransportLayerEntry> value;

    @Override
    public int getFeatureType() {
        return 0x2;
    }

    @Override
    public List<OFExpPortOpticalTransportLayerEntry> getValue() {
        return value;
    }

    @Override
    public OFExpPortOpticalTransportLayerStack.Builder setValue(List<OFExpPortOpticalTransportLayerEntry> value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

//
        @Override
        public OFExpPortOpticalTransportLayerStack build() {
            List<OFExpPortOpticalTransportLayerEntry> value = this.valueSet ? this.value : DEFAULT_VALUE;
            if(value == null)
                throw new NullPointerException("Property value must not be null");


            return new OFExpPortOpticalTransportLayerStackVer13(
                    value
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFExpPortOpticalTransportLayerStack> {
        @Override
        public OFExpPortOpticalTransportLayerStack readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property featureType == 0x2
            short featureType = bb.readShort();
            if(featureType != (short) 0x2)
                throw new OFParseError("Wrong featureType: Expected=0x2(0x2), got="+featureType);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // pad: 4 bytes
            bb.skipBytes(4);
            List<OFExpPortOpticalTransportLayerEntry> value = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFExpPortOpticalTransportLayerEntryVer13.READER);

            OFExpPortOpticalTransportLayerStackVer13 expPortOpticalTransportLayerStackVer13 = new OFExpPortOpticalTransportLayerStackVer13(
                    value
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", expPortOpticalTransportLayerStackVer13);
            return expPortOpticalTransportLayerStackVer13;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFExpPortOpticalTransportLayerStackVer13Funnel FUNNEL = new OFExpPortOpticalTransportLayerStackVer13Funnel();
    static class OFExpPortOpticalTransportLayerStackVer13Funnel implements Funnel<OFExpPortOpticalTransportLayerStackVer13> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFExpPortOpticalTransportLayerStackVer13 message, PrimitiveSink sink) {
            // fixed value property featureType = 0x2
            sink.putShort((short) 0x2);
            // FIXME: skip funnel of length
            // skip pad (4 bytes)
            FunnelUtils.putList(message.value, sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFExpPortOpticalTransportLayerStackVer13> {
        @Override
        public void write(ByteBuf bb, OFExpPortOpticalTransportLayerStackVer13 message) {
            int startIndex = bb.writerIndex();
            // fixed value property featureType = 0x2
            bb.writeShort((short) 0x2);
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            // pad: 4 bytes
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.value);

            // update length field
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFExpPortOpticalTransportLayerStackVer13(");
        b.append("value=").append(value);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFExpPortOpticalTransportLayerStackVer13 other = (OFExpPortOpticalTransportLayerStackVer13) obj;

        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

}
